/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fonts;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.apps.FOPException;
import org.apache.fop.fonts.EmbedFontInfo;
import org.apache.fop.fonts.FontAdder;
import org.apache.fop.fonts.FontDetector;
import org.apache.fop.fonts.FontEventListener;
import org.apache.fop.fonts.FontManager;
import org.apache.fop.fonts.autodetect.FontFileFinder;
import org.apache.fop.util.LogUtil;
import org.apache.xmlgraphics.util.ClasspathResource;

public final class FontDetectorFactory {
    private FontDetectorFactory() {
    }

    public static FontDetector createDefault() {
        return new DefaultFontDetector();
    }

    public static FontDetector createDisabled() {
        return new DisabledFontDetector();
    }

    private static class DefaultFontDetector
    implements FontDetector {
        private static Log log = LogFactory.getLog(DefaultFontDetector.class);
        private static final String[] FONT_MIMETYPES = new String[]{"application/x-font", "application/x-font-truetype"};

        private DefaultFontDetector() {
        }

        @Override
        public void detect(FontManager fontManager, FontAdder fontAdder, boolean strict, FontEventListener eventListener, List<EmbedFontInfo> fontInfoList) throws FOPException {
            try {
                FontFileFinder fontFileFinder = new FontFileFinder(eventListener);
                URI fontBaseURI = fontManager.getResourceResolver().getBaseURI();
                File fontBase = FileUtils.toFile(fontBaseURI.toURL());
                if (fontBase != null) {
                    List<URL> fontURLList = fontFileFinder.find(fontBase.getAbsolutePath());
                    fontAdder.add(fontURLList, fontInfoList);
                }
                List<URL> systemFontList = fontFileFinder.find();
                fontAdder.add(systemFontList, fontInfoList);
                ClasspathResource resource = ClasspathResource.getInstance();
                for (String mimeTypes : FONT_MIMETYPES) {
                    fontAdder.add(resource.listResourcesOfMimeType(mimeTypes), fontInfoList);
                }
            }
            catch (IOException e) {
                LogUtil.handleException((Log)log, (Exception)e, (boolean)strict);
            }
            catch (URISyntaxException use) {
                LogUtil.handleException((Log)log, (Exception)use, (boolean)strict);
            }
        }
    }

    private static class DisabledFontDetector
    implements FontDetector {
        private DisabledFontDetector() {
        }

        @Override
        public void detect(FontManager fontManager, FontAdder fontAdder, boolean strict, FontEventListener eventListener, List<EmbedFontInfo> fontInfoList) throws FOPException {
        }
    }
}

