# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.data_object_algorithm import DataObjectAlgorithm


class ReebGraphVolumeSkeletonFilter(DataObjectAlgorithm):
    """
    ReebGraphVolumeSkeletonFilter - compute a skeletal embedding of the
    
    Superclass: DataObjectAlgorithm
    
    Reeb graph of a scalar field defined on a tetrahedral mesh
    (vtk_unstructured_grid).
    
    The filter takes a UnstructuredGrid as an input (port 0), along
    with a ReebGraph (port 1). The filter samples each arc of the Reeb
    graph and embeds the samples on the barycenter of the corresponding
    field contour. The number of (evenly distributed) arc samples can be
    defined with set_number_of_samples() (default value: 10). The skeleton
    can be optionally smoothed with set_number_of_smoothing_iterations()
    (default value: 10). The filter will first try to pull as a scalar
    field the DataArray with Id '_field_id' of the PolyData, see
    set_field_id() (default: 0). The filter will abort if this field does
    not exist.
    
    The filter outputs a Table of points (double[3]). Each column
    contains the samples (sorted by function value) of the corresponding
    arc. The first and the last entry of the column corresponds to the
    critical nodes at the extremity of the arc (each column has
    number_of_samples + 2 entries).
    
    The skeleton can be rendered by linking the samples with geometrical
    primitives (for instance, spheres at critical nodes and cylinders
    between intermediary samples, see
    graphics/_testing/_cxx/_test_reeb_graph.cxx).
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkReebGraphVolumeSkeletonFilter, obj, update, **traits)
    
    field_id = traits.Int(0, enter_set=True, auto_set=False, desc=\
        """
        Set the scalar field Id Default value: 0
        """
    )

    def _field_id_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetFieldId,
                        self.field_id)

    number_of_samples = traits.Int(5, enter_set=True, auto_set=False, desc=\
        """
        Set the number of samples along each arc of the Reeb graph
        Default value: 5
        """
    )

    def _number_of_samples_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetNumberOfSamples,
                        self.number_of_samples)

    number_of_smoothing_iterations = traits.Int(30, enter_set=True, auto_set=False, desc=\
        """
        Set the number of optional smoothing iterations Default value: 30
        """
    )

    def _number_of_smoothing_iterations_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetNumberOfSmoothingIterations,
                        self.number_of_smoothing_iterations)

    def _get_output(self):
        return wrap_vtk(self._vtk_obj.GetOutput())
    
    def _set_output(self, obj):
        old_val = self._get_output()
        self._wrap_call(self._vtk_obj.SetOutput, deref_vtk(obj))
        self.trait_property_changed('output', old_val, obj)
    output = traits.Property(_get_output, _set_output,
                             desc="Output of this source, i.e. the result of `get_output()`.")
    
    def get_output(self):
        """
        V.get_output() -> Table
        C++: Table *GetOutput()
        Get the output data object for a port on this algorithm.
        """
        return wrap_vtk(self._vtk_obj.GetOutput())

    def set_output(self, obj):
        """
        V.set_output(DataObject)
        C++: virtual void SetOutput(DataObject *d)
        Get the output data object for a port on this algorithm.
        """
        old_val = self._get_output()
        self._wrap_call(self._vtk_obj.SetOutput, deref_vtk(obj))
        self.trait_property_changed('output', old_val, obj)

    def _get_input(self):
        try:
            return wrap_vtk(self._vtk_obj.GetInput(0))
        except TypeError:
            return wrap_vtk(self._vtk_obj.GetInput())
    input = traits.Property(_get_input,
                            desc="The first input of this object, i.e. the result of `get_input(0)`.")
    
    def get_input(self, *args):
        """
        V.get_input() -> DataObject
        C++: DataObject *GetInput()
        V.get_input(int) -> DataObject
        C++: DataObject *GetInput(int port)"""
        ret = self._wrap_call(self._vtk_obj.GetInput, *args)
        return wrap_vtk(ret)

    _updateable_traits_ = \
    (('abort_execute', 'GetAbortExecute'), ('release_data_flag',
    'GetReleaseDataFlag'), ('debug', 'GetDebug'),
    ('global_warning_display', 'GetGlobalWarningDisplay'), ('field_id',
    'GetFieldId'), ('number_of_samples', 'GetNumberOfSamples'),
    ('number_of_smoothing_iterations', 'GetNumberOfSmoothingIterations'),
    ('progress', 'GetProgress'), ('progress_text', 'GetProgressText'),
    ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['abort_execute', 'debug', 'global_warning_display',
    'release_data_flag', 'field_id', 'number_of_samples',
    'number_of_smoothing_iterations', 'progress_text'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(ReebGraphVolumeSkeletonFilter, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit ReebGraphVolumeSkeletonFilter properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View(([], [], ['field_id', 'number_of_samples',
            'number_of_smoothing_iterations']),
            title='Edit ReebGraphVolumeSkeletonFilter properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit ReebGraphVolumeSkeletonFilter properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

