# Options
<span class="source-link">[[Source]](src/options/options.md#L102)</span>
```pony
class ref Options is
  Iterator[((String val , (None val | String val | I64 val | U64 val | F64 val)) | ParseError ref | None val)] ref
```

#### Implements

* [Iterator](builtin-Iterator.md)\[(([String](builtin-String.md) val , ([None](builtin-None.md) val | [String](builtin-String.md) val | [I64](builtin-I64.md) val | [U64](builtin-U64.md) val | [F64](builtin-F64.md) val)) | [ParseError](options-ParseError.md) ref | [None](builtin-None.md) val)\] ref

---

## Constructors

### create
<span class="source-link">[[Source]](src/options/options.md#L109)</span>


```pony
new ref create(
  args: Array[String val] box,
  fatal: Bool val = true)
: Options ref^
```
#### Parameters

*   args: [Array](builtin-Array.md)\[[String](builtin-String.md) val\] box
*   fatal: [Bool](builtin-Bool.md) val = true

#### Returns

* [Options](options-Options.md) ref^

---

## Public Functions

### add
<span class="source-link">[[Source]](src/options/options.md#L117)</span>


Adds a new named option to the parser configuration.


```pony
fun ref add(
  long: String val,
  short: (None val | String val) = reference,
  arg: (None val | StringArgument val | I64Argument val | 
    U64Argument val | F64Argument val) = reference,
  mode: (Required val | Optional val) = reference)
: Options ref
```
#### Parameters

*   long: [String](builtin-String.md) val
*   short: ([None](builtin-None.md) val | [String](builtin-String.md) val) = reference
*   arg: ([None](builtin-None.md) val | [StringArgument](options-StringArgument.md) val | [I64Argument](options-I64Argument.md) val | 
    [U64Argument](options-U64Argument.md) val | [F64Argument](options-F64Argument.md) val) = reference
*   mode: ([Required](options-Required.md) val | [Optional](options-Optional.md) val) = reference

#### Returns

* [Options](options-Options.md) ref

---

### remaining
<span class="source-link">[[Source]](src/options/options.md#L130)</span>


Returns all unprocessed command line arguments. After parsing all options,
this will only include positional arguments, potentially unrecognised and
ambiguous options and invalid arguments.


```pony
fun ref remaining()
: Array[String ref] ref
```

#### Returns

* [Array](builtin-Array.md)\[[String](builtin-String.md) ref\] ref

---

### has_next
<span class="source-link">[[Source]](src/options/options.md#L250)</span>


Parsing options is done if either an error occurs and fatal error reporting
is turned on, or if all command line arguments have been processed.


```pony
fun box has_next()
: Bool val
```

#### Returns

* [Bool](builtin-Bool.md) val

---

### next
<span class="source-link">[[Source]](src/options/options.md#L257)</span>


Skips all positional arguments and attemps to match named options. Returns
a ParsedOption on success, a ParseError on error, or None if no named
options are found.


```pony
fun ref next()
: ((String val , (None val | String val | I64 val | 
    U64 val | F64 val)) | ParseError ref | None val)
```

#### Returns

* (([String](builtin-String.md) val , ([None](builtin-None.md) val | [String](builtin-String.md) val | [I64](builtin-I64.md) val | 
    [U64](builtin-U64.md) val | [F64](builtin-F64.md) val)) | [ParseError](options-ParseError.md) ref | [None](builtin-None.md) val)

---

## Private Functions

### _strip
<span class="source-link">[[Source]](src/options/options.md#L138)</span>


Strips accepted options from the copied array of command line arguments.


```pony
fun ref _strip(
  opt: _Option ref,
  matched: String ref,
  start: ISize val,
  finish: ISize val)
: None val
```
#### Parameters

*   opt: [_Option](options-_Option.md) ref
*   matched: [String](builtin-String.md) ref
*   start: [ISize](builtin-ISize.md) val
*   finish: [ISize](builtin-ISize.md) val

#### Returns

* [None](builtin-None.md) val

---

### _select
<span class="source-link">[[Source]](src/options/options.md#L164)</span>


Selects an option from the configuration depending on the current command
line argument.


```pony
fun ref _select(
  candidate: String ref,
  start: ISize val,
  offset: ISize val,
  finish: ISize val)
: (_Option ref | ParseError ref)
```
#### Parameters

*   candidate: [String](builtin-String.md) ref
*   start: [ISize](builtin-ISize.md) val
*   offset: [ISize](builtin-ISize.md) val
*   finish: [ISize](builtin-ISize.md) val

#### Returns

* ([_Option](options-_Option.md) ref | [ParseError](options-ParseError.md) ref)

---

### _skip
<span class="source-link">[[Source]](src/options/options.md#L196)</span>


Skips all non-options. Returns true if a named option has been found, false
otherwise.


```pony
fun ref _skip()
: Bool val
```

#### Returns

* [Bool](builtin-Bool.md) val

---

### _verify
<span class="source-link">[[Source]](src/options/options.md#L215)</span>


Verifies whether a parsed option from the command line is well-formed. That
is, checking whether required or optional arguments are supplied. Returns
a ParsedOption on success, a ParseError otherwise.


```pony
fun ref _verify(
  opt: _Option ref,
  combined: Bool val)
: ((String val , (None val | String val | I64 val | 
    U64 val | F64 val)) | ParseError ref)
```
#### Parameters

*   opt: [_Option](options-_Option.md) ref
*   combined: [Bool](builtin-Bool.md) val

#### Returns

* (([String](builtin-String.md) val , ([None](builtin-None.md) val | [String](builtin-String.md) val | [I64](builtin-I64.md) val | 
    [U64](builtin-U64.md) val | [F64](builtin-F64.md) val)) | [ParseError](options-ParseError.md) ref)

---

