/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.action;

import javax.swing.Icon;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;
import org.protege.editor.core.HasUpdateState;
import org.protege.editor.core.ui.view.DisposableAction;
import org.protege.editor.owl.ui.tree.OWLObjectTreeNode;
import org.semanticweb.owlapi.model.OWLEntity;

public abstract class AbstractOWLTreeAction<E extends OWLEntity>
extends DisposableAction
implements HasUpdateState {
    private TreeSelectionModel selectionModel;
    private TreeSelectionListener selectionListener;

    public AbstractOWLTreeAction(String name, Icon icon, TreeSelectionModel selectionModel) {
        super(name, icon);
        this.selectionModel = selectionModel;
        this.selectionListener = e -> this.reactToSelection();
        selectionModel.addTreeSelectionListener(this.selectionListener);
        this.setEnabled(this.canPerform(this.getSelectedOWLEntity()));
    }

    public void updateState() {
        this.setEnabled(this.canPerform(this.getSelectedOWLEntity()));
    }

    private void reactToSelection() {
        this.updateState();
    }

    protected abstract boolean canPerform(E var1);

    protected TreePath getSelectionPath() {
        return this.selectionModel.getSelectionPath();
    }

    protected void setSelectionPath(TreePath path) {
        this.selectionModel.setSelectionPath(path);
    }

    protected E getSelectedOWLEntity() {
        TreePath treePath = this.selectionModel.getSelectionPath();
        if (treePath == null) {
            return null;
        }
        return (E)((OWLEntity)((OWLObjectTreeNode)treePath.getLastPathComponent()).getUserObject());
    }

    public void dispose() {
        this.selectionModel.removeTreeSelectionListener(this.selectionListener);
    }

    public void initialise() throws Exception {
    }
}

