/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.action;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.protege.editor.owl.ui.action.ProtegeOWLAction;
import org.semanticweb.owlapi.model.AddAxiom;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAnnotationSubject;
import org.semanticweb.owlapi.model.OWLAnnotationValue;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLPrimitive;
import org.semanticweb.owlapi.model.RemoveAxiom;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConvertAssertionsOnPunsToAnnotations
extends ProtegeOWLAction {
    private static Logger logger = LoggerFactory.getLogger(ConvertAssertionsOnPunsToAnnotations.class);

    public void actionPerformed(ActionEvent e) {
        OWLDataFactory df = this.getOWLDataFactory();
        Set<OWLOntology> onts = this.getOWLModelManager().getOntologies();
        HashSet inds = new HashSet();
        ArrayList<Object> changes = new ArrayList<Object>();
        for (OWLOntology ont : onts) {
            inds.addAll(ont.getIndividualsInSignature());
        }
        HashSet<OWLDataProperty> props = new HashSet<OWLDataProperty>();
        for (OWLIndividual ind : inds) {
            if (!this.isPunForClass(ind)) continue;
            OWLNamedIndividual pun = ind.asOWLNamedIndividual();
            for (OWLOntology ont : onts) {
                for (OWLDataPropertyAssertionAxiom ax : ont.getDataPropertyAssertionAxioms((OWLIndividual)pun)) {
                    if (((OWLDataPropertyExpression)ax.getProperty()).isAnonymous()) continue;
                    changes.add(new RemoveAxiom(ont, (OWLAxiom)ax));
                    OWLAnnotationProperty aProp = df.getOWLAnnotationProperty(((OWLDataPropertyExpression)ax.getProperty()).asOWLDataProperty().getIRI());
                    OWLAnnotation anno = df.getOWLAnnotation(aProp, (OWLAnnotationValue)ax.getObject());
                    OWLAnnotationAssertionAxiom annoAx = df.getOWLAnnotationAssertionAxiom((OWLAnnotationSubject)pun.getIRI(), anno);
                    changes.add(new AddAxiom(ont, (OWLAxiom)annoAx));
                    props.add((OWLDataProperty)ax.getProperty());
                }
            }
            for (OWLOntology ont : onts) {
                for (OWLDataPropertyAssertionAxiom ax : ont.getDeclarationAxioms((OWLEntity)pun)) {
                    changes.add(new RemoveAxiom(ont, (OWLAxiom)ax));
                }
                for (OWLDataPropertyAssertionAxiom ax : ont.getClassAssertionAxioms((OWLIndividual)pun)) {
                    changes.add(new RemoveAxiom(ont, (OWLAxiom)ax));
                }
            }
            for (OWLDataProperty prop : props) {
                for (OWLOntology ont : onts) {
                    for (OWLAxiom ax : ont.getDeclarationAxioms((OWLEntity)prop)) {
                        changes.add(new RemoveAxiom(ont, ax));
                    }
                    for (OWLAxiom ax : ont.getAxioms(prop)) {
                        changes.add(new RemoveAxiom(ont, ax));
                    }
                }
            }
        }
        this.getOWLModelManager().applyChanges(changes);
        for (OWLOntology ont : onts) {
            for (OWLDataProperty prop : ont.getDataPropertiesInSignature()) {
                for (OWLOntology o : onts) {
                    for (OWLAxiom ax : o.getReferencingAxioms((OWLPrimitive)prop)) {
                        logger.trace("Axiom: {}", (Object)ax);
                    }
                }
            }
        }
    }

    private boolean isPunForClass(OWLIndividual ind) {
        if (ind.isAnonymous()) {
            return false;
        }
        for (OWLOntology ont : this.getOWLModelManager().getOntologies()) {
            if (!ont.containsClassInSignature(ind.asOWLNamedIndividual().getIRI())) continue;
            return true;
        }
        return false;
    }

    public void dispose() throws Exception {
    }

    public void initialise() throws Exception {
    }
}

