/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.axiom;

import com.google.common.base.Preconditions;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import org.protege.editor.owl.OWLEditorKit;
import org.protege.editor.owl.model.OWLEditorKitIRIShortFormProvider;
import org.protege.editor.owl.model.OWLEditorKitOntologyShortFormProvider;
import org.protege.editor.owl.model.OWLEditorKitShortFormProvider;
import org.protege.editor.owl.model.util.OWLAxiomInstance;
import org.protege.editor.owl.ui.axiom.AxiomAnnotationsList;
import org.protege.editor.owl.ui.renderer.context.OWLObjectRenderingContext;
import org.protege.editor.owl.ui.renderer.styledstring.OWLObjectStyledStringRenderer;
import org.protege.editor.owl.ui.renderer.styledstring.StyledString;
import org.protege.editor.owl.ui.renderer.styledstring.StyledStringPanel;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.util.SimpleIRIShortFormProvider;

public class AxiomAnnotationPanel
extends JComponent {
    private static final int PREF_WIDTH = 500;
    private AxiomAnnotationsList annotationsComponent;
    private final OWLEditorKit editorKit;
    private final StyledStringPanel axiomPanel = new StyledStringPanel();

    public AxiomAnnotationPanel(OWLEditorKit eKit) {
        this.editorKit = (OWLEditorKit)((Object)Preconditions.checkNotNull((Object)((Object)eKit)));
        this.setLayout(new BorderLayout(6, 6));
        this.setPreferredSize(new Dimension(500, 300));
        this.annotationsComponent = new AxiomAnnotationsList(eKit);
        this.axiomPanel.setPreferredSize(new Dimension(500, 50));
        this.add((Component)this.axiomPanel, "North");
        this.add((Component)new JScrollPane((Component)((Object)this.annotationsComponent)), "Center");
        this.setVisible(true);
    }

    private StyledString getAxiomRendering(OWLAxiom axiom) {
        OWLEditorKitShortFormProvider sfp = new OWLEditorKitShortFormProvider(this.editorKit);
        OWLEditorKitOntologyShortFormProvider ontologySfp = new OWLEditorKitOntologyShortFormProvider(this.editorKit);
        OWLEditorKitIRIShortFormProvider iriSfp = new OWLEditorKitIRIShortFormProvider(this.editorKit, new SimpleIRIShortFormProvider());
        OWLObjectRenderingContext renderingContext = new OWLObjectRenderingContext(sfp, iriSfp, ontologySfp);
        OWLObjectStyledStringRenderer renderer = new OWLObjectStyledStringRenderer(renderingContext);
        return renderer.getRendering((OWLObject)axiom);
    }

    public void setAxiomInstance(OWLAxiomInstance axiomInstance) {
        this.axiomPanel.setStyledString(StyledString.EMPTY_STYLED_STRING);
        if (axiomInstance != null) {
            StyledString axiomRendering = this.getAxiomRendering(axiomInstance.getAxiom());
            this.axiomPanel.setStyledString(axiomRendering);
            this.annotationsComponent.setRootObject(axiomInstance);
        } else {
            this.annotationsComponent.setRootObject(null);
        }
    }

    public OWLAxiomInstance getAxiom() {
        return (OWLAxiomInstance)this.annotationsComponent.getRoot();
    }

    public void dispose() {
        this.annotationsComponent.dispose();
    }
}

