/*
 * Decompiled with CFR 0.152.
 */
package org.protege.owlapi.inference.cls;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.protege.owlapi.inference.cls.NamedClassExtractor;
import org.protege.owlapi.inference.cls.NamedConjunctChecker;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLClassExpressionVisitor;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.util.OWLAxiomVisitorAdapter;

public class ChildClassExtractor
extends OWLAxiomVisitorAdapter {
    private NamedConjunctChecker checker = new NamedConjunctChecker();
    private NamedClassExtractor namedClassExtractor = new NamedClassExtractor();
    @Nullable
    private OWLClass currentParentClass;
    private ImmutableSet<OWLObjectProperty> relationships = ImmutableSet.of();
    private Set<OWLClass> results = new HashSet<OWLClass>();
    private Map<OWLClass, OWLObjectPropertyExpression> child2RelationshipMap = new HashMap<OWLClass, OWLObjectPropertyExpression>();

    @Deprecated
    public void reset() {
        this.clear();
    }

    public void setCurrentParentClass(@Nonnull OWLClass currentParentClass) {
        this.currentParentClass = (OWLClass)Preconditions.checkNotNull((Object)currentParentClass);
        this.clear();
    }

    @Nonnull
    public Optional<OWLClass> getCurrentParentClass() {
        return Optional.ofNullable(this.currentParentClass);
    }

    private void clear() {
        this.results.clear();
        this.namedClassExtractor.reset();
        this.child2RelationshipMap.clear();
    }

    public Collection<OWLClass> getResult() {
        return new ArrayList<OWLClass>(this.results);
    }

    public void visit(OWLSubClassOfAxiom axiom) {
        if (axiom.getSubClass().isAnonymous()) {
            return;
        }
        if (this.checker.containsConjunct(this.currentParentClass, axiom.getSuperClass())) {
            this.results.add(axiom.getSubClass().asOWLClass());
        } else if (!this.relationships.isEmpty()) {
            axiom.getSuperClass().asConjunctSet().stream().filter(ce -> ce instanceof OWLObjectSomeValuesFrom).map(ce -> (OWLObjectSomeValuesFrom)ce).filter(svf -> !svf.getProperty().isAnonymous()).filter(svf -> ((OWLClassExpression)svf.getFiller()).equals(this.currentParentClass)).filter(svf -> this.relationships.contains((Object)svf.getProperty().asOWLObjectProperty())).findFirst().ifPresent(c -> {
                OWLClass child = axiom.getSubClass().asOWLClass();
                this.results.add(child);
                this.child2RelationshipMap.put(child, c.getProperty());
            });
        }
    }

    public void visit(OWLEquivalentClassesAxiom axiom) {
        if (!this.namedClassInEquivalentAxiom(axiom)) {
            return;
        }
        HashSet<OWLClassExpression> candidateDescriptions = new HashSet<OWLClassExpression>();
        boolean found = false;
        for (OWLClassExpression equivalentClass : axiom.getClassExpressions()) {
            if (!this.checker.containsConjunct(this.currentParentClass, equivalentClass)) {
                candidateDescriptions.add(equivalentClass);
                continue;
            }
            if (!equivalentClass.isAnonymous()) continue;
            found = true;
        }
        if (!found) {
            return;
        }
        this.namedClassExtractor.reset();
        for (OWLClassExpression desc : candidateDescriptions) {
            desc.accept((OWLClassExpressionVisitor)this.namedClassExtractor);
        }
        this.results.addAll(this.namedClassExtractor.getResult());
    }

    public void setRelationshipProperties(ImmutableSet<OWLObjectProperty> properties) {
        this.relationships = properties;
    }

    public Set<OWLObjectProperty> getRelationships() {
        return this.relationships;
    }

    public Optional<OWLObjectPropertyExpression> getRelationship(OWLClass child) {
        return Optional.ofNullable(this.child2RelationshipMap.get(child));
    }

    private boolean namedClassInEquivalentAxiom(OWLEquivalentClassesAxiom axiom) {
        for (OWLClassExpression equiv : axiom.getClassExpressions()) {
            if (equiv.isAnonymous()) continue;
            return true;
        }
        return false;
    }
}

