/*
 * Decompiled with CFR 0.152.
 */
package org.protege.xmlcatalog.swing;

import java.util.Enumeration;
import java.util.List;
import java.util.NoSuchElementException;
import javax.swing.tree.TreeNode;
import org.apache.log4j.Logger;
import org.protege.xmlcatalog.CatalogUtilities;
import org.protege.xmlcatalog.XMLCatalog;
import org.protege.xmlcatalog.entry.Entry;
import org.protege.xmlcatalog.entry.GroupEntry;
import org.protege.xmlcatalog.entry.NextCatalogEntry;
import org.protege.xmlcatalog.swing.CatalogTreeNode;
import org.protege.xmlcatalog.swing.EntryEditor;

public class EntryTreeNode
implements TreeNode {
    public static final Logger LOGGER = Logger.getLogger(EntryTreeNode.class);
    private TreeNode parent;
    private Entry entry;
    private List<EntryEditor> editors;
    private EntryEditor editor;
    private boolean autoGenerated;
    private XMLCatalog childCatalog;

    public EntryTreeNode(TreeNode parent, Entry entry, List<EntryEditor> editors) {
        if (!(parent instanceof CatalogTreeNode) && !(parent instanceof EntryTreeNode)) {
            throw new IllegalArgumentException("Invalid Parent!");
        }
        this.entry = entry;
        this.editors = editors;
        this.parent = parent;
        this.editor = null;
        this.autoGenerated = false;
        boolean isParentAutoGenerated = parent instanceof CatalogTreeNode ? false : ((EntryTreeNode)parent).isAutoGenerated();
        if (isParentAutoGenerated) {
            this.autoGenerated = true;
        } else {
            for (EntryEditor editor : editors) {
                if (!editor.isSuitable(entry)) continue;
                this.editor = editor;
            }
        }
    }

    public Entry getEntry() {
        return this.entry;
    }

    public List<EntryEditor> getEditors() {
        return this.editors;
    }

    public EntryEditor getEditor() {
        return this.editor;
    }

    public boolean isAutoGenerated() {
        return this.autoGenerated;
    }

    @Override
    public TreeNode getChildAt(int childIndex) {
        if (this.entry instanceof GroupEntry) {
            Entry childEntry = ((GroupEntry)this.entry).getEntries().get(childIndex);
            return new EntryTreeNode(this, childEntry, this.editors);
        }
        if (this.entry instanceof NextCatalogEntry && childIndex == 0) {
            try {
                if (this.childCatalog == null) {
                    this.childCatalog = CatalogUtilities.parseDocument(((NextCatalogEntry)this.entry).getCatalog().toURL());
                }
            }
            catch (Exception e) {
                LOGGER.error((Object)"Exception caught trying to parse nested catalog in xml catalog", (Throwable)e);
            }
            return new CatalogTreeNode(this.childCatalog, this.editors);
        }
        return null;
    }

    @Override
    public int getChildCount() {
        if (this.entry instanceof GroupEntry) {
            return ((GroupEntry)this.entry).getEntries().size();
        }
        if (this.entry instanceof NextCatalogEntry) {
            return 1;
        }
        return 0;
    }

    @Override
    public TreeNode getParent() {
        return this.parent;
    }

    @Override
    public int getIndex(TreeNode node) {
        if (node instanceof EntryTreeNode && ((EntryTreeNode)node).getEntry() instanceof GroupEntry) {
            return ((GroupEntry)((EntryTreeNode)node).getEntry()).getEntries().indexOf(this.entry);
        }
        return -1;
    }

    @Override
    public boolean getAllowsChildren() {
        return this.entry instanceof GroupEntry || this.entry instanceof NextCatalogEntry;
    }

    @Override
    public boolean isLeaf() {
        if (this.entry instanceof GroupEntry) {
            return ((GroupEntry)this.entry).getEntries().size() == 0;
        }
        return this.entry instanceof NextCatalogEntry;
    }

    public Enumeration<TreeNode> children() {
        return new Enumeration<TreeNode>(){
            int currentIndex = 0;

            @Override
            public boolean hasMoreElements() {
                return this.currentIndex < EntryTreeNode.this.getChildCount();
            }

            @Override
            public TreeNode nextElement() throws NoSuchElementException {
                if (!this.hasMoreElements()) {
                    throw new NoSuchElementException("No such element");
                }
                try {
                    TreeNode treeNode = EntryTreeNode.this.getChildAt(this.currentIndex);
                    return treeNode;
                }
                finally {
                    ++this.currentIndex;
                }
            }
        };
    }
}

