/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.dex.visitors.debuginfo;

import jadx.api.plugins.input.data.IDebugInfo;
import jadx.api.plugins.input.data.ILocalVar;
import jadx.core.codegen.CodeWriter;
import jadx.core.dex.attributes.nodes.LocalVarsDebugInfoAttr;
import jadx.core.dex.attributes.nodes.RegDebugInfoAttr;
import jadx.core.dex.instructions.args.ArgType;
import jadx.core.dex.instructions.args.InsnArg;
import jadx.core.dex.instructions.args.RegisterArg;
import jadx.core.dex.nodes.InsnNode;
import jadx.core.dex.nodes.MethodNode;
import jadx.core.dex.nodes.parser.SignatureParser;
import jadx.core.dex.visitors.AbstractVisitor;
import jadx.core.dex.visitors.JadxVisitor;
import jadx.core.dex.visitors.blocksmaker.BlockSplitter;
import jadx.core.dex.visitors.ssa.SSATransform;
import jadx.core.utils.ErrorsCounter;
import jadx.core.utils.Utils;
import jadx.core.utils.exceptions.JadxException;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JadxVisitor(name="Debug Info Parser", desc="Attach debug information (variable names and types, instruction lines)", runBefore={BlockSplitter.class, SSATransform.class})
public class DebugInfoAttachVisitor
extends AbstractVisitor {
    private static final Logger LOG = LoggerFactory.getLogger(DebugInfoAttachVisitor.class);

    @Override
    public void visit(MethodNode mth) throws JadxException {
        try {
            IDebugInfo debugInfo = mth.getDebugInfo();
            if (debugInfo != null) {
                this.processDebugInfo(mth, debugInfo);
            }
        }
        catch (Exception e) {
            mth.addComment("JADX WARNING: Error to parse debug info: " + ErrorsCounter.formatMsg(mth, e.getMessage()) + CodeWriter.NL + Utils.getStackTrace(e));
        }
    }

    private void processDebugInfo(MethodNode mth, IDebugInfo debugInfo) {
        InsnNode[] insnArr = mth.getInstructions();
        this.attachSourceLines(debugInfo.getSourceLineMapping(), insnArr);
        this.attachDebugInfo(mth, debugInfo.getLocalVars(), insnArr);
        this.setMethodSourceLine(mth, insnArr);
    }

    private void attachSourceLines(Map<Integer, Integer> lineMapping, InsnNode[] insnArr) {
        for (InsnNode insn : insnArr) {
            Integer sourceLine;
            if (insn == null || (sourceLine = lineMapping.get(insn.getOffset())) == null) continue;
            insn.setSourceLine(sourceLine);
        }
    }

    private void attachDebugInfo(MethodNode mth, List<ILocalVar> localVars, InsnNode[] insnArr) {
        if (localVars.isEmpty()) {
            return;
        }
        for (ILocalVar var : localVars) {
            int regNum = var.getRegNum();
            int start = var.getStartOffset();
            int end = var.getEndOffset();
            ArgType type = DebugInfoAttachVisitor.getVarType(mth, var);
            RegDebugInfoAttr debugInfoAttr = new RegDebugInfoAttr(type, var.getName());
            if (start < 0) {
                RegisterArg thisArg = mth.getThisArg();
                if (thisArg != null) {
                    this.attachDebugInfo(thisArg, debugInfoAttr, regNum);
                }
                for (RegisterArg arg : mth.getArgRegs()) {
                    this.attachDebugInfo(arg, debugInfoAttr, regNum);
                }
                start = 0;
            }
            for (int i = start; i <= end; ++i) {
                InsnNode insn = insnArr[i];
                if (insn == null) continue;
                this.attachDebugInfo(insn.getResult(), debugInfoAttr, regNum);
                for (InsnArg arg : insn.getArguments()) {
                    this.attachDebugInfo(arg, debugInfoAttr, regNum);
                }
            }
        }
        mth.addAttr(new LocalVarsDebugInfoAttr(localVars));
    }

    private void attachDebugInfo(InsnArg arg, RegDebugInfoAttr debugInfoAttr, int regNum) {
        RegisterArg reg;
        if (arg instanceof RegisterArg && regNum == (reg = (RegisterArg)arg).getRegNum()) {
            reg.addAttr(debugInfoAttr);
        }
    }

    public static ArgType getVarType(MethodNode mth, ILocalVar var) {
        ArgType type = ArgType.parse(var.getType());
        String sign = var.getSignature();
        if (sign == null) {
            return type;
        }
        try {
            ArgType gType = new SignatureParser(sign).consumeType();
            ArgType expandedType = mth.root().getTypeUtils().expandTypeVariables(mth, gType);
            if (DebugInfoAttachVisitor.checkSignature(type, expandedType)) {
                return expandedType;
            }
        }
        catch (Exception e) {
            LOG.error("Can't parse signature for local variable: {}", (Object)sign, (Object)e);
        }
        return type;
    }

    private static boolean checkSignature(ArgType type, ArgType gType) {
        boolean apply;
        ArgType el = gType.getArrayRootElement();
        if (el.isGeneric()) {
            if (!type.getArrayRootElement().getObject().equals(el.getObject())) {
                LOG.warn("Generic type in debug info not equals: {} != {}", (Object)type, (Object)gType);
            }
            apply = true;
        } else {
            apply = el.isGenericType();
        }
        return apply;
    }

    private void setMethodSourceLine(MethodNode mth, InsnNode[] insnArr) {
        for (InsnNode insn : insnArr) {
            int line;
            if (insn == null || (line = insn.getSourceLine()) == 0) continue;
            mth.setSourceLine(line - 1);
            return;
        }
    }
}

