/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analysis;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Map;
import net.java.sen.filter.stream.CompositeTokenFilter;
import org.apache.lucene.analysis.gosen.GosenTokenizer;
import org.apache.lucene.analysis.util.ResourceLoader;
import org.apache.lucene.analysis.util.ResourceLoaderAware;
import org.apache.lucene.analysis.util.TokenizerFactory;
import org.apache.lucene.util.AttributeFactory;
import org.apache.lucene.util.IOUtils;
import org.apache.solr.core.SolrResourceLoader;

public class GosenTokenizerFactory
extends TokenizerFactory
implements ResourceLoaderAware {
    private CompositeTokenFilter compositeTokenFilter;
    private String dictionaryDir;
    private final String compositePosFile;
    private final String dirVal;
    private final boolean tokenizeUnknownKatakana;

    public GosenTokenizerFactory(Map<String, String> args) {
        super(args);
        this.compositePosFile = this.get(args, "compositePOS");
        this.dirVal = this.get(args, "dictionaryDir");
        this.tokenizeUnknownKatakana = this.getBoolean(args, "tokenizeUnknownKatakana", false);
        if (!args.isEmpty()) {
            throw new IllegalArgumentException("Unknown parameters: " + args);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void inform(ResourceLoader loader) throws IOException {
        if (this.compositePosFile != null) {
            this.compositeTokenFilter = new CompositeTokenFilter();
            InputStreamReader isr = null;
            BufferedReader reader = null;
            try {
                isr = new InputStreamReader(loader.openResource(this.compositePosFile), "UTF-8");
                reader = new BufferedReader(isr);
                this.compositeTokenFilter.readRules(reader);
            }
            catch (IOException e) {
                try {
                    throw new RuntimeException(e);
                }
                catch (Throwable throwable) {
                    try {
                        IOUtils.close((Closeable[])new Closeable[]{reader, isr});
                        throw throwable;
                    }
                    catch (IOException e2) {
                        throw new RuntimeException(e2);
                    }
                }
            }
            try {
                IOUtils.close((Closeable[])new Closeable[]{reader, isr});
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.dirVal == null) return;
        SolrResourceLoader solrLoader = (SolrResourceLoader)SolrResourceLoader.class.cast(loader);
        File d0 = new File(this.dirVal);
        File d = d0;
        if (!d.isAbsolute()) {
            d = new File(solrLoader.getConfigDir() + File.separator + this.dirVal);
        }
        if (d.isDirectory() && d.canRead()) {
            this.dictionaryDir = d.getAbsolutePath();
            return;
        }
        if (d != d0 && d0.isDirectory() && d0.canRead()) {
            this.dictionaryDir = d0.getAbsolutePath();
            return;
        }
        this.dictionaryDir = this.dirVal;
    }

    public GosenTokenizer create(AttributeFactory factory) {
        return new GosenTokenizer(factory, this.compositeTokenFilter, this.dictionaryDir, this.tokenizeUnknownKatakana);
    }
}

