/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.util;

import java.util.Set;
import javax.annotation.Nonnull;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.parameters.Imports;
import org.semanticweb.owlapi.reasoner.OWLReasoner;
import org.semanticweb.owlapi.util.InferredIndividualAxiomGenerator;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;

public class InferredPropertyAssertionGenerator
extends InferredIndividualAxiomGenerator<OWLPropertyAssertionAxiom<?, ?>> {
    @Override
    protected void addAxioms(OWLNamedIndividual entity, @Nonnull OWLReasoner reasoner, OWLDataFactory dataFactory, Set<OWLPropertyAssertionAxiom<?, ?>> result) {
        OWLAPIPreconditions.checkNotNull(dataFactory, "dataFactory cannot be null");
        OWLAPIPreconditions.checkNotNull(reasoner, "reasoner cannot be null");
        OWLAPIPreconditions.checkNotNull(result, "result cannot be null");
        OWLAPIPreconditions.checkNotNull(entity, "entity cannot be null");
        for (OWLObjectProperty oWLObjectProperty : reasoner.getRootOntology().getObjectPropertiesInSignature(Imports.INCLUDED)) {
            assert (oWLObjectProperty != null);
            for (OWLNamedIndividual oWLNamedIndividual : reasoner.getObjectPropertyValues(entity, oWLObjectProperty).getFlattened()) {
                assert (oWLNamedIndividual != null);
                result.add(dataFactory.getOWLObjectPropertyAssertionAxiom(oWLObjectProperty, entity, oWLNamedIndividual));
            }
        }
        for (OWLDataProperty oWLDataProperty : reasoner.getRootOntology().getDataPropertiesInSignature(Imports.INCLUDED)) {
            assert (oWLDataProperty != null);
            for (OWLLiteral oWLLiteral : reasoner.getDataPropertyValues(entity, oWLDataProperty)) {
                assert (oWLLiteral != null);
                result.add(dataFactory.getOWLDataPropertyAssertionAxiom((OWLDataPropertyExpression)oWLDataProperty, (OWLIndividual)entity, oWLLiteral));
            }
        }
    }

    @Override
    public String getLabel() {
        return "Property assertions (property values)";
    }
}

