#!/usr/bin/python

# ----------------------------------------------------------------------------
#
#  Copyright (C) 2008-2014 Fons Adriaensen <fons@linuxaudio.org>
#    
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 3 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program.  If not, see <http:#www.gnu.org/licenses/>.
#
# ----------------------------------------------------------------------------


import numpy as np
from math import *
from time import sleep
from jacktools.jacksignal import JackSignal


# ----------------------- Linear sweep  --------------------------
#
# Generate linear sweep and display with jaaa set to peak hold.
# Try using different sweep speeds and jaaa bandwidths.


FMIN = 0
FMAX = 20e3
TIME = 15  # seconds
AMPL = 0.1 # signal amplitude


# Generate a linear sweep signal.
#
def linsweep (fmin, fmax, amp, time, A, fsamp):
    n = int (time * fsamp + 0.1) 
    if n > A.shape [0]: n = A.shape [0]
    a = fmin / fsamp
    b = (fmax - fmin) / (fsamp * n);
    p = 0.0
    for i in range (n):
        A [i] = amp * sin (2 * pi * p)
        a += b
        p += a
        if p > 1.0: p -= 1.0


# Create a JackSignal object and connect.
#
J = JackSignal("JackSignal")
if J.get_state() < 0:
    print ("Failed to create JackSignal -- is Jack running ?")
    exit(1)
J.create_output (0, "out-1")
J.silence()
J.connect_output (0, "jaaa:in_1")

# Get Jack info.
#
name, fsamp, period = J.get_jack_info ()

# Create output buffer.
#
size = int (TIME * fsamp + 0.1)
A = np.empty ([size,], dtype = np.float32)

# Run the test
#
linsweep (FMIN, FMAX, AMPL, TIME, A, fsamp) 
J.set_output_data (0, A)
J.process()
J.wait()
del J

