/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.util;

import java.util.Set;
import javax.annotation.Nonnull;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLSubObjectPropertyOfAxiom;
import org.semanticweb.owlapi.reasoner.OWLReasoner;
import org.semanticweb.owlapi.search.EntitySearcher;
import org.semanticweb.owlapi.util.InferredObjectPropertyAxiomGenerator;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;

public class InferredSubObjectPropertyAxiomGenerator
extends InferredObjectPropertyAxiomGenerator<OWLSubObjectPropertyOfAxiom> {
    @Override
    protected void addAxioms(OWLObjectProperty entity, @Nonnull OWLReasoner reasoner, OWLDataFactory dataFactory, Set<OWLSubObjectPropertyOfAxiom> result, Set<OWLObjectPropertyExpression> nonSimpleProperties) {
        OWLAPIPreconditions.checkNotNull(dataFactory, "dataFactory cannot be null");
        OWLAPIPreconditions.checkNotNull(reasoner, "reasoner cannot be null");
        OWLAPIPreconditions.checkNotNull(result, "result cannot be null");
        OWLAPIPreconditions.checkNotNull(entity, "entity cannot be null");
        for (OWLObjectPropertyExpression prop : reasoner.getSuperObjectProperties(entity, true).getFlattened()) {
            assert (prop != null);
            boolean nonSimple = false;
            boolean inverse = false;
            if (!this.simple(nonSimpleProperties, entity)) {
                nonSimple = true;
            }
            if (prop.isAnonymous() && EntitySearcher.isTransitive(prop.getInverseProperty(), reasoner.getRootOntology())) {
                inverse = true;
            }
            if (nonSimple && inverse) continue;
            result.add(dataFactory.getOWLSubObjectPropertyOfAxiom(entity, prop));
        }
    }

    @Override
    public String getLabel() {
        return "Sub object properties";
    }
}

