/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.ontology.imports;

import com.google.common.base.Optional;
import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.io.File;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import org.protege.editor.owl.OWLEditorKit;
import org.protege.editor.owl.ui.ontology.imports.OntologyImportItem;
import org.protege.editor.owl.ui.renderer.layout.FileLink;
import org.protege.editor.owl.ui.renderer.layout.HTTPLink;
import org.protege.editor.owl.ui.renderer.layout.LinkSpan;
import org.protege.editor.owl.ui.renderer.layout.Page;
import org.protege.editor.owl.ui.renderer.layout.PageCellRenderer;
import org.protege.editor.owl.ui.renderer.layout.Paragraph;
import org.protege.editor.owl.ui.renderer.layout.Span;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyID;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.util.OntologyIRIShortFormProvider;

public class OntologyImportsItemRenderer
extends PageCellRenderer {
    private OWLEditorKit editorKit;

    public OntologyImportsItemRenderer(OWLEditorKit editorKit) {
        this.editorKit = editorKit;
    }

    @Override
    protected void fillPage(Page page, JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        this.render(list.getSelectionForeground(), list.getSelectionBackground(), page, value, isSelected);
    }

    @Override
    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        Component c = super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
        return c;
    }

    private void render(Color fg, Color bg, Page page, Object value, boolean sel) {
        if (!(value instanceof OntologyImportItem)) {
            page.addParagraph(value.toString());
        } else {
            Color foreground = sel ? fg : Color.DARK_GRAY;
            OntologyImportItem item = (OntologyImportItem)value;
            OWLOntologyManager man = this.editorKit.getOWLModelManager().getOWLOntologyManager();
            OWLOntology ont = man.getImportedOntology(item.getImportDeclaration());
            OntologyIRIShortFormProvider sfp = new OntologyIRIShortFormProvider();
            Color declIRIColor = sel ? fg : Color.BLACK;
            IRI iri = item.getImportDeclaration().getIRI();
            page.addParagraph(iri.toQuotedString(), declIRIColor);
            page.setMarginBottom(5);
            if (ont != null) {
                String shortForm = sfp.getShortForm(ont);
                Paragraph ontPara = page.addParagraph(shortForm, declIRIColor);
                ontPara.setMarginTop(5);
                ontPara.setMarginLeft(40);
                OWLOntologyID ontologyID = ont.getOntologyID();
                if (!ontologyID.isAnonymous()) {
                    Paragraph ontologyIriPara = page.addParagraph("Ontology IRI: ", Color.GRAY);
                    ontologyIriPara.setMarginLeft(40);
                    IRI ontologyIRI = (IRI)ontologyID.getOntologyIRI().get();
                    ontologyIriPara.append(ontologyIRI.toQuotedString(), foreground);
                    ontologyIriPara.setMarginTop(2);
                    Optional versionIRI = ontologyID.getVersionIRI();
                    if (versionIRI.isPresent()) {
                        Paragraph versionIriPara = page.addParagraph("Version IRI: ", Color.GRAY);
                        versionIriPara.setMarginLeft(40);
                        versionIriPara.setMarginTop(2);
                        versionIriPara.append(((IRI)versionIRI.get()).toQuotedString(), foreground);
                    }
                }
                Paragraph locPara = page.addParagraph("Location: ", Color.GRAY);
                locPara.setMarginLeft(40);
                locPara.setMarginTop(2);
                IRI documentIRI = man.getOntologyDocumentIRI(ont);
                int pos = locPara.getLength();
                if ("file".equalsIgnoreCase(documentIRI.getScheme())) {
                    File file = new File(documentIRI.toURI());
                    locPara.append(file.getAbsolutePath(), foreground);
                    locPara.addLink(new LinkSpan(new FileLink(file), new Span(pos, locPara.getLength())));
                } else {
                    locPara.append(documentIRI.toString(), foreground);
                    locPara.addLink(new LinkSpan(new HTTPLink(documentIRI.toURI()), new Span(pos, locPara.getLength())));
                }
            }
        }
    }

    @Override
    protected int getMaxAvailablePageWidth(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        int width;
        Insets insets = list.getInsets();
        int componentWidth = list.getWidth();
        JViewport vp = (JViewport)SwingUtilities.getAncestorOfClass(JViewport.class, list);
        if (vp != null) {
            componentWidth = vp.getViewRect().width;
        }
        return (width = componentWidth - list.getInsets().left - list.getInsets().right - insets.left + insets.right - 20) > 0 ? width : 500;
    }

    @Override
    protected void fillPage(Page page, JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        this.render(table.getSelectionForeground(), table.getSelectionBackground(), page, value, isSelected);
    }

    @Override
    protected int getMaxAvailablePageWidth(Page page, JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        return table.getColumnModel().getColumn(column).getWidth() - 5;
    }
}

