/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.plaf.basic;

import java.awt.Color;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.UIResource;
import org.jdesktop.swingx.JXMonthView;
import org.jdesktop.swingx.action.AbstractActionExt;

public abstract class CalendarHeaderHandler {
    private static final Logger LOG = Logger.getLogger(CalendarHeaderHandler.class.getName());
    public static final String uiControllerID = "CalendarHeaderHandler";
    protected JXMonthView monthView;
    private JComponent calendarHeader;
    protected Icon monthDownImage;
    protected Icon monthUpImage;
    private PropertyChangeListener monthViewPropertyChangeListener;

    public void install(JXMonthView monthView) {
        this.monthView = monthView;
        this.monthDownImage = UIManager.getIcon("JXMonthView.monthDownFileName");
        this.monthUpImage = UIManager.getIcon("JXMonthView.monthUpFileName");
        this.installNavigationActions();
        this.installListeners();
        this.componentOrientationChanged();
        this.monthStringBackgroundChanged();
        this.fontChanged();
    }

    public void uninstall(JXMonthView monthView) {
        this.monthView.remove(this.getHeaderComponent());
        this.uninstallListeners();
        this.monthView = null;
    }

    public JComponent getHeaderComponent() {
        if (this.calendarHeader == null) {
            this.calendarHeader = this.createCalendarHeader();
        }
        return this.calendarHeader;
    }

    protected void installListeners() {
        this.monthView.addPropertyChangeListener(this.getMonthViewPropertyChangeListener());
    }

    protected void uninstallListeners() {
        this.monthView.removePropertyChangeListener(this.monthViewPropertyChangeListener);
    }

    private PropertyChangeListener getMonthViewPropertyChangeListener() {
        if (this.monthViewPropertyChangeListener == null) {
            this.monthViewPropertyChangeListener = new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent evt) {
                    if ("componentOrientation".equals(evt.getPropertyName())) {
                        CalendarHeaderHandler.this.componentOrientationChanged();
                    } else if ("font".equals(evt.getPropertyName())) {
                        CalendarHeaderHandler.this.fontChanged();
                    } else if ("monthStringBackground".equals(evt.getPropertyName())) {
                        CalendarHeaderHandler.this.monthStringBackgroundChanged();
                    }
                }
            };
        }
        return this.monthViewPropertyChangeListener;
    }

    protected void monthStringBackgroundChanged() {
        this.getHeaderComponent().setBackground(this.getAsNotUIResource(this.monthView.getMonthStringBackground()));
    }

    protected void fontChanged() {
        this.getHeaderComponent().setFont(this.getAsNotUIResource(this.createDerivedFont()));
        this.monthView.revalidate();
    }

    protected void componentOrientationChanged() {
        this.getHeaderComponent().applyComponentOrientation(this.monthView.getComponentOrientation());
        if (this.monthView.getComponentOrientation().isLeftToRight()) {
            this.updateMonthNavigationIcons(this.monthDownImage, this.monthUpImage);
        } else {
            this.updateMonthNavigationIcons(this.monthUpImage, this.monthDownImage);
        }
    }

    private void updateMonthNavigationIcons(Icon previous, Icon next) {
        this.updateActionIcon("previousMonth", previous);
        this.updateActionIcon("nextMonth", next);
    }

    private void updateActionIcon(String previousKey, Icon previous) {
        Action action = this.monthView.getActionMap().get(previousKey);
        if (action != null) {
            action.putValue("SmallIcon", previous);
        }
    }

    protected abstract JComponent createCalendarHeader();

    protected void installNavigationActions() {
        this.installWrapper("scrollToPreviousMonth", "previousMonth", this.monthView.getComponentOrientation().isLeftToRight() ? this.monthDownImage : this.monthUpImage);
        this.installWrapper("scrollToNextMonth", "nextMonth", this.monthView.getComponentOrientation().isLeftToRight() ? this.monthUpImage : this.monthDownImage);
    }

    private void installWrapper(final String actionKey, String newActionKey, Icon icon) {
        AbstractActionExt wrapper = new AbstractActionExt(null, icon){

            public void actionPerformed(ActionEvent e) {
                Action action = CalendarHeaderHandler.this.monthView.getActionMap().get(actionKey);
                if (action != null) {
                    action.actionPerformed(e);
                }
            }
        };
        this.monthView.getActionMap().put(newActionKey, wrapper);
    }

    private Font getAsNotUIResource(Font font) {
        if (!(font instanceof UIResource)) {
            return font;
        }
        return font.deriveFont(font.getAttributes());
    }

    private Color getAsNotUIResource(Color color) {
        if (!(color instanceof UIResource)) {
            return color;
        }
        float[] rgb = color.getRGBComponents(null);
        return new Color(rgb[0], rgb[1], rgb[2], rgb[3]);
    }

    protected Font createDerivedFont() {
        return this.monthView.getFont().deriveFont(1);
    }
}

