/*
 * Decompiled with CFR 0.152.
 */
package esmska.update;

import esmska.data.Config;
import esmska.data.DeprecatedGateway;
import esmska.data.Gateway;
import esmska.data.Gateways;
import esmska.data.event.ActionEventSupport;
import esmska.update.GatewayUpdateInfo;
import esmska.update.HttpDownloader;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingWorker;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.io.IOUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class UpdateChecker {
    private static UpdateChecker instance;
    public static final int ACTION_PROGRAM_UPDATE_AVAILABLE = 0;
    public static final int ACTION_GATEWAY_UPDATE_AVAILABLE = 1;
    public static final int ACTION_PROGRAM_AND_GATEWAY_UPDATE_AVAILABLE = 2;
    public static final int ACTION_NO_UPDATE_AVAILABLE = 3;
    public static final int ACTION_CHECK_FAILED = 4;
    public static final int AUTO_CHECK_INTERVAL = 7200;
    private static final Logger logger;
    private static final Config config;
    private String onlineVersion = "0.0.0";
    private String onlineUnstableVersion = "0.0.0";
    private HashSet<GatewayUpdateInfo> gatewayUpdates = new HashSet();
    private AtomicBoolean running = new AtomicBoolean();
    private ActionEventSupport actionSupport = new ActionEventSupport(this);

    public void addActionListener(ActionListener actionListener) {
        this.actionSupport.addActionListener(actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        this.actionSupport.removeActionListener(actionListener);
    }

    private UpdateChecker() {
    }

    public static UpdateChecker getInstance() {
        if (instance == null) {
            instance = new UpdateChecker();
        }
        return instance;
    }

    public void checkForUpdates() {
        if (this.running.get()) {
            return;
        }
        this.running.set(true);
        logger.fine("Checking for program updates...");
        final HttpDownloader downloader = new HttpDownloader("http://ripper.profitux.cz/esmska/update/version.xml", false);
        downloader.addPropertyChangeListener(new PropertyChangeListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName().equals("state") && evt.getNewValue() == SwingWorker.StateValue.DONE) {
                    try {
                        if (!downloader.isFinishedOk()) {
                            throw new IOException("Could not download version file");
                        }
                        UpdateChecker.this.parseVersionFile(downloader.getTextContent());
                        boolean updateAvailable = UpdateChecker.this.isProgramUpdateAvailable();
                        logger.fine("Found program update: " + (updateAvailable ? UpdateChecker.this.getLatestProgramVersion() : "false"));
                        boolean gatewayUpdateAvailable = UpdateChecker.this.isGatewayUpdateAvailable(true);
                        logger.fine("Found gateway update: " + gatewayUpdateAvailable);
                        if (updateAvailable) {
                            if (gatewayUpdateAvailable) {
                                UpdateChecker.this.actionSupport.fireActionPerformed(2, null);
                            } else {
                                UpdateChecker.this.actionSupport.fireActionPerformed(0, null);
                            }
                        } else if (gatewayUpdateAvailable) {
                            UpdateChecker.this.actionSupport.fireActionPerformed(1, null);
                        } else {
                            UpdateChecker.this.actionSupport.fireActionPerformed(3, null);
                        }
                    }
                    catch (Exception e) {
                        logger.log(Level.WARNING, "Could not check for updates", e);
                        UpdateChecker.this.actionSupport.fireActionPerformed(4, null);
                    }
                    finally {
                        UpdateChecker.this.running.set(false);
                    }
                }
            }
        });
        downloader.execute();
    }

    private synchronized void parseVersionFile(String text) throws Exception {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        XPathFactory xpf = XPathFactory.newInstance();
        XPath xpath = xpf.newXPath();
        Document doc = db.parse(IOUtils.toInputStream(text, "UTF-8"));
        this.onlineVersion = doc.getElementsByTagName("latestStableVersion").item(0).getTextContent();
        this.onlineUnstableVersion = doc.getElementsByTagName("latestUnstableVersion").item(0).getTextContent();
        this.gatewayUpdates.clear();
        NodeList gateways = doc.getElementsByTagName("gateway");
        for (int i = 0; i < gateways.getLength(); ++i) {
            Node gateway = gateways.item(i);
            String name = xpath.evaluate("name/text()", gateway);
            String fileName = xpath.evaluate("fileName/text()", gateway);
            String version = xpath.evaluate("version/text()", gateway);
            String minVersion = xpath.evaluate("minProgramVersion/text()", gateway);
            String url = xpath.evaluate("downloadURL/text()", gateway);
            String iconUrl = xpath.evaluate("iconURL/text()", gateway);
            GatewayUpdateInfo info = new GatewayUpdateInfo(name, fileName, version, minVersion, url, iconUrl);
            this.gatewayUpdates.add(info);
        }
        this.refreshUpdatedGateways();
    }

    private void refreshUpdatedGateways() {
        Iterator<GatewayUpdateInfo> it = this.gatewayUpdates.iterator();
        while (it.hasNext()) {
            GatewayUpdateInfo info = it.next();
            Gateway gw = Gateways.getInstance().get(info.getName());
            if (gw != null && info.getVersion().compareTo(gw.getVersion()) <= 0) {
                it.remove();
                continue;
            }
            if (Config.compareProgramVersions(info.getMinProgramVersion(), Config.getLatestVersion()) > 0) {
                it.remove();
                continue;
            }
            for (DeprecatedGateway depr : Gateways.getInstance().getDeprecatedGateways()) {
                if (!info.getName().equals(depr.getName()) || info.getVersion().compareTo(depr.getVersion()) > 0) continue;
                it.remove();
            }
        }
    }

    private Set<GatewayUpdateInfo> filterVisibleGateways() {
        HashSet<GatewayUpdateInfo> visible = new HashSet<GatewayUpdateInfo>();
        for (GatewayUpdateInfo info : this.gatewayUpdates) {
            Gateway gw = Gateways.getInstance().get(info.getName());
            if (gw == null || gw.isHidden()) continue;
            visible.add(info);
        }
        return visible;
    }

    public boolean isRunning() {
        return this.running.get();
    }

    public synchronized boolean isProgramUpdateAvailable() {
        if (config.isAnnounceUnstableUpdates()) {
            return Config.compareProgramVersions(this.onlineUnstableVersion, Config.getLatestVersion()) > 0;
        }
        return Config.compareProgramVersions(this.onlineVersion, Config.getLatestVersion()) > 0;
    }

    public synchronized String getLatestProgramVersion() {
        return config.isAnnounceUnstableUpdates() ? this.onlineUnstableVersion : this.onlineVersion;
    }

    public synchronized boolean isGatewayUpdateAvailable(boolean includeHidden) {
        this.refreshUpdatedGateways();
        if (includeHidden) {
            return !this.gatewayUpdates.isEmpty();
        }
        return !this.filterVisibleGateways().isEmpty();
    }

    public synchronized Set<GatewayUpdateInfo> getGatewayUpdates(boolean includeHidden) {
        this.refreshUpdatedGateways();
        if (includeHidden) {
            return Collections.unmodifiableSet(this.gatewayUpdates);
        }
        return this.filterVisibleGateways();
    }

    static {
        logger = Logger.getLogger(UpdateChecker.class.getName());
        config = Config.getInstance();
    }
}

