/*
 * Decompiled with CFR 0.152.
 */
package jadx.api;

import jadx.api.JadxDecompiler;
import jadx.api.ResourceType;
import jadx.api.ResourcesLoader;
import jadx.api.plugins.utils.ZipSecurity;
import jadx.core.xmlgen.ResContainer;
import jadx.core.xmlgen.entry.ResourceEntry;
import java.io.File;

public class ResourceFile {
    private final JadxDecompiler decompiler;
    private final String name;
    private final ResourceType type;
    private ZipRef zipRef;
    private String deobfName;

    public static ResourceFile createResourceFile(JadxDecompiler decompiler, String name, ResourceType type) {
        if (!ZipSecurity.isValidZipEntryName((String)name)) {
            return null;
        }
        return new ResourceFile(decompiler, name, type);
    }

    protected ResourceFile(JadxDecompiler decompiler, String name, ResourceType type) {
        this.decompiler = decompiler;
        this.name = name;
        this.type = type;
    }

    public String getOriginalName() {
        return this.name;
    }

    public String getDeobfName() {
        return this.deobfName != null ? this.deobfName : this.name;
    }

    public ResourceType getType() {
        return this.type;
    }

    public ResContainer loadContent() {
        return ResourcesLoader.loadContent(this.decompiler, this);
    }

    void setZipRef(ZipRef zipRef) {
        this.zipRef = zipRef;
    }

    public void setAlias(ResourceEntry ri) {
        int index = this.name.lastIndexOf(46);
        this.deobfName = String.format("res/%s%s/%s%s", ri.getTypeName(), ri.getConfig(), ri.getKeyName(), index == -1 ? "" : this.name.substring(index));
    }

    public ZipRef getZipRef() {
        return this.zipRef;
    }

    public String toString() {
        return "ResourceFile{name='" + this.name + '\'' + ", type=" + (Object)((Object)this.type) + '}';
    }

    public static final class ZipRef {
        private final File zipFile;
        private final String entryName;

        public ZipRef(File zipFile, String entryName) {
            this.zipFile = zipFile;
            this.entryName = entryName;
        }

        public File getZipFile() {
            return this.zipFile;
        }

        public String getEntryName() {
            return this.entryName;
        }

        public String toString() {
            return "ZipRef{" + this.zipFile + ", '" + this.entryName + "'}";
        }
    }
}

