/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.dex.visitors;

import jadx.core.dex.attributes.AFlag;
import jadx.core.dex.attributes.nodes.MethodInlineAttr;
import jadx.core.dex.info.MethodInfo;
import jadx.core.dex.instructions.InsnType;
import jadx.core.dex.instructions.InvokeNode;
import jadx.core.dex.instructions.args.ArgType;
import jadx.core.dex.instructions.args.InsnArg;
import jadx.core.dex.instructions.args.RegisterArg;
import jadx.core.dex.instructions.args.SSAVar;
import jadx.core.dex.nodes.BlockNode;
import jadx.core.dex.nodes.InsnNode;
import jadx.core.dex.nodes.MethodNode;
import jadx.core.dex.visitors.AbstractVisitor;
import jadx.core.dex.visitors.InitCodeVariables;
import jadx.core.dex.visitors.JadxVisitor;
import jadx.core.dex.visitors.MarkMethodsForInline;
import jadx.core.dex.visitors.ModVisitor;
import jadx.core.dex.visitors.typeinference.TypeInferenceVisitor;
import jadx.core.utils.BlockUtils;
import jadx.core.utils.exceptions.JadxException;
import jadx.core.utils.exceptions.JadxRuntimeException;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JadxVisitor(name="InlineMethods", desc="Inline methods (previously marked in MarkMethodsForInline)", runAfter={TypeInferenceVisitor.class}, runBefore={ModVisitor.class})
public class InlineMethods
extends AbstractVisitor {
    private static final Logger LOG = LoggerFactory.getLogger(InlineMethods.class);

    @Override
    public void visit(MethodNode mth) throws JadxException {
        if (mth.isNoCode()) {
            return;
        }
        for (BlockNode block : mth.getBasicBlocks()) {
            for (InsnNode insn : block.getInstructions()) {
                if (insn.getType() != InsnType.INVOKE) continue;
                this.processInvokeInsn(mth, block, (InvokeNode)insn);
            }
        }
    }

    private void processInvokeInsn(MethodNode mth, BlockNode block, InvokeNode insn) {
        MethodInfo callMthInfo = insn.getCallMth();
        MethodNode callMth = mth.root().deepResolveMethod(callMthInfo);
        if (callMth == null) {
            return;
        }
        try {
            MethodInlineAttr mia = MarkMethodsForInline.process(callMth);
            if (mia == null) {
                callMth.getParentClass().reloadAtCodegenStage();
                return;
            }
            if (mia.notNeeded()) {
                return;
            }
            this.inlineMethod(mth, callMth, mia, block, insn);
        }
        catch (Exception e) {
            throw new JadxRuntimeException("Failed to process method for inline: " + callMthInfo, e);
        }
    }

    private void inlineMethod(MethodNode mth, MethodNode callMth, MethodInlineAttr mia, BlockNode block, InvokeNode insn) {
        Object inlCopy = mia.getInsn().copyWithoutResult();
        RegisterArg resultArg = insn.getResult();
        if (resultArg != null) {
            ((InsnNode)inlCopy).setResult(resultArg.duplicate());
        } else if (this.isAssignNeeded(mia.getInsn(), insn, callMth)) {
            ((InsnNode)inlCopy).setResult(this.makeFakeArg(mth, callMth.getReturnType(), "unused"));
        }
        if (!callMth.getMethodInfo().getArgumentsTypes().isEmpty()) {
            InsnArg[] regs = new InsnArg[callMth.getRegsCount()];
            int[] regNums = mia.getArgsRegNums();
            for (int i = 0; i < regNums.length; ++i) {
                InsnArg arg;
                regs[regNums[i]] = arg = insn.getArg(i);
            }
            ArrayList<RegisterArg> inlArgs = new ArrayList<RegisterArg>();
            ((InsnNode)inlCopy).getRegisterArgs(inlArgs);
            for (RegisterArg r : inlArgs) {
                int regNum = r.getRegNum();
                if (regNum >= regs.length) {
                    LOG.warn("Unknown register number {} in method call: {} from {}", new Object[]{r, callMth, mth});
                    continue;
                }
                InsnArg repl = regs[regNum];
                if (repl == null) {
                    LOG.warn("Not passed register {} in method call: {} from {}", new Object[]{r, callMth, mth});
                    continue;
                }
                ((InsnNode)inlCopy).replaceArg(r, repl);
            }
        }
        if (!BlockUtils.replaceInsn(mth, block, insn, inlCopy)) {
            mth.addWarnComment("Failed to inline method: " + callMth);
        }
    }

    private boolean isAssignNeeded(InsnNode inlineInsn, InvokeNode parentInsn, MethodNode callMthNode) {
        if (parentInsn.getResult() != null) {
            return false;
        }
        if (parentInsn.contains(AFlag.WRAPPED)) {
            return false;
        }
        if (inlineInsn.getType() == InsnType.IPUT) {
            return false;
        }
        return !callMthNode.isVoidReturn();
    }

    private RegisterArg makeFakeArg(MethodNode mth, ArgType varType, String name) {
        RegisterArg fakeArg = RegisterArg.reg(0, varType);
        SSAVar ssaVar = mth.makeNewSVar(fakeArg);
        InitCodeVariables.initCodeVar(ssaVar);
        fakeArg.setName(name);
        ssaVar.setType(varType);
        return fakeArg;
    }
}

