/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.util;

import java.awt.Color;
import java.awt.Font;
import java.util.List;
import org.gjt.sp.jedit.syntax.SyntaxStyle;
import org.gjt.sp.util.SyntaxUtilities;

public class HtmlUtilities {
    public static SyntaxStyle parseHighlightStyle(String string, Font font) {
        SyntaxStyle syntaxStyle;
        try {
            syntaxStyle = SyntaxUtilities.parseStyle(string, font.getFamily(), font.getSize(), true, null);
        }
        catch (Exception exception) {
            string = "color:#000000";
            syntaxStyle = SyntaxUtilities.parseStyle(string, font.getFamily(), font.getSize(), true);
        }
        return syntaxStyle;
    }

    public static String style2html(String string, Font font) {
        StringBuilder stringBuilder = new StringBuilder();
        SyntaxStyle syntaxStyle = HtmlUtilities.parseHighlightStyle(string, font);
        Color color = syntaxStyle.getForegroundColor();
        if (color != null) {
            stringBuilder.append("color:").append(HtmlUtilities.color2html(color));
        }
        if ((color = syntaxStyle.getBackgroundColor()) != null) {
            stringBuilder.append("background:").append(HtmlUtilities.color2html(color));
        }
        if ((font = syntaxStyle.getFont()).isBold()) {
            stringBuilder.append("font-weight:bold;");
        }
        if (font.isItalic()) {
            stringBuilder.append("font-style: italic;");
        }
        return stringBuilder.toString();
    }

    public static String highlightString(String string, String string2, List<Integer> list) {
        StringBuilder stringBuilder = new StringBuilder("<html><style>.highlight {");
        stringBuilder.append(string2);
        stringBuilder.append("}</style><body>");
        int n = 0;
        for (int i = 0; i < list.size(); i += 2) {
            int n2 = list.get(i);
            int n3 = list.get(i + 1);
            HtmlUtilities.appendString2html(stringBuilder, string.substring(n, n2));
            stringBuilder.append("<span class=\"highlight\">");
            HtmlUtilities.appendString2html(stringBuilder, string.substring(n2, n3));
            stringBuilder.append("</span>");
            n = n3;
        }
        HtmlUtilities.appendString2html(stringBuilder, string.substring(n));
        stringBuilder.append("</body></html>");
        return stringBuilder.toString();
    }

    public static void appendString2html(StringBuilder stringBuilder, String string) {
        for (int i = 0; i < string.length(); ++i) {
            String string2;
            char c = string.charAt(i);
            switch (c) {
                case '\"': {
                    string2 = "&quot;";
                    break;
                }
                case '&': {
                    string2 = "&amp;";
                    break;
                }
                case '<': {
                    string2 = "&lt;";
                    break;
                }
                case '>': {
                    string2 = "&gt;";
                    break;
                }
                case ' ': {
                    string2 = "&nbsp;";
                    break;
                }
                default: {
                    string2 = String.valueOf(c);
                }
            }
            stringBuilder.append(string2);
        }
    }

    private static String color2html(Color color) {
        return "rgb(" + color.getRed() + "," + color.getGreen() + "," + color.getBlue() + ");";
    }
}

