/*
 * Decompiled with CFR 0.152.
 */
package org.jsampler.view.fantasia;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.BorderFactory;
import net.sf.juife.JuifeUtils;
import org.jsampler.view.fantasia.FantasiaI18n;
import org.jsampler.view.fantasia.FantasiaPrefs;
import org.jsampler.view.fantasia.MidiInstrumentsPane;
import org.jsampler.view.fantasia.OrchestrasPane;
import org.jsampler.view.fantasia.basic.FantasiaPanel;
import org.jsampler.view.fantasia.basic.FantasiaTabbedPane;

public class LeftSidePane
extends FantasiaPanel {
    FantasiaTabbedPane tabbedPane = new FantasiaTabbedPane();
    private final OrchestrasPane orchestraPane = new OrchestrasPane();
    private final MidiInstrumentsPane midiInstrumentsPane = new MidiInstrumentsPane();

    public LeftSidePane() {
        this.setOpaque(false);
        this.setLayout(new BorderLayout());
        FantasiaTabbedPane fantasiaTabbedPane = this.tabbedPane;
        fantasiaTabbedPane.getMainPane().setBorder(BorderFactory.createEmptyBorder(0, 1, 1, 1));
        fantasiaTabbedPane.addTab(FantasiaI18n.i18n.getLabel("LeftSidePane.tabOrchestras"), this.orchestraPane);
        fantasiaTabbedPane.addTab(FantasiaI18n.i18n.getLabel("LeftSidePane.tabMidiInstruments"), this.midiInstrumentsPane);
        Dimension dimension = JuifeUtils.getUnionSize((Component)fantasiaTabbedPane.getTabButton(0), fantasiaTabbedPane.getTabButton(1));
        fantasiaTabbedPane.getTabButton(0).setPreferredSize(dimension);
        fantasiaTabbedPane.getTabButton(1).setPreferredSize(dimension);
        fantasiaTabbedPane.getTabButton(0).setMinimumSize(dimension);
        fantasiaTabbedPane.getTabButton(1).setMinimumSize(dimension);
        this.add(fantasiaTabbedPane);
        int n = FantasiaPrefs.preferences().getIntProperty("leftSidePane.tabIndex", 0);
        if (fantasiaTabbedPane.getTabCount() > n) {
            fantasiaTabbedPane.setSelectedIndex(n);
        }
        this.setBorder(BorderFactory.createEmptyBorder(0, 3, 6, 0));
    }

    public void savePreferences() {
        this.orchestraPane.savePreferences();
        this.midiInstrumentsPane.savePreferences();
        int n = this.tabbedPane.getSelectedIndex();
        if (n != -1) {
            FantasiaPrefs.preferences().setIntProperty("leftSidePane.tabIndex", n);
        }
    }
}

