import hl = require("../highLevelAST");
import ll = require("../lowLevelAST");
import hlImpl = require("../highLevelImpl");
import def = require("raml-definition-system");
import rt = def.rt;
import defaultCalculator = require("./defaultCalculator");
import jsonSerializer = require("../../util/jsonSerializer");
import parserCoreApi = require("./parserCoreApi");
export declare type AbstractWrapperNode = hl.AbstractWrapperNode;
export declare type BasicNode = hl.BasicNode;
export declare type SerializeOptions = hl.SerializeOptions;
export declare type ValueMetadata = hl.ValueMetadata;
export declare class BasicNodeImpl implements hl.BasicNode {
    protected _node: hl.IHighLevelNode;
    private defaultsCalculator;
    _meta: NodeMetadataImpl;
    private static CLASS_IDENTIFIER;
    static isInstance(instance: any): boolean;
    getClassIdentifier(): string[];
    /**
     * @hidden
     **/
    constructor(_node: hl.IHighLevelNode, setAsWrapper?: boolean);
    /**
     * @hidden
     **/
    wrapperClassName(): string;
    kind(): string;
    /**
     * Returns all kinds of this node.
     * @returns {string[]}
     */
    allKinds(): string[];
    /**
     * Returns all of implementation class names of this node.
     * @returns {string[]}
     */
    allWrapperClassNames(): string[];
    /**
     * @return Direct ancestor in RAML hierarchy
     **/
    parent(): BasicNode;
    /**
     * @hidden
     * @return Underlying node of the High Level model
     **/
    highLevel(): hl.IHighLevelNode;
    /**
     * @hidden
     * Replace underlying high level node
     **/
    patchNode(node: hl.IHighLevelNode): void;
    /**
     * @hidden
     **/
    protected attributes(name: string, constr?: (attr: hl.IAttribute) => any): any[];
    /**
     * @hidden
     **/
    protected attribute(name: string, constr?: (attr: hl.IAttribute) => any): any;
    /**
     * @hidden
     **/
    protected elements(name: string): any[];
    /**
     * @hidden
     **/
    protected element(name: string): any;
    /**
     * Append node as child
     * @param node node to be appended
     **/
    add(node: BasicNodeImpl): void;
    /**
     * Append node as property value
     * @param node node to be set as property value
     * @param prop name of property to set value for
     **/
    addToProp(node: BasicNodeImpl, prop: string): void;
    /**
     * Remove node from children set
     * @param node node to be removed
     **/
    remove(node: BasicNodeImpl): void;
    /**
     * @return YAML string representing the node
     **/
    dump(): string;
    toString(arg: any): string;
    toAny(arg: any): any;
    toBoolean(arg: any): boolean;
    toNumber(arg: any): any;
    /**
     * @return Array of errors
     **/
    errors(): RamlParserError[];
    /**
     * @return object representing class of the node
     **/
    definition(): hl.ITypeDefinition;
    /**
     * @return for user class instances returns object representing actual user class
     **/
    runtimeDefinition(): hl.ITypeDefinition;
    toJSON(serializeOptions?: jsonSerializer.SerializeOptions): any;
    /**
     * @return Whether the element is an optional sibling of trait or resource type
     **/
    optional(): boolean;
    /**
     * @return For siblings of traits or resource types returns an array of optional properties names.
     **/
    optionalProperties(): string[];
    /**
     * @hidden
     **/
    getDefaultsCalculator(): defaultCalculator.AttributeDefaultsCalculator;
    /**
     * @hidden
     **/
    setAttributeDefaults(attributeDefaults: boolean): void;
    attributeDefaults(): boolean;
    meta(): NodeMetadata;
    RAMLVersion(): string;
}
export declare class AttributeNodeImpl implements parserCoreApi.AttributeNode {
    protected attr: hl.IAttribute;
    protected _meta: ValueMetadataImpl;
    private static CLASS_IDENTIFIER;
    static isInstance(instance: any): boolean;
    getClassIdentifier(): string[];
    constructor(attr: hl.IAttribute);
    /**
     * @return Underlying High Level attribute node
     **/
    highLevel(): hl.IAttribute;
    /**
     * @hidden
     **/
    wrapperClassName(): string;
    kind(): string;
    /**
     * Returns all kinds of this node.
     * @returns {string[]}
     */
    allKinds(): string[];
    /**
     * Returns all of implementation class names of this node.
     * @returns {string[]}
     */
    allWrapperClassNames(): string[];
    /**
     * @return Whether the element is an optional sibling of trait or resource type
     **/
    optional(): boolean;
    meta(): ValueMetadataImpl;
    RAMLVersion(): string;
    parent(): BasicNode;
    toJSON(serializeOptions?: jsonSerializer.SerializeOptions): any;
}
/**
 * @hidden
 **/
export declare function toStructuredValue(node: hl.IAttribute): hlImpl.StructuredValue;
export declare type RamlParserError = hl.RamlParserError;
export interface ApiLoadingError extends Error {
    parserErrors: RamlParserError[];
}
export declare class TypeInstanceImpl {
    protected type?: rt.IParsedType;
    private static CLASS_IDENTIFIER;
    static isInstance(instance: any): boolean;
    getClassIdentifier(): string[];
    constructor(nodes: ll.ILowLevelASTNode | ll.ILowLevelASTNode[], type?: rt.IParsedType);
    protected node: ll.ILowLevelASTNode;
    protected children: ll.ILowLevelASTNode[];
    properties(): TypeInstancePropertyImpl[];
    private getChildren;
    value(): any;
    isScalar(): boolean;
    toJSON(): any;
    isArray(): boolean;
    items(): TypeInstanceImpl[];
}
export declare class TypeInstancePropertyImpl {
    protected node: ll.ILowLevelASTNode;
    private static CLASS_IDENTIFIER;
    static isInstance(instance: any): boolean;
    getClassIdentifier(): string[];
    constructor(node: ll.ILowLevelASTNode);
    name(): string;
    value(): TypeInstanceImpl;
    values(): TypeInstanceImpl[];
    isArray(): boolean;
}
export declare type ValueMetaData = hl.ValueMetadata;
export declare type NodeMetadata = hl.NodeMetadata;
export declare class ValueMetadataImpl implements ValueMetadata {
    protected _insertedAsDefault: boolean;
    protected _calculated: boolean;
    protected _optional: boolean;
    constructor(_insertedAsDefault?: boolean, _calculated?: boolean, _optional?: boolean);
    calculated(): boolean;
    insertedAsDefault(): boolean;
    setCalculated(): void;
    setInsertedAsDefault(): void;
    setOptional(): void;
    optional(): boolean;
    isDefault(): boolean;
    toJSON(): {};
}
export declare class NodeMetadataImpl extends ValueMetadataImpl implements NodeMetadata {
    valuesMeta: {
        [key: string]: ValueMetadata;
    };
    primitiveValuesMeta(): {
        [key: string]: ValueMetadata;
    };
    registerInsertedAsDefaultValue(propName: string): void;
    registerCalculatedValue(propName: string): void;
    registerOptionalValue(propName: string): void;
    resetPrimitiveValuesMeta(): void;
    isDefault(): boolean;
    toJSON(): {};
}
export declare function fillElementMeta(node: BasicNodeImpl): NodeMetadataImpl;
export declare function attributesToValues(attrs: hl.IAttribute[], constr?: (attr: hl.IAttribute) => any): any[];
/**
 * @hidden
 */
export declare function errors(_node: hl.IHighLevelNode): RamlParserError[];
/**
 * @hidden
 */
export declare function filterErrors(rawErrors: RamlParserError[]): RamlParserError[];
/**
 * @hidden
 */
export declare function basicError(_node: hl.IHighLevelNode, x: hl.ValidationIssue): RamlParserError;
