/*
 * Decompiled with CFR 0.152.
 */
package org.testng.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.testng.DependencyMap;
import org.testng.ITestNGMethod;
import org.testng.TestNGException;
import org.testng.TestRunner;
import org.testng.collections.ListMultiMap;
import org.testng.collections.Lists;
import org.testng.collections.Maps;
import org.testng.collections.MultiMap;
import org.testng.internal.DynamicGraph;
import org.testng.internal.WrappedTestNGMethod;
import org.testng.xml.XmlClass;
import org.testng.xml.XmlSuite;
import org.testng.xml.XmlTest;

public final class DynamicGraphHelper {
    private DynamicGraphHelper() {
    }

    public static DynamicGraph<ITestNGMethod> createDynamicGraph(ITestNGMethod[] iTestNGMethodArray, XmlTest xmlTest) {
        Object object;
        boolean bl;
        DynamicGraph<ITestNGMethod> dynamicGraph = new DynamicGraph<ITestNGMethod>();
        ListMultiMap<Integer, ITestNGMethod> listMultiMap = Maps.newListMultiMap();
        for (ITestNGMethod object2 : iTestNGMethodArray) {
            listMultiMap.put(object2.getPriority(), object2);
        }
        List list = Lists.newArrayList(listMultiMap.keySet());
        Collections.sort(list);
        Integer object3 = iTestNGMethodArray.length > 0 ? (Integer)list.get(0) : 0;
        for (int i = 1; i < list.size(); ++i) {
            Integer n = (Integer)list.get(i);
            for (ITestNGMethod iTestNGMethod : (List)listMultiMap.get(object3)) {
                for (ITestNGMethod iTestNGMethod2 : (List)listMultiMap.get(n)) {
                    dynamicGraph.addEdge(TestRunner.PriorityWeight.priority.ordinal(), iTestNGMethod2, iTestNGMethod);
                }
            }
            object3 = n;
        }
        DependencyMap dependencyMap = new DependencyMap(iTestNGMethodArray);
        boolean bl2 = false;
        for (ITestNGMethod iTestNGMethod : iTestNGMethodArray) {
            Object object2;
            int n;
            String[] stringArray;
            String[] stringArray2;
            boolean bl3 = dynamicGraph.addNode(iTestNGMethod);
            if (!bl3) {
                dynamicGraph.addNode(new WrappedTestNGMethod(iTestNGMethod));
            }
            if ((stringArray2 = iTestNGMethod.getMethodsDependedUpon()) != null) {
                stringArray = stringArray2;
                int n2 = stringArray.length;
                for (n = 0; n < n2; ++n) {
                    String string = stringArray[n];
                    object2 = dependencyMap.getMethodDependingOn(string, iTestNGMethod);
                    if (iTestNGMethod == object2) continue;
                    dynamicGraph.addEdge(TestRunner.PriorityWeight.dependsOnMethods.ordinal(), iTestNGMethod, (ITestNGMethod)object2);
                }
            }
            String[] stringArray3 = stringArray = iTestNGMethod.getGroupsDependedUpon();
            n = stringArray3.length;
            for (int i = 0; i < n; ++i) {
                object2 = stringArray3[i];
                bl = true;
                List<ITestNGMethod> list2 = dependencyMap.getMethodsThatBelongTo((String)object2, iTestNGMethod);
                if (list2 == null) {
                    throw new TestNGException("Method \"" + iTestNGMethod + "\" depends on nonexistent group \"" + (String)object2 + "\"");
                }
                for (ITestNGMethod iTestNGMethod3 : list2) {
                    dynamicGraph.addEdge(TestRunner.PriorityWeight.dependsOnGroups.ordinal(), iTestNGMethod, iTestNGMethod3);
                }
            }
        }
        if (!bl && xmlTest.getParallel() == XmlSuite.ParallelMode.NONE && xmlTest.getPreserveOrder().booleanValue()) {
            object = DynamicGraphHelper.createClassDependencies(iTestNGMethodArray, xmlTest);
            for (Map.Entry entry : ((MultiMap)object).entrySet()) {
                for (ITestNGMethod iTestNGMethod : (List)entry.getValue()) {
                    dynamicGraph.addEdge(TestRunner.PriorityWeight.preserveOrder.ordinal(), iTestNGMethod, (ITestNGMethod)entry.getKey());
                }
            }
        }
        if (xmlTest.getGroupByInstances()) {
            object = DynamicGraphHelper.createInstanceDependencies(iTestNGMethodArray);
            for (Map.Entry entry : ((MultiMap)object).entrySet()) {
                dynamicGraph.addEdge(TestRunner.PriorityWeight.groupByInstance.ordinal(), (ITestNGMethod)entry.getKey(), (Iterable)entry.getValue());
            }
        }
        return dynamicGraph;
    }

    private static Comparator<XmlClass> classComparator() {
        return new Comparator<XmlClass>(){

            @Override
            public int compare(XmlClass xmlClass, XmlClass xmlClass2) {
                return xmlClass.getIndex() - xmlClass2.getIndex();
            }
        };
    }

    private static ListMultiMap<ITestNGMethod, ITestNGMethod> createClassDependencies(ITestNGMethod[] iTestNGMethodArray, XmlTest xmlTest) {
        Object object2;
        Map map = Maps.newHashMap();
        List<Object> list = Lists.newArrayList();
        for (XmlClass object22 : xmlTest.getXmlClasses()) {
            map.put(object22.getName(), new ArrayList());
            if (list.contains(object22)) continue;
            list.add(object22);
        }
        Collections.sort(list, DynamicGraphHelper.classComparator());
        Map map2 = Maps.newHashMap();
        Map<Integer, String> map3 = Maps.newHashMap();
        int n = 0;
        for (Object object2 : list) {
            map2.put(((XmlClass)object2).getName(), n);
            map3.put(n, ((XmlClass)object2).getName());
            ++n;
        }
        ListMultiMap listMultiMap = Maps.newListMultiMap();
        for (ITestNGMethod iTestNGMethod : iTestNGMethodArray) {
            listMultiMap.put(iTestNGMethod.getTestClass().getName(), iTestNGMethod);
        }
        object2 = Maps.newListMultiMap();
        for (ITestNGMethod iTestNGMethod : iTestNGMethodArray) {
            String string = iTestNGMethod.getTestClass().getName();
            Integer n2 = (Integer)map2.get(string);
            if (n2 == null || n2 <= 0) continue;
            String string2 = (String)map3.get(n2 - 1);
            List list2 = (List)listMultiMap.get(string2);
            for (ITestNGMethod iTestNGMethod2 : list2) {
                ((MultiMap)object2).put(iTestNGMethod2, iTestNGMethod);
            }
        }
        return object2;
    }

    private static ListMultiMap<ITestNGMethod, ITestNGMethod> createInstanceDependencies(ITestNGMethod[] iTestNGMethodArray) {
        ListMultiMap<Object, ITestNGMethod> listMultiMap = Maps.newSortedListMultiMap();
        for (ITestNGMethod object : iTestNGMethodArray) {
            listMultiMap.put(object.getInstance(), object);
        }
        ListMultiMap listMultiMap2 = Maps.newListMultiMap();
        Object k = null;
        for (Map.Entry entry : listMultiMap.entrySet()) {
            if (k == null) {
                k = entry.getKey();
                continue;
            }
            List list = (List)listMultiMap.get(k);
            Object k2 = entry.getKey();
            List list2 = (List)listMultiMap.get(k2);
            for (ITestNGMethod iTestNGMethod : list2) {
                for (ITestNGMethod iTestNGMethod2 : list) {
                    listMultiMap2.put(iTestNGMethod, iTestNGMethod2);
                }
            }
            k = k2;
        }
        return listMultiMap2;
    }
}

