/*
 * Decompiled with CFR 0.152.
 */
package org.testng.reporters;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.text.NumberFormat;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.testng.IReporter;
import org.testng.ISuite;
import org.testng.ISuiteResult;
import org.testng.ITestContext;
import org.testng.ITestResult;
import org.testng.Reporter;
import org.testng.collections.Lists;
import org.testng.internal.Utils;
import org.testng.log4testng.Logger;
import org.testng.xml.XmlSuite;

public class EmailableReporter2
implements IReporter {
    private static final Logger LOG = Logger.getLogger(EmailableReporter2.class);
    protected PrintWriter writer;
    protected final List<SuiteResult> suiteResults = Lists.newArrayList();
    private final StringBuilder buffer = new StringBuilder();
    private String fileName = "emailable-report.html";
    private static final String JVM_ARG = "emailable.report2.name";

    public void setFileName(String string) {
        this.fileName = string;
    }

    public String getFileName() {
        return this.fileName;
    }

    @Override
    public void generateReport(List<XmlSuite> list, List<ISuite> list2, String string) {
        try {
            this.writer = this.createWriter(string);
        }
        catch (IOException iOException) {
            LOG.error("Unable to create output file", iOException);
            return;
        }
        for (ISuite iSuite : list2) {
            this.suiteResults.add(new SuiteResult(iSuite));
        }
        this.writeDocumentStart();
        this.writeHead();
        this.writeBody();
        this.writeDocumentEnd();
        this.writer.close();
    }

    protected PrintWriter createWriter(String string) throws IOException {
        new File(string).mkdirs();
        String string2 = System.getProperty(JVM_ARG);
        if (string2 != null && !string2.trim().isEmpty()) {
            this.fileName = string2;
        }
        return new PrintWriter(Files.newBufferedWriter(new File(string, this.fileName).toPath(), StandardCharsets.UTF_8, new OpenOption[0]));
    }

    protected void writeDocumentStart() {
        this.writer.println("<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.1//EN\" \"http://www.w3.org/TR/xhtml11/DTD/xhtml11.dtd\">");
        this.writer.println("<html xmlns=\"http://www.w3.org/1999/xhtml\">");
    }

    protected void writeHead() {
        this.writer.println("<head>");
        this.writer.println("<meta http-equiv=\"content-type\" content=\"text/html; charset=UTF-8\"/>");
        this.writer.println("<title>TestNG Report</title>");
        this.writeStylesheet();
        this.writer.println("</head>");
    }

    protected void writeStylesheet() {
        this.writer.print("<style type=\"text/css\">");
        this.writer.print("table {margin-bottom:10px;border-collapse:collapse;empty-cells:show}");
        this.writer.print("th,td {border:1px solid #009;padding:.25em .5em}");
        this.writer.print("th {vertical-align:bottom}");
        this.writer.print("td {vertical-align:top}");
        this.writer.print("table a {font-weight:bold}");
        this.writer.print(".stripe td {background-color: #E6EBF9}");
        this.writer.print(".num {text-align:right}");
        this.writer.print(".passedodd td {background-color: #3F3}");
        this.writer.print(".passedeven td {background-color: #0A0}");
        this.writer.print(".skippedodd td {background-color: #DDD}");
        this.writer.print(".skippedeven td {background-color: #CCC}");
        this.writer.print(".failedodd td,.attn {background-color: #F33}");
        this.writer.print(".failedeven td,.stripe .attn {background-color: #D00}");
        this.writer.print(".stacktrace {white-space:pre;font-family:monospace}");
        this.writer.print(".totop {font-size:85%;text-align:center;border-bottom:2px solid #000}");
        this.writer.print(".invisible {display:none}");
        this.writer.println("</style>");
    }

    protected void writeBody() {
        this.writer.println("<body>");
        this.writeSuiteSummary();
        this.writeScenarioSummary();
        this.writeScenarioDetails();
        this.writer.println("</body>");
    }

    protected void writeDocumentEnd() {
        this.writer.println("</html>");
    }

    protected void writeSuiteSummary() {
        NumberFormat numberFormat = NumberFormat.getIntegerInstance();
        NumberFormat numberFormat2 = NumberFormat.getNumberInstance();
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        long l = 0L;
        this.writer.println("<table>");
        this.writer.print("<tr>");
        this.writer.print("<th>Test</th>");
        this.writer.print("<th># Passed</th>");
        this.writer.print("<th># Skipped</th>");
        this.writer.print("<th># Failed</th>");
        this.writer.print("<th>Time (ms)</th>");
        this.writer.print("<th>Included Groups</th>");
        this.writer.print("<th>Excluded Groups</th>");
        this.writer.println("</tr>");
        int n4 = 0;
        for (SuiteResult suiteResult : this.suiteResults) {
            this.writer.print("<tr><th colspan=\"7\">");
            this.writer.print(Utils.escapeHtml(suiteResult.getSuiteName()));
            this.writer.println("</th></tr>");
            for (TestResult testResult : suiteResult.getTestResults()) {
                int n5 = testResult.getPassedTestCount();
                int n6 = testResult.getSkippedTestCount();
                int n7 = testResult.getFailedTestCount();
                long l2 = testResult.getDuration();
                this.writer.print("<tr");
                if (n4 % 2 == 1) {
                    this.writer.print(" class=\"stripe\"");
                }
                this.writer.print(">");
                this.buffer.setLength(0);
                this.writeTableData(this.buffer.append("<a href=\"#t").append(n4).append("\">").append(Utils.escapeHtml(testResult.getTestName())).append("</a>").toString());
                this.writeTableData(numberFormat.format(n5), "num");
                this.writeTableData(numberFormat.format(n6), n6 > 0 ? "num attn" : "num");
                this.writeTableData(numberFormat.format(n7), n7 > 0 ? "num attn" : "num");
                this.writeTableData(numberFormat2.format(l2), "num");
                this.writeTableData(testResult.getIncludedGroups());
                this.writeTableData(testResult.getExcludedGroups());
                this.writer.println("</tr>");
                n += n5;
                n2 += n6;
                n3 += n7;
                l += l2;
                ++n4;
            }
        }
        if (n4 > 1) {
            this.writer.print("<tr>");
            this.writer.print("<th>Total</th>");
            this.writeTableHeader(numberFormat.format(n), "num");
            this.writeTableHeader(numberFormat.format(n2), n2 > 0 ? "num attn" : "num");
            this.writeTableHeader(numberFormat.format(n3), n3 > 0 ? "num attn" : "num");
            this.writeTableHeader(numberFormat2.format(l), "num");
            this.writer.print("<th colspan=\"2\"></th>");
            this.writer.println("</tr>");
        }
        this.writer.println("</table>");
    }

    protected void writeScenarioSummary() {
        this.writer.print("<table id='summary'>");
        this.writer.print("<thead>");
        this.writer.print("<tr>");
        this.writer.print("<th>Class</th>");
        this.writer.print("<th>Method</th>");
        this.writer.print("<th>Start</th>");
        this.writer.print("<th>Time (ms)</th>");
        this.writer.print("</tr>");
        this.writer.print("</thead>");
        int n = 0;
        int n2 = 0;
        for (SuiteResult suiteResult : this.suiteResults) {
            this.writer.print("<tbody><tr><th colspan=\"4\">");
            this.writer.print(Utils.escapeHtml(suiteResult.getSuiteName()));
            this.writer.print("</th></tr></tbody>");
            for (TestResult testResult : suiteResult.getTestResults()) {
                this.writer.printf("<tbody id=\"t%d\">", n);
                String string = Utils.escapeHtml(testResult.getTestName());
                int n3 = n2;
                n2 += this.writeScenarioSummary(string + " &#8212; failed (configuration methods)", testResult.getFailedConfigurationResults(), "failed", n2);
                n2 += this.writeScenarioSummary(string + " &#8212; failed", testResult.getFailedTestResults(), "failed", n2);
                n2 += this.writeScenarioSummary(string + " &#8212; skipped (configuration methods)", testResult.getSkippedConfigurationResults(), "skipped", n2);
                n2 += this.writeScenarioSummary(string + " &#8212; skipped", testResult.getSkippedTestResults(), "skipped", n2);
                n2 += this.writeScenarioSummary(string + " &#8212; passed", testResult.getPassedTestResults(), "passed", n2);
                if (n2 == n3) {
                    this.writer.print("<tr><th colspan=\"4\" class=\"invisible\"/></tr>");
                }
                this.writer.println("</tbody>");
                ++n;
            }
        }
        this.writer.println("</table>");
    }

    private int writeScenarioSummary(String string, List<ClassResult> list, String string2, int n) {
        int n2 = 0;
        if (!list.isEmpty()) {
            this.writer.print("<tr><th colspan=\"4\">");
            this.writer.print(string);
            this.writer.print("</th></tr>");
            int n3 = n;
            int n4 = 0;
            for (ClassResult classResult : list) {
                String string3 = string2 + (n4 % 2 == 0 ? "even" : "odd");
                this.buffer.setLength(0);
                int n5 = 0;
                int n6 = 0;
                for (MethodResult methodResult : classResult.getMethodResults()) {
                    List<ITestResult> list2 = methodResult.getResults();
                    int n7 = list2.size();
                    assert (n7 > 0);
                    ITestResult iTestResult = list2.iterator().next();
                    String string4 = Utils.escapeHtml(iTestResult.getMethod().getMethodName());
                    long l = iTestResult.getStartMillis();
                    long l2 = iTestResult.getEndMillis() - l;
                    if (n6 > 0) {
                        this.buffer.append("<tr class=\"").append(string3).append("\">");
                    }
                    this.buffer.append("<td><a href=\"#m").append(n3).append("\">").append(string4).append("</a></td>").append("<td rowspan=\"").append(n7).append("\">").append(l).append("</td>").append("<td rowspan=\"").append(n7).append("\">").append(l2).append("</td></tr>");
                    ++n3;
                    for (int i = 1; i < n7; ++i) {
                        this.buffer.append("<tr class=\"").append(string3).append("\">").append("<td><a href=\"#m").append(n3).append("\">").append(string4).append("</a></td></tr>");
                        ++n3;
                    }
                    n5 += n7;
                    ++n6;
                }
                this.writer.print("<tr class=\"");
                this.writer.print(string3);
                this.writer.print("\">");
                this.writer.print("<td rowspan=\"");
                this.writer.print(n5);
                this.writer.print("\">");
                this.writer.print(Utils.escapeHtml(classResult.getClassName()));
                this.writer.print("</td>");
                this.writer.print(this.buffer);
                ++n4;
            }
            n2 = n3 - n;
        }
        return n2;
    }

    protected void writeScenarioDetails() {
        int n = 0;
        for (SuiteResult suiteResult : this.suiteResults) {
            for (TestResult testResult : suiteResult.getTestResults()) {
                this.writer.print("<h2>");
                this.writer.print(Utils.escapeHtml(testResult.getTestName()));
                this.writer.print("</h2>");
                n += this.writeScenarioDetails(testResult.getFailedConfigurationResults(), n);
                n += this.writeScenarioDetails(testResult.getFailedTestResults(), n);
                n += this.writeScenarioDetails(testResult.getSkippedConfigurationResults(), n);
                n += this.writeScenarioDetails(testResult.getSkippedTestResults(), n);
                n += this.writeScenarioDetails(testResult.getPassedTestResults(), n);
            }
        }
    }

    private int writeScenarioDetails(List<ClassResult> list, int n) {
        int n2 = n;
        for (ClassResult classResult : list) {
            String string = classResult.getClassName();
            for (MethodResult methodResult : classResult.getMethodResults()) {
                List<ITestResult> list2 = methodResult.getResults();
                assert (!list2.isEmpty());
                String string2 = Utils.escapeHtml(string + "#" + list2.iterator().next().getMethod().getMethodName());
                for (ITestResult iTestResult : list2) {
                    this.writeScenario(n2, string2, iTestResult);
                    ++n2;
                }
            }
        }
        return n2 - n;
    }

    private void writeScenario(int n, String string, ITestResult iTestResult) {
        Throwable throwable;
        Object[] objectArray;
        int n2;
        this.writer.print("<h3 id=\"m");
        this.writer.print(n);
        this.writer.print("\">");
        this.writer.print(string);
        this.writer.print("</h3>");
        this.writer.print("<table class=\"result\">");
        boolean bl = false;
        Object[] objectArray2 = iTestResult.getParameters();
        int n3 = n2 = objectArray2 == null ? 0 : objectArray2.length;
        if (n2 > 0) {
            this.writer.print("<tr class=\"param\">");
            for (int i = 1; i <= n2; ++i) {
                this.writer.print("<th>Parameter #");
                this.writer.print(i);
                this.writer.print("</th>");
            }
            this.writer.print("</tr><tr class=\"param stripe\">");
            objectArray = objectArray2;
            int n4 = objectArray.length;
            for (int i = 0; i < n4; ++i) {
                Object object = objectArray[i];
                this.writer.print("<td>");
                this.writer.print(Utils.escapeHtml(Utils.toString(object)));
                this.writer.print("</td>");
            }
            this.writer.print("</tr>");
            bl = true;
        }
        if (!(objectArray = Reporter.getOutput(iTestResult)).isEmpty()) {
            this.writer.print("<tr><th");
            if (n2 > 1) {
                this.writer.printf(" colspan=\"%d\"", n2);
            }
            this.writer.print(">Messages</th></tr>");
            this.writer.print("<tr><td");
            if (n2 > 1) {
                this.writer.printf(" colspan=\"%d\"", n2);
            }
            this.writer.print(">");
            this.writeReporterMessages((List<String>)objectArray);
            this.writer.print("</td></tr>");
            bl = true;
        }
        if ((throwable = iTestResult.getThrowable()) != null) {
            this.writer.print("<tr><th");
            if (n2 > 1) {
                this.writer.printf(" colspan=\"%d\"", n2);
            }
            this.writer.print(">");
            this.writer.print(iTestResult.getStatus() == 1 ? "Expected Exception" : "Exception");
            this.writer.print("</th></tr>");
            this.writer.print("<tr><td");
            if (n2 > 1) {
                this.writer.printf(" colspan=\"%d\"", n2);
            }
            this.writer.print(">");
            this.writeStackTrace(throwable);
            this.writer.print("</td></tr>");
            bl = true;
        }
        if (!bl) {
            this.writer.print("<tr><th");
            if (n2 > 1) {
                this.writer.printf(" colspan=\"%d\"", n2);
            }
            this.writer.print(" class=\"invisible\"/></tr>");
        }
        this.writer.print("</table>");
        this.writer.println("<p class=\"totop\"><a href=\"#summary\">back to summary</a></p>");
    }

    protected void writeReporterMessages(List<String> list) {
        this.writer.print("<div class=\"messages\">");
        Iterator<String> iterator = list.iterator();
        assert (iterator.hasNext());
        if (Reporter.getEscapeHtml()) {
            this.writer.print(Utils.escapeHtml(iterator.next()));
        } else {
            this.writer.print(iterator.next());
        }
        while (iterator.hasNext()) {
            this.writer.print("<br/>");
            if (Reporter.getEscapeHtml()) {
                this.writer.print(Utils.escapeHtml(iterator.next()));
                continue;
            }
            this.writer.print(iterator.next());
        }
        this.writer.print("</div>");
    }

    protected void writeStackTrace(Throwable throwable) {
        this.writer.print("<div class=\"stacktrace\">");
        this.writer.print(Utils.shortStackTrace(throwable, true));
        this.writer.print("</div>");
    }

    protected void writeTableHeader(String string, String string2) {
        this.writeTag("th", string, string2);
    }

    protected void writeTableData(String string) {
        this.writeTableData(string, null);
    }

    protected void writeTableData(String string, String string2) {
        this.writeTag("td", string, string2);
    }

    protected void writeTag(String string, String string2, String string3) {
        this.writer.print("<");
        this.writer.print(string);
        if (string3 != null) {
            this.writer.print(" class=\"");
            this.writer.print(string3);
            this.writer.print("\"");
        }
        this.writer.print(">");
        this.writer.print(string2);
        this.writer.print("</");
        this.writer.print(string);
        this.writer.print(">");
    }

    protected static class MethodResult {
        private final List<ITestResult> results;

        public MethodResult(List<ITestResult> list) {
            this.results = list;
        }

        public List<ITestResult> getResults() {
            return this.results;
        }
    }

    protected static class ClassResult {
        private final String className;
        private final List<MethodResult> methodResults;

        public ClassResult(String string, List<MethodResult> list) {
            this.className = string;
            this.methodResults = list;
        }

        public String getClassName() {
            return this.className;
        }

        public List<MethodResult> getMethodResults() {
            return this.methodResults;
        }
    }

    protected static class TestResult {
        protected static final Comparator<ITestResult> RESULT_COMPARATOR = new Comparator<ITestResult>(){

            @Override
            public int compare(ITestResult iTestResult, ITestResult iTestResult2) {
                int n = iTestResult.getTestClass().getName().compareTo(iTestResult2.getTestClass().getName());
                if (n == 0) {
                    n = iTestResult.getMethod().getMethodName().compareTo(iTestResult2.getMethod().getMethodName());
                }
                return n;
            }
        };
        private final String testName;
        private final List<ClassResult> failedConfigurationResults;
        private final List<ClassResult> failedTestResults;
        private final List<ClassResult> skippedConfigurationResults;
        private final List<ClassResult> skippedTestResults;
        private final List<ClassResult> passedTestResults;
        private final int failedTestCount;
        private final int skippedTestCount;
        private final int passedTestCount;
        private final long duration;
        private final String includedGroups;
        private final String excludedGroups;

        public TestResult(ITestContext iTestContext) {
            this.testName = iTestContext.getName();
            Set<ITestResult> set = iTestContext.getFailedConfigurations().getAllResults();
            Set<ITestResult> set2 = iTestContext.getFailedTests().getAllResults();
            Set<ITestResult> set3 = iTestContext.getSkippedConfigurations().getAllResults();
            Set<ITestResult> set4 = iTestContext.getSkippedTests().getAllResults();
            Set<ITestResult> set5 = iTestContext.getPassedTests().getAllResults();
            this.failedConfigurationResults = this.groupResults(set);
            this.failedTestResults = this.groupResults(set2);
            this.skippedConfigurationResults = this.groupResults(set3);
            this.skippedTestResults = this.groupResults(set4);
            this.passedTestResults = this.groupResults(set5);
            this.failedTestCount = set2.size();
            this.skippedTestCount = set4.size();
            this.passedTestCount = set5.size();
            this.duration = iTestContext.getEndDate().getTime() - iTestContext.getStartDate().getTime();
            this.includedGroups = this.formatGroups(iTestContext.getIncludedGroups());
            this.excludedGroups = this.formatGroups(iTestContext.getExcludedGroups());
        }

        protected List<ClassResult> groupResults(Set<ITestResult> set) {
            List<ClassResult> list = Lists.newArrayList();
            if (!set.isEmpty()) {
                List<MethodResult> list2 = Lists.newArrayList();
                List<ITestResult> list3 = Lists.newArrayList();
                List<ITestResult> list4 = Lists.newArrayList(set);
                Collections.sort(list4, RESULT_COMPARATOR);
                Iterator<ITestResult> iterator = list4.iterator();
                assert (iterator.hasNext());
                ITestResult iTestResult = iterator.next();
                list3.add(iTestResult);
                String string = iTestResult.getTestClass().getName();
                String string2 = iTestResult.getMethod().getMethodName();
                while (iterator.hasNext()) {
                    iTestResult = iterator.next();
                    String string3 = iTestResult.getTestClass().getName();
                    if (!string.equals(string3)) {
                        assert (!list3.isEmpty());
                        list2.add(new MethodResult(list3));
                        list3 = Lists.newArrayList();
                        assert (!list2.isEmpty());
                        list.add(new ClassResult(string, list2));
                        list2 = Lists.newArrayList();
                        string = string3;
                        string2 = iTestResult.getMethod().getMethodName();
                    } else {
                        String string4 = iTestResult.getMethod().getMethodName();
                        if (!string2.equals(string4)) {
                            assert (!list3.isEmpty());
                            list2.add(new MethodResult(list3));
                            list3 = Lists.newArrayList();
                            string2 = string4;
                        }
                    }
                    list3.add(iTestResult);
                }
                assert (!list3.isEmpty());
                list2.add(new MethodResult(list3));
                assert (!list2.isEmpty());
                list.add(new ClassResult(string, list2));
            }
            return list;
        }

        public String getTestName() {
            return this.testName;
        }

        public List<ClassResult> getFailedConfigurationResults() {
            return this.failedConfigurationResults;
        }

        public List<ClassResult> getFailedTestResults() {
            return this.failedTestResults;
        }

        public List<ClassResult> getSkippedConfigurationResults() {
            return this.skippedConfigurationResults;
        }

        public List<ClassResult> getSkippedTestResults() {
            return this.skippedTestResults;
        }

        public List<ClassResult> getPassedTestResults() {
            return this.passedTestResults;
        }

        public int getFailedTestCount() {
            return this.failedTestCount;
        }

        public int getSkippedTestCount() {
            return this.skippedTestCount;
        }

        public int getPassedTestCount() {
            return this.passedTestCount;
        }

        public long getDuration() {
            return this.duration;
        }

        public String getIncludedGroups() {
            return this.includedGroups;
        }

        public String getExcludedGroups() {
            return this.excludedGroups;
        }

        protected String formatGroups(String[] stringArray) {
            if (stringArray.length == 0) {
                return "";
            }
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(stringArray[0]);
            for (int i = 1; i < stringArray.length; ++i) {
                stringBuilder.append(", ").append(stringArray[i]);
            }
            return stringBuilder.toString();
        }
    }

    protected static class SuiteResult {
        private final String suiteName;
        private final List<TestResult> testResults = Lists.newArrayList();

        public SuiteResult(ISuite iSuite) {
            this.suiteName = iSuite.getName();
            for (ISuiteResult iSuiteResult : iSuite.getResults().values()) {
                this.testResults.add(new TestResult(iSuiteResult.getTestContext()));
            }
        }

        public String getSuiteName() {
            return this.suiteName;
        }

        public List<TestResult> getTestResults() {
            return this.testResults;
        }
    }
}

