/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.plugins.circular;

import java.util.HashSet;
import java.util.List;
import org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.apache.ivy.core.module.id.ModuleRevisionId;

public final class CircularDependencyHelper {
    private CircularDependencyHelper() {
    }

    public static String formatMessage(ModuleRevisionId[] mrids) {
        HashSet<ModuleRevisionId> alreadyAdded = new HashSet<ModuleRevisionId>();
        StringBuffer buff = new StringBuffer();
        buff.append(mrids[0]);
        alreadyAdded.add(mrids[0]);
        for (int i = 1; i < mrids.length; ++i) {
            buff.append("->");
            if (!alreadyAdded.add(mrids[i])) {
                buff.append("...");
                break;
            }
            buff.append(mrids[i]);
        }
        return buff.toString();
    }

    public static String formatMessage(ModuleDescriptor[] descriptors) {
        return CircularDependencyHelper.formatMessage(CircularDependencyHelper.toMrids(descriptors));
    }

    public static String formatMessageFromDescriptors(List loopElements) {
        ModuleRevisionId[] mrids = new ModuleRevisionId[loopElements.size()];
        int pos = 0;
        for (ModuleDescriptor descriptor : loopElements) {
            mrids[pos] = descriptor.getModuleRevisionId();
            ++pos;
        }
        return CircularDependencyHelper.formatMessage(mrids);
    }

    public static ModuleRevisionId[] toMrids(ModuleDescriptor[] descriptors) {
        ModuleRevisionId[] mrids = new ModuleRevisionId[descriptors.length];
        for (int i = 0; i < descriptors.length; ++i) {
            mrids[i] = descriptors[i].getModuleRevisionId();
        }
        return mrids;
    }
}

