/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeHighlighting.MainHighlightingPassFactory;
import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.codeHighlighting.TextEditorHighlightingPassFactory;
import com.intellij.codeHighlighting.TextEditorHighlightingPassFactoryRegistrar;
import com.intellij.codeHighlighting.TextEditorHighlightingPassRegistrar;
import com.intellij.codeInsight.daemon.impl.DefaultHighlightInfoProcessor;
import com.intellij.codeInsight.daemon.impl.FileStatusMap;
import com.intellij.codeInsight.daemon.impl.HighlightInfoProcessor;
import com.intellij.codeInsight.daemon.impl.LocalInspectionsPass;
import com.intellij.codeInsight.daemon.impl.ProgressableTextEditorHighlightingPass;
import com.intellij.codeInsight.daemon.impl.TextEditorHighlightingPassRegistrarImpl;
import com.intellij.codeInsight.daemon.impl.VisibleHighlightingPassFactory;
import com.intellij.codeInspection.ex.LocalInspectionToolWrapper;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ProperTextRange;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtilCore;
import org.jetbrains.annotations.NotNull;

public final class LocalInspectionsPassFactory
implements MainHighlightingPassFactory,
TextEditorHighlightingPassFactoryRegistrar {
    private static final Logger LOG = Logger.getInstance(LocalInspectionsPassFactory.class);

    @Override
    public void registerHighlightingPassFactory(@NotNull TextEditorHighlightingPassRegistrar registrar, @NotNull Project project) {
        if (registrar == null) {
            LocalInspectionsPassFactory.$$$reportNull$$$0(0);
        }
        if (project == null) {
            LocalInspectionsPassFactory.$$$reportNull$$$0(1);
        }
        int[] ghp = new int[]{4};
        boolean serializeCodeInsightPasses = ((TextEditorHighlightingPassRegistrarImpl)registrar).isSerializeCodeInsightPasses();
        registrar.registerTextEditorHighlightingPass((TextEditorHighlightingPassFactory)this, (int[])(serializeCodeInsightPasses ? ghp : null), serializeCodeInsightPasses ? null : ghp, true, 7);
    }

    @Override
    @NotNull
    public TextEditorHighlightingPass createHighlightingPass(@NotNull PsiFile file2, @NotNull Editor editor) {
        TextRange textRange;
        if (file2 == null) {
            LocalInspectionsPassFactory.$$$reportNull$$$0(2);
        }
        if (editor == null) {
            LocalInspectionsPassFactory.$$$reportNull$$$0(3);
        }
        if ((textRange = FileStatusMap.getDirtyTextRange(editor, 7)) == null) {
            return new ProgressableTextEditorHighlightingPass.EmptyPass(file2.getProject(), editor.getDocument());
        }
        ProperTextRange visibleRange = VisibleHighlightingPassFactory.calculateVisibleRange(editor);
        return new MyLocalInspectionsPass(file2, editor.getDocument(), textRange, (TextRange)visibleRange, new DefaultHighlightInfoProcessor());
    }

    @Override
    public TextEditorHighlightingPass createMainHighlightingPass(@NotNull PsiFile file2, @NotNull Document document, @NotNull HighlightInfoProcessor highlightInfoProcessor) {
        TextRange textRange;
        if (file2 == null) {
            LocalInspectionsPassFactory.$$$reportNull$$$0(4);
        }
        if (document == null) {
            LocalInspectionsPassFactory.$$$reportNull$$$0(5);
        }
        if (highlightInfoProcessor == null) {
            LocalInspectionsPassFactory.$$$reportNull$$$0(6);
        }
        LOG.assertTrue((textRange = file2.getTextRange()) != null, (Object)("textRange is null for " + file2 + " (" + PsiUtilCore.getVirtualFile((PsiElement)file2) + ")"));
        return new MyLocalInspectionsPass(file2, document, textRange, LocalInspectionsPass.EMPTY_PRIORITY_RANGE, highlightInfoProcessor);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "registrar";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "highlightInfoProcessor";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/daemon/impl/LocalInspectionsPassFactory";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "registerHighlightingPassFactory";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "createHighlightingPass";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "createMainHighlightingPass";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class MyLocalInspectionsPass
    extends LocalInspectionsPass {
        private MyLocalInspectionsPass(@NotNull PsiFile file2, @NotNull Document document, @NotNull TextRange textRange, @NotNull TextRange visibleRange, @NotNull HighlightInfoProcessor highlightInfoProcessor) {
            if (file2 == null) {
                MyLocalInspectionsPass.$$$reportNull$$$0(0);
            }
            if (document == null) {
                MyLocalInspectionsPass.$$$reportNull$$$0(1);
            }
            if (textRange == null) {
                MyLocalInspectionsPass.$$$reportNull$$$0(2);
            }
            if (visibleRange == null) {
                MyLocalInspectionsPass.$$$reportNull$$$0(3);
            }
            if (highlightInfoProcessor == null) {
                MyLocalInspectionsPass.$$$reportNull$$$0(4);
            }
            super(file2, document, textRange.getStartOffset(), textRange.getEndOffset(), visibleRange, true, highlightInfoProcessor, true);
        }

        @Override
        protected boolean isAcceptableLocalTool(@NotNull LocalInspectionToolWrapper wrapper2) {
            if (wrapper2 == null) {
                MyLocalInspectionsPass.$$$reportNull$$$0(5);
            }
            return !wrapper2.runForWholeFile();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "document";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "textRange";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "visibleRange";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "highlightInfoProcessor";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "wrapper";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/codeInsight/daemon/impl/LocalInspectionsPassFactory$MyLocalInspectionsPass";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isAcceptableLocalTool";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

