/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.lookup;

import com.intellij.codeInsight.lookup.Lookup;
import com.intellij.codeInsight.lookup.LookupArranger;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupEx;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import java.beans.PropertyChangeListener;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class LookupManager {
    @NonNls
    public static final String PROP_ACTIVE_LOOKUP = "activeLookup";

    public static LookupManager getInstance(@NotNull Project project) {
        if (project == null) {
            LookupManager.$$$reportNull$$$0(0);
        }
        return (LookupManager)ServiceManager.getService((Project)project, LookupManager.class);
    }

    @Nullable
    public static LookupEx getActiveLookup(@Nullable Editor editor) {
        if (editor == null) {
            return null;
        }
        Project project = editor.getProject();
        if (project == null || project.isDisposed()) {
            return null;
        }
        LookupEx lookup2 = LookupManager.getInstance(project).getActiveLookup();
        if (lookup2 == null) {
            return null;
        }
        return lookup2.getTopLevelEditor() == InjectedLanguageUtil.getTopLevelEditor(editor) ? lookup2 : null;
    }

    @Nullable
    public LookupEx showLookup(@NotNull Editor editor, LookupElement ... items) {
        if (editor == null) {
            LookupManager.$$$reportNull$$$0(1);
        }
        if (items == null) {
            LookupManager.$$$reportNull$$$0(2);
        }
        return this.showLookup(editor, items, "", new LookupArranger.DefaultArranger());
    }

    @Nullable
    public LookupEx showLookup(@NotNull Editor editor, LookupElement @NotNull [] items, @NotNull String prefix) {
        if (editor == null) {
            LookupManager.$$$reportNull$$$0(3);
        }
        if (prefix == null) {
            LookupManager.$$$reportNull$$$0(4);
        }
        if (items == null) {
            LookupManager.$$$reportNull$$$0(5);
        }
        return this.showLookup(editor, items, prefix, new LookupArranger.DefaultArranger());
    }

    @Nullable
    public abstract LookupEx showLookup(@NotNull Editor var1, LookupElement @NotNull [] var2, @NotNull String var3, @NotNull LookupArranger var4);

    public abstract void hideActiveLookup();

    public static void hideActiveLookup(@NotNull Project project) {
        LookupManager lookupManager;
        if (project == null) {
            LookupManager.$$$reportNull$$$0(6);
        }
        if ((lookupManager = (LookupManager)project.getServiceIfCreated(LookupManager.class)) != null) {
            lookupManager.hideActiveLookup();
        }
    }

    @Nullable
    public abstract LookupEx getActiveLookup();

    @Deprecated
    public abstract void addPropertyChangeListener(@NotNull PropertyChangeListener var1);

    @Deprecated
    public abstract void addPropertyChangeListener(@NotNull PropertyChangeListener var1, @NotNull Disposable var2);

    @Deprecated
    public abstract void removePropertyChangeListener(@NotNull PropertyChangeListener var1);

    @NotNull
    public abstract Lookup createLookup(@NotNull Editor var1, LookupElement @NotNull [] var2, @NotNull String var3, @NotNull LookupArranger var4);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "items";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/lookup/LookupManager";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getInstance";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "showLookup";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "hideActiveLookup";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

