/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic;

import com.google.gson.stream.JsonReader;
import com.intellij.diagnostic.hprof.action.AnalysisRunnable;
import com.intellij.diagnostic.report.HeapReportProperties;
import com.intellij.diagnostic.report.MemoryReportReason;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.openapi.util.io.FileUtil;
import java.io.Closeable;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/intellij/diagnostic/AnalyzePendingSnapshotActivity;", "Lcom/intellij/openapi/startup/StartupActivity$DumbAware;", "()V", "runActivity", "", "project", "Lcom/intellij/openapi/project/Project;", "intellij.platform.ide.impl"})
public final class AnalyzePendingSnapshotActivity
implements StartupActivity.DumbAware {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runActivity(@NotNull Project project) {
        block23: {
            String string;
            boolean bl;
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Application application = ApplicationManager.getApplication();
            Intrinsics.checkExpressionValueIsNotNull((Object)application, (String)"ApplicationManager.getApplication()");
            if (application.isUnitTestMode()) {
                return;
            }
            Path jsonPath = Paths.get(PathManager.getSystemPath(), "pending-snapshot.json");
            if (!Files.isRegularFile(jsonPath, new LinkOption[0])) {
                return;
            }
            String path = null;
            String liveStats = null;
            MemoryReportReason reason = null;
            try {
                JsonReader reader = new JsonReader((Reader)Files.newBufferedReader(jsonPath));
                Closeable closeable = (Closeable)reader;
                bl = false;
                Throwable throwable = null;
                try {
                    JsonReader it = (JsonReader)closeable;
                    boolean bl2 = false;
                    it.beginObject();
                    while (it.hasNext()) {
                        String string2;
                        if (it.nextName() == null) continue;
                        int n = -1;
                        switch (string2.hashCode()) {
                            case 3433509: {
                                if (!string2.equals("path")) break;
                                n = 1;
                                break;
                            }
                            case -934964668: {
                                if (!string2.equals("reason")) break;
                                n = 2;
                                break;
                            }
                            case 997906195: {
                                if (!string2.equals("liveStats")) break;
                                n = 3;
                                break;
                            }
                        }
                        switch (n) {
                            case 1: {
                                path = it.nextString();
                                break;
                            }
                            case 2: {
                                String string3 = it.nextString();
                                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"it.nextString()");
                                reason = MemoryReportReason.valueOf(string3);
                                break;
                            }
                            case 3: {
                                liveStats = it.nextString();
                            }
                        }
                    }
                    it.endObject();
                    it = Unit.INSTANCE;
                }
                catch (Throwable it) {
                    throwable = it;
                    throw it;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
                FileUtil.delete((Path)jsonPath);
            }
            catch (Exception exception) {
                // empty catch block
            }
            String string4 = path;
            if (string4 == null) break block23;
            String string5 = string4;
            boolean bl3 = false;
            bl = false;
            String it = string5;
            boolean bl4 = false;
            MemoryReportReason memoryReportReason = reason;
            if (memoryReportReason == null) {
                memoryReportReason = MemoryReportReason.None;
            }
            if ((string = liveStats) == null) {
                string = "";
            }
            HeapReportProperties heapProperties = new HeapReportProperties(memoryReportReason, string);
            Path path2 = Paths.get(it, new String[0]);
            Intrinsics.checkExpressionValueIsNotNull((Object)path2, (String)"Paths.get(it)");
            new AnalysisRunnable(path2, heapProperties, true).run();
        }
    }
}

