/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework.sm;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.Location;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.testframework.TestConsoleProperties;
import com.intellij.execution.testframework.sm.FileUrlProvider;
import com.intellij.execution.testframework.sm.SMCustomMessagesParsing;
import com.intellij.execution.testframework.sm.runner.GeneralIdBasedToSMTRunnerEventsConvertor;
import com.intellij.execution.testframework.sm.runner.GeneralTestEventsProcessor;
import com.intellij.execution.testframework.sm.runner.GeneralToSMTRunnerEventsConvertor;
import com.intellij.execution.testframework.sm.runner.OutputToGeneralTestEventsConverter;
import com.intellij.execution.testframework.sm.runner.SMTRunnerConsoleProperties;
import com.intellij.execution.testframework.sm.runner.SMTestLocator;
import com.intellij.execution.testframework.sm.runner.TestProxyFilterProvider;
import com.intellij.execution.testframework.sm.runner.TestProxyPrinterProvider;
import com.intellij.execution.testframework.sm.runner.ui.AttachToProcessListener;
import com.intellij.execution.testframework.sm.runner.ui.SMTRunnerConsoleView;
import com.intellij.execution.testframework.sm.runner.ui.SMTRunnerUIActionsHandler;
import com.intellij.execution.testframework.sm.runner.ui.SMTestRunnerResultsForm;
import com.intellij.execution.testframework.ui.BaseTestsOutputConsoleView;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.testIntegration.TestLocationProvider;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SMTestRunnerConnectionUtil {
    private static final String TEST_RUNNER_DEBUG_MODE_PROPERTY = "idea.smrunner.debug";

    private SMTestRunnerConnectionUtil() {
    }

    @NotNull
    public static BaseTestsOutputConsoleView createAndAttachConsole(@NotNull String testFrameworkName, @NotNull ProcessHandler processHandler2, @NotNull TestConsoleProperties consoleProperties) throws ExecutionException {
        if (testFrameworkName == null) {
            SMTestRunnerConnectionUtil.$$$reportNull$$$0(0);
        }
        if (processHandler2 == null) {
            SMTestRunnerConnectionUtil.$$$reportNull$$$0(1);
        }
        if (consoleProperties == null) {
            SMTestRunnerConnectionUtil.$$$reportNull$$$0(2);
        }
        BaseTestsOutputConsoleView console = SMTestRunnerConnectionUtil.createConsole(testFrameworkName, consoleProperties);
        console.attachToProcess(processHandler2);
        BaseTestsOutputConsoleView baseTestsOutputConsoleView = console;
        if (baseTestsOutputConsoleView == null) {
            SMTestRunnerConnectionUtil.$$$reportNull$$$0(3);
        }
        return baseTestsOutputConsoleView;
    }

    @NotNull
    public static BaseTestsOutputConsoleView createConsole(@NotNull String testFrameworkName, @NotNull TestConsoleProperties consoleProperties) {
        if (testFrameworkName == null) {
            SMTestRunnerConnectionUtil.$$$reportNull$$$0(4);
        }
        if (consoleProperties == null) {
            SMTestRunnerConnectionUtil.$$$reportNull$$$0(5);
        }
        String splitterPropertyName = SMTestRunnerConnectionUtil.getSplitterPropertyName(testFrameworkName);
        SMTRunnerConsoleView consoleView = new SMTRunnerConsoleView(consoleProperties, splitterPropertyName);
        SMTestRunnerConnectionUtil.initConsoleView(consoleView, testFrameworkName);
        SMTRunnerConsoleView sMTRunnerConsoleView = consoleView;
        if (sMTRunnerConsoleView == null) {
            SMTestRunnerConnectionUtil.$$$reportNull$$$0(6);
        }
        return sMTRunnerConsoleView;
    }

    @NotNull
    public static SMTRunnerConsoleView createConsole(@NotNull SMTRunnerConsoleProperties consoleProperties) {
        if (consoleProperties == null) {
            SMTestRunnerConnectionUtil.$$$reportNull$$$0(7);
        }
        return (SMTRunnerConsoleView)SMTestRunnerConnectionUtil.createConsole(consoleProperties.getTestFrameworkName(), consoleProperties);
    }

    @NotNull
    public static String getSplitterPropertyName(@NotNull String testFrameworkName) {
        if (testFrameworkName == null) {
            SMTestRunnerConnectionUtil.$$$reportNull$$$0(8);
        }
        String string = testFrameworkName + ".Splitter.Proportion";
        if (string == null) {
            SMTestRunnerConnectionUtil.$$$reportNull$$$0(9);
        }
        return string;
    }

    public static void initConsoleView(final @NotNull SMTRunnerConsoleView consoleView, final @NotNull String testFrameworkName) {
        if (consoleView == null) {
            SMTestRunnerConnectionUtil.$$$reportNull$$$0(10);
        }
        if (testFrameworkName == null) {
            SMTestRunnerConnectionUtil.$$$reportNull$$$0(11);
        }
        consoleView.addAttachToProcessListener(new AttachToProcessListener(){

            @Override
            public void onAttachToProcess(@NotNull ProcessHandler processHandler2) {
                SMTestLocator customLocator;
                TestProxyFilterProvider filterProvider;
                if (processHandler2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                TestConsoleProperties properties = consoleView.getProperties();
                TestProxyPrinterProvider printerProvider = null;
                if (properties instanceof SMTRunnerConsoleProperties && (filterProvider = ((SMTRunnerConsoleProperties)properties).getFilterProvider()) != null) {
                    printerProvider = new TestProxyPrinterProvider(consoleView, filterProvider);
                }
                SMTestLocator testLocator = FileUrlProvider.INSTANCE;
                if (properties instanceof SMTRunnerConsoleProperties && (customLocator = ((SMTRunnerConsoleProperties)properties).getTestLocator()) != null) {
                    testLocator = new CombinedTestLocator(customLocator);
                }
                boolean idBasedTestTree = false;
                if (properties instanceof SMTRunnerConsoleProperties) {
                    idBasedTestTree = ((SMTRunnerConsoleProperties)properties).isIdBasedTestTree();
                }
                SMTestRunnerResultsForm resultsForm = consoleView.getResultsViewer();
                resultsForm.getTestsRootNode().setHandler(processHandler2);
                SMTestRunnerConnectionUtil.attachEventsProcessors(properties, resultsForm, processHandler2, testFrameworkName, testLocator, idBasedTestTree, printerProvider);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processHandler", "com/intellij/execution/testframework/sm/SMTestRunnerConnectionUtil$1", "onAttachToProcess"));
            }
        });
        consoleView.setHelpId("reference.runToolWindow.testResultsTab");
        consoleView.initUI();
    }

    public static boolean isInDebugMode() {
        return Boolean.valueOf(System.getProperty(TEST_RUNNER_DEBUG_MODE_PROPERTY));
    }

    private static void attachEventsProcessors(TestConsoleProperties consoleProperties, SMTestRunnerResultsForm resultsViewer, ProcessHandler processHandler2, String testFrameworkName, @Nullable SMTestLocator locator, boolean idBasedTestTree, @Nullable TestProxyPrinterProvider printerProvider) {
        final OutputToGeneralTestEventsConverter outputConsumer = consoleProperties instanceof SMCustomMessagesParsing ? ((SMCustomMessagesParsing)((Object)consoleProperties)).createTestEventsConverter(testFrameworkName, consoleProperties) : new OutputToGeneralTestEventsConverter(testFrameworkName, consoleProperties);
        SMTRunnerUIActionsHandler uiActionsHandler = new SMTRunnerUIActionsHandler(consoleProperties);
        resultsViewer.addEventsListener(uiActionsHandler);
        outputConsumer.setTestingStartedHandler(() -> {
            GeneralTestEventsProcessor eventsProcessor = idBasedTestTree ? new GeneralIdBasedToSMTRunnerEventsConvertor(consoleProperties.getProject(), resultsViewer.getTestsRootNode(), testFrameworkName) : new GeneralToSMTRunnerEventsConvertor(consoleProperties.getProject(), resultsViewer.getTestsRootNode(), testFrameworkName);
            if (locator != null) {
                eventsProcessor.setLocator(locator);
            }
            if (printerProvider != null) {
                eventsProcessor.setPrinterProvider(printerProvider);
            }
            eventsProcessor.addEventsListener(resultsViewer);
            outputConsumer.setProcessor(eventsProcessor);
        });
        outputConsumer.startTesting();
        processHandler2.addProcessListener((ProcessListener)new ProcessAdapter(){

            public void processTerminated(@NotNull ProcessEvent event) {
                if (event == null) {
                    2.$$$reportNull$$$0(0);
                }
                outputConsumer.flushBufferOnProcessTermination(event.getExitCode());
                outputConsumer.finishTesting();
                Disposer.dispose((Disposable)outputConsumer);
            }

            public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key outputType) {
                if (event == null) {
                    2.$$$reportNull$$$0(1);
                }
                if (outputType == null) {
                    2.$$$reportNull$$$0(2);
                }
                outputConsumer.process(event.getText(), outputType);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "event";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "outputType";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/execution/testframework/sm/SMTestRunnerConnectionUtil$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "processTerminated";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onTextAvailable";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.1")
    public static SMTRunnerConsoleView createConsoleWithCustomLocator(final @NotNull String testFrameworkName, @NotNull TestConsoleProperties consoleProperties, ExecutionEnvironment environment, final @Nullable TestLocationProvider locator, final boolean idBasedTreeConstruction, final @Nullable TestProxyFilterProvider filterProvider) {
        if (testFrameworkName == null) {
            SMTestRunnerConnectionUtil.$$$reportNull$$$0(12);
        }
        if (consoleProperties == null) {
            SMTestRunnerConnectionUtil.$$$reportNull$$$0(13);
        }
        String splitterPropertyName = SMTestRunnerConnectionUtil.getSplitterPropertyName(testFrameworkName);
        final SMTRunnerConsoleView consoleView = new SMTRunnerConsoleView(consoleProperties, splitterPropertyName);
        consoleView.addAttachToProcessListener(new AttachToProcessListener(){

            @Override
            public void onAttachToProcess(@NotNull ProcessHandler processHandler2) {
                if (processHandler2 == null) {
                    3.$$$reportNull$$$0(0);
                }
                TestConsoleProperties properties = consoleView.getProperties();
                CompositeTestLocationProvider testLocator = new CompositeTestLocationProvider(locator);
                TestProxyPrinterProvider printerProvider = null;
                if (filterProvider != null) {
                    printerProvider = new TestProxyPrinterProvider(consoleView, filterProvider);
                }
                SMTestRunnerResultsForm resultsForm = consoleView.getResultsViewer();
                SMTestRunnerConnectionUtil.attachEventsProcessors(properties, resultsForm, processHandler2, testFrameworkName, testLocator, idBasedTreeConstruction, printerProvider);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processHandler", "com/intellij/execution/testframework/sm/SMTestRunnerConnectionUtil$3", "onAttachToProcess"));
            }
        });
        consoleView.setHelpId("reference.runToolWindow.testResultsTab");
        consoleView.initUI();
        return consoleView;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 6: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 6: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testFrameworkName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processHandler";
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consoleProperties";
                break;
            }
            case 3: 
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/testframework/sm/SMTestRunnerConnectionUtil";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consoleView";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/testframework/sm/SMTestRunnerConnectionUtil";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createAndAttachConsole";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createConsole";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getSplitterPropertyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createAndAttachConsole";
                break;
            }
            case 3: 
            case 6: 
            case 9: {
                break;
            }
            case 4: 
            case 5: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createConsole";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getSplitterPropertyName";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "initConsoleView";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createConsoleWithCustomLocator";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 6: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    private static class CompositeTestLocationProvider
    implements SMTestLocator {
        private final TestLocationProvider myPrimaryLocator;

        private CompositeTestLocationProvider(@Nullable TestLocationProvider primaryLocator) {
            this.myPrimaryLocator = primaryLocator;
        }

        @Override
        @NotNull
        public List<Location> getLocation(@NotNull String protocol, @NotNull String path, @NotNull Project project, @NotNull GlobalSearchScope scope) {
            List<Location> locations;
            if (protocol == null) {
                CompositeTestLocationProvider.$$$reportNull$$$0(0);
            }
            if (path == null) {
                CompositeTestLocationProvider.$$$reportNull$$$0(1);
            }
            if (project == null) {
                CompositeTestLocationProvider.$$$reportNull$$$0(2);
            }
            if (scope == null) {
                CompositeTestLocationProvider.$$$reportNull$$$0(3);
            }
            boolean isDumbMode = DumbService.isDumb((Project)project);
            if (!(this.myPrimaryLocator == null || isDumbMode && !DumbService.isDumbAware((Object)this.myPrimaryLocator) || (locations = this.myPrimaryLocator.getLocation(protocol, path, project)).isEmpty())) {
                List<Location> list2 = locations;
                if (list2 == null) {
                    CompositeTestLocationProvider.$$$reportNull$$$0(4);
                }
                return list2;
            }
            if ("file".equals(protocol) && !(locations = FileUrlProvider.INSTANCE.getLocation(protocol, path, project, scope)).isEmpty()) {
                List<Location> list3 = locations;
                if (list3 == null) {
                    CompositeTestLocationProvider.$$$reportNull$$$0(5);
                }
                return list3;
            }
            for (TestLocationProvider provider : TestLocationProvider.EP_NAME.getExtensionList()) {
                List<Location> locations2;
                if (isDumbMode && !DumbService.isDumbAware((Object)provider) || (locations2 = provider.getLocation(protocol, path, project)).isEmpty()) continue;
                List<Location> list4 = locations2;
                if (list4 == null) {
                    CompositeTestLocationProvider.$$$reportNull$$$0(6);
                }
                return list4;
            }
            List<Location> list5 = Collections.emptyList();
            if (list5 == null) {
                CompositeTestLocationProvider.$$$reportNull$$$0(7);
            }
            return list5;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "protocol";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "path";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "scope";
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/execution/testframework/sm/SMTestRunnerConnectionUtil$CompositeTestLocationProvider";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/execution/testframework/sm/SMTestRunnerConnectionUtil$CompositeTestLocationProvider";
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getLocation";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getLocation";
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class CombinedTestLocator
    implements SMTestLocator,
    DumbAware {
        private final SMTestLocator myLocator;

        CombinedTestLocator(SMTestLocator locator) {
            this.myLocator = locator;
        }

        @Override
        @NotNull
        public List<Location> getLocation(@NotNull String protocol, @NotNull String path, @NotNull Project project, @NotNull GlobalSearchScope scope) {
            if (protocol == null) {
                CombinedTestLocator.$$$reportNull$$$0(0);
            }
            if (path == null) {
                CombinedTestLocator.$$$reportNull$$$0(1);
            }
            if (project == null) {
                CombinedTestLocator.$$$reportNull$$$0(2);
            }
            if (scope == null) {
                CombinedTestLocator.$$$reportNull$$$0(3);
            }
            List<Location> list2 = this.getLocation(protocol, path, null, project, scope);
            if (list2 == null) {
                CombinedTestLocator.$$$reportNull$$$0(4);
            }
            return list2;
        }

        @Override
        @NotNull
        public List<Location> getLocation(@NotNull String protocol, @NotNull String path, @Nullable String metainfo, @NotNull Project project, @NotNull GlobalSearchScope scope) {
            if (protocol == null) {
                CombinedTestLocator.$$$reportNull$$$0(5);
            }
            if (path == null) {
                CombinedTestLocator.$$$reportNull$$$0(6);
            }
            if (project == null) {
                CombinedTestLocator.$$$reportNull$$$0(7);
            }
            if (scope == null) {
                CombinedTestLocator.$$$reportNull$$$0(8);
            }
            if ("file".equals(protocol)) {
                List<Location> list2 = FileUrlProvider.INSTANCE.getLocation(protocol, path, project, scope);
                if (list2 == null) {
                    CombinedTestLocator.$$$reportNull$$$0(9);
                }
                return list2;
            }
            if (!DumbService.isDumb((Project)project) || DumbService.isDumbAware((Object)this.myLocator)) {
                List<Location> list3 = this.myLocator.getLocation(protocol, path, metainfo, project, scope);
                if (list3 == null) {
                    CombinedTestLocator.$$$reportNull$$$0(10);
                }
                return list3;
            }
            List<Location> list4 = Collections.emptyList();
            if (list4 == null) {
                CombinedTestLocator.$$$reportNull$$$0(11);
            }
            return list4;
        }

        @Override
        @NotNull
        public List<Location> getLocation(@NotNull String stacktraceLine, @NotNull Project project, @NotNull GlobalSearchScope scope) {
            if (stacktraceLine == null) {
                CombinedTestLocator.$$$reportNull$$$0(12);
            }
            if (project == null) {
                CombinedTestLocator.$$$reportNull$$$0(13);
            }
            if (scope == null) {
                CombinedTestLocator.$$$reportNull$$$0(14);
            }
            List<Location> list2 = this.myLocator.getLocation(stacktraceLine, project, scope);
            if (list2 == null) {
                CombinedTestLocator.$$$reportNull$$$0(15);
            }
            return list2;
        }

        @Override
        @NotNull
        public ModificationTracker getLocationCacheModificationTracker(@NotNull Project project) {
            if (project == null) {
                CombinedTestLocator.$$$reportNull$$$0(16);
            }
            ModificationTracker modificationTracker = this.myLocator.getLocationCacheModificationTracker(project);
            if (modificationTracker == null) {
                CombinedTestLocator.$$$reportNull$$$0(17);
            }
            return modificationTracker;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: 
                case 9: 
                case 10: 
                case 11: 
                case 15: 
                case 17: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: 
                case 9: 
                case 10: 
                case 11: 
                case 15: 
                case 17: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "protocol";
                    break;
                }
                case 1: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "path";
                    break;
                }
                case 2: 
                case 7: 
                case 13: 
                case 16: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: 
                case 8: 
                case 14: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "scope";
                    break;
                }
                case 4: 
                case 9: 
                case 10: 
                case 11: 
                case 15: 
                case 17: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/execution/testframework/sm/SMTestRunnerConnectionUtil$CombinedTestLocator";
                    break;
                }
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "stacktraceLine";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/execution/testframework/sm/SMTestRunnerConnectionUtil$CombinedTestLocator";
                    break;
                }
                case 4: 
                case 9: 
                case 10: 
                case 11: 
                case 15: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getLocation";
                    break;
                }
                case 17: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getLocationCacheModificationTracker";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getLocation";
                    break;
                }
                case 4: 
                case 9: 
                case 10: 
                case 11: 
                case 15: 
                case 17: {
                    break;
                }
                case 16: {
                    objectArray = objectArray;
                    objectArray[2] = "getLocationCacheModificationTracker";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: 
                case 9: 
                case 10: 
                case 11: 
                case 15: 
                case 17: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

