/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.intellij.ide.AppLifecycleListener;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginEnabler;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.ProjectPluginTracker;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.util.messages.MessageBusConnection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Service
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000eR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R \u0010\u0005\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/ide/plugins/ProjectPluginTracker;", "", "()V", "applicationShuttingDown", "", "projectPluginReferences", "", "Lcom/intellij/openapi/project/Project;", "", "Lcom/intellij/openapi/extensions/PluginId;", "registerProjectPlugin", "", "project", "plugin", "Lcom/intellij/ide/plugins/IdeaPluginDescriptor;", "Companion", "intellij.platform.ide.impl"})
public final class ProjectPluginTracker {
    private final Map<Project, Set<PluginId>> projectPluginReferences;
    private boolean applicationShuttingDown;
    @NotNull
    private static final Logger LOG;
    public static final Companion Companion;

    public final void registerProjectPlugin(@NotNull Project project, @NotNull IdeaPluginDescriptor plugin) {
        Set set;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)plugin, (String)"plugin");
        Map<Project, Set<PluginId>> $this$getOrPut$iv = this.projectPluginReferences;
        boolean $i$f$getOrPut = false;
        Set value$iv = $this$getOrPut$iv.get(project);
        if (value$iv == null) {
            boolean bl = false;
            boolean bl2 = false;
            Set answer$iv = new LinkedHashSet();
            $this$getOrPut$iv.put(project, answer$iv);
            set = answer$iv;
        } else {
            set = value$iv;
        }
        PluginId pluginId = plugin.getPluginId();
        Intrinsics.checkExpressionValueIsNotNull((Object)pluginId, (String)"plugin.pluginId");
        set.add((PluginId)pluginId);
    }

    public ProjectPluginTracker() {
        Map map2;
        ProjectPluginTracker projectPluginTracker = this;
        boolean bl = false;
        projectPluginTracker.projectPluginReferences = map2 = (Map)new LinkedHashMap();
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkExpressionValueIsNotNull((Object)application, (String)"ApplicationManager.getApplication()");
        MessageBusConnection messageBusConnection = application.getMessageBus().connect();
        Intrinsics.checkExpressionValueIsNotNull((Object)messageBusConnection, (String)"ApplicationManager.getAp\u2026on().messageBus.connect()");
        MessageBusConnection connection = messageBusConnection;
        connection.subscribe(ProjectManager.TOPIC, (Object)new ProjectManagerListener(){

            /*
             * WARNING - void declaration
             */
            public void projectClosing(@NotNull Project project) {
                Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
                Set set = (Set)projectPluginReferences.remove(project);
                if (set == null) {
                    return;
                }
                Set pluginsToUnload = set;
                if (!applicationShuttingDown) {
                    void $this$mapNotNullTo$iv$iv;
                    Iterable $this$mapNotNull$iv = pluginsToUnload;
                    boolean $i$f$mapNotNull = false;
                    Iterable iterable = $this$mapNotNull$iv;
                    Collection destination$iv$iv = new ArrayList();
                    boolean $i$f$mapNotNullTo = false;
                    void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                    boolean $i$f$forEach = false;
                    Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
                    while (iterator2.hasNext()) {
                        IdeaPluginDescriptor ideaPluginDescriptor;
                        Object element$iv$iv$iv;
                        Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                        boolean bl = false;
                        PluginId it = (PluginId)element$iv$iv;
                        boolean bl2 = false;
                        if (PluginManagerCore.getPlugin(it) == null) continue;
                        boolean bl3 = false;
                        boolean bl4 = false;
                        IdeaPluginDescriptor it$iv$iv = ideaPluginDescriptor;
                        boolean bl5 = false;
                        destination$iv$iv.add(it$iv$iv);
                    }
                    List pluginDescriptorsToUnload = (List)destination$iv$iv;
                    Companion.getLOG().info("Disabling plugins on project unload: " + CollectionsKt.joinToString$default((Iterable)pluginDescriptorsToUnload, null, null, null, (int)0, null, (Function1)projectClosing.1.INSTANCE, (int)31, null));
                    PluginEnabler.enablePlugins(project, pluginDescriptorsToUnload, false);
                }
            }
        });
        connection.subscribe(AppLifecycleListener.TOPIC, (Object)new AppLifecycleListener(){

            @Override
            public void appWillBeClosed(boolean isRestart) {
                applicationShuttingDown = true;
            }
        });
    }

    static {
        Companion = new Companion(null);
        Logger logger = Logger.getInstance(ProjectPluginTracker.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logger.getInstance(Proje\u2026luginTracker::class.java)");
        LOG = logger;
    }

    @JvmStatic
    @NotNull
    public static final ProjectPluginTracker getInstance() {
        return Companion.getInstance();
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\b\u001a\u00020\tH\u0007R\u0016\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\n"}, d2={"Lcom/intellij/ide/plugins/ProjectPluginTracker$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "getInstance", "Lcom/intellij/ide/plugins/ProjectPluginTracker;", "intellij.platform.ide.impl"})
    public static final class Companion {
        @NotNull
        public final Logger getLOG() {
            return LOG;
        }

        @JvmStatic
        @NotNull
        public final ProjectPluginTracker getInstance() {
            Object object = ServiceManager.getService(ProjectPluginTracker.class);
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"ServiceManager.getServic\u2026luginTracker::class.java)");
            return (ProjectPluginTracker)object;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

