/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins.newui;

import com.intellij.icons.AllIcons;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.newui.HiDPIPluginLogoIcon;
import com.intellij.ide.plugins.newui.PluginLogo;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.ui.JBColor;
import com.intellij.util.ArrayUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PluginLogoApi {
    private final int myWidth;
    private final int myHeight;
    private final Logger myLogger;

    @NotNull
    public static Icon getIcon(@NotNull IdeaPluginDescriptor descriptor2, int width, int height, @Nullable Logger logger) {
        if (descriptor2 == null) {
            PluginLogoApi.$$$reportNull$$$0(0);
        }
        return new PluginLogoApi(width, height, logger).getIcon(descriptor2);
    }

    private PluginLogoApi(int width, int height, @Nullable Logger logger) {
        this.myWidth = width;
        this.myHeight = height;
        this.myLogger = logger;
    }

    @NotNull
    private Icon getIcon(@NotNull IdeaPluginDescriptor descriptor2) {
        Path path;
        if (descriptor2 == null) {
            PluginLogoApi.$$$reportNull$$$0(1);
        }
        if ((path = descriptor2.getPluginPath()) == null) {
            Icon icon2 = this.getDefaultIcon();
            if (icon2 == null) {
                PluginLogoApi.$$$reportNull$$$0(2);
            }
            return icon2;
        }
        if (Files.isDirectory(path, new LinkOption[0])) {
            Icon icon3;
            if (System.getProperty("idea.required.plugins.id") != null && (icon3 = this.tryLoadDirIcon(path.resolve("classes"))) != null) {
                Icon icon4 = icon3;
                if (icon4 == null) {
                    PluginLogoApi.$$$reportNull$$$0(3);
                }
                return icon4;
            }
            icon3 = this.tryLoadDirIcon(path);
            if (icon3 != null) {
                Icon icon5 = icon3;
                if (icon5 == null) {
                    PluginLogoApi.$$$reportNull$$$0(4);
                }
                return icon5;
            }
            Path libFile = path.resolve("lib");
            if (!Files.isDirectory(libFile, new LinkOption[0])) {
                Icon icon6 = this.getDefaultIcon();
                if (icon6 == null) {
                    PluginLogoApi.$$$reportNull$$$0(5);
                }
                return icon6;
            }
            Object[] files2 = libFile.toFile().listFiles();
            if (ArrayUtil.isEmpty((Object[])files2)) {
                Icon icon7 = this.getDefaultIcon();
                if (icon7 == null) {
                    PluginLogoApi.$$$reportNull$$$0(6);
                }
                return icon7;
            }
            for (Object file2 : files2) {
                Icon dirIcon = this.tryLoadDirIcon(((File)file2).toPath());
                if (dirIcon != null) {
                    Icon icon8 = dirIcon;
                    if (icon8 == null) {
                        PluginLogoApi.$$$reportNull$$$0(7);
                    }
                    return icon8;
                }
                Icon jarIcon = this.tryLoadJarIcon((File)file2);
                if (jarIcon == null) continue;
                Icon icon9 = jarIcon;
                if (icon9 == null) {
                    PluginLogoApi.$$$reportNull$$$0(8);
                }
                return icon9;
            }
        } else {
            Icon icon10 = this.tryLoadJarIcon(path.toFile());
            if (icon10 != null) {
                Icon icon11 = icon10;
                if (icon11 == null) {
                    PluginLogoApi.$$$reportNull$$$0(9);
                }
                return icon11;
            }
        }
        Icon icon12 = this.getDefaultIcon();
        if (icon12 == null) {
            PluginLogoApi.$$$reportNull$$$0(10);
        }
        return icon12;
    }

    @Nullable
    private Icon tryLoadDirIcon(@NotNull Path path) {
        boolean light;
        Icon icon2;
        if (path == null) {
            PluginLogoApi.$$$reportNull$$$0(11);
        }
        return (icon2 = this.tryLoadIcon(path, light = JBColor.isBright())) == null ? this.tryLoadIcon(path, !light) : icon2;
    }

    @Nullable
    private Icon tryLoadJarIcon(@NotNull File path) {
        Icon icon2;
        if (path == null) {
            PluginLogoApi.$$$reportNull$$$0(12);
        }
        if (!FileUtilRt.isJarOrZip((File)path) || !path.exists()) {
            return null;
        }
        ZipFile zipFile = new ZipFile(path);
        try {
            boolean light = JBColor.isBright();
            Icon icon3 = this.tryLoadIcon(zipFile, light);
            icon2 = icon3 == null ? this.tryLoadIcon(zipFile, !light) : icon3;
        }
        catch (Throwable throwable) {
            try {
                try {
                    zipFile.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                if (this.myLogger != null) {
                    this.myLogger.error((Throwable)e);
                }
                return null;
            }
        }
        zipFile.close();
        return icon2;
    }

    @Nullable
    private Icon tryLoadIcon(@NotNull Path dirFile, boolean light) {
        if (dirFile == null) {
            PluginLogoApi.$$$reportNull$$$0(13);
        }
        try {
            Path iconFile = dirFile.resolve(PluginLogo.getIconFileName(light));
            return Files.size(iconFile) > 0L ? this.loadFileIcon(Files.newInputStream(iconFile, new OpenOption[0])) : null;
        }
        catch (NoSuchFileException ignore) {
            return null;
        }
        catch (IOException e) {
            if (this.myLogger != null) {
                this.myLogger.error((Throwable)e);
            }
            return null;
        }
    }

    @Nullable
    private Icon tryLoadIcon(@NotNull ZipFile zipFile, boolean light) {
        if (zipFile == null) {
            PluginLogoApi.$$$reportNull$$$0(14);
        }
        try {
            ZipEntry iconEntry = zipFile.getEntry(PluginLogo.getIconFileName(light));
            return iconEntry == null ? null : this.loadFileIcon(zipFile.getInputStream(iconEntry));
        }
        catch (IOException e) {
            if (this.myLogger != null) {
                this.myLogger.error((Throwable)e);
            }
            return null;
        }
    }

    @NotNull
    private Icon loadFileIcon(@NotNull InputStream stream) throws IOException {
        if (stream == null) {
            PluginLogoApi.$$$reportNull$$$0(15);
        }
        Icon icon2 = HiDPIPluginLogoIcon.loadSVG(stream, this.myWidth, this.myHeight);
        if (icon2 == null) {
            PluginLogoApi.$$$reportNull$$$0(16);
        }
        return icon2;
    }

    private Icon getDefaultIcon() {
        block3: {
            URL url;
            if (AllIcons.Plugins.PluginLogo instanceof IconLoader.CachedImageIcon && (url = ((IconLoader.CachedImageIcon)AllIcons.Plugins.PluginLogo).getURL()) != null) {
                try {
                    return HiDPIPluginLogoIcon.loadSVG(url.openStream(), this.myWidth, this.myHeight);
                }
                catch (IOException e) {
                    if (this.myLogger == null) break block3;
                    this.myLogger.error((Throwable)e);
                }
            }
        }
        return AllIcons.Plugins.PluginLogo;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/plugins/newui/PluginLogoApi";
                break;
            }
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dirFile";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "zipFile";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stream";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/plugins/newui/PluginLogoApi";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getIcon";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "loadFileIcon";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getIcon";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 16: {
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "tryLoadDirIcon";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "tryLoadJarIcon";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "tryLoadIcon";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "loadFileIcon";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

