/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util;

import com.intellij.ide.IdeBundle;
import com.intellij.lang.findUsages.LanguageFindUsages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.ElementDescriptionLocation;
import com.intellij.psi.ElementDescriptionProvider;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.meta.PsiMetaData;
import com.intellij.psi.meta.PsiMetaOwner;
import com.intellij.psi.meta.PsiPresentableMetaData;
import com.intellij.psi.util.PsiUtilBase;
import org.jetbrains.annotations.NotNull;

public class DeleteTypeDescriptionLocation
extends ElementDescriptionLocation {
    private final boolean myPlural;
    public static final DeleteTypeDescriptionLocation SINGULAR = new DeleteTypeDescriptionLocation(false);
    public static final DeleteTypeDescriptionLocation PLURAL = new DeleteTypeDescriptionLocation(true);
    private static final ElementDescriptionProvider ourDefaultProvider = new DefaultProvider();

    private DeleteTypeDescriptionLocation(boolean plural) {
        this.myPlural = plural;
    }

    @NotNull
    public ElementDescriptionProvider getDefaultProvider() {
        ElementDescriptionProvider elementDescriptionProvider = ourDefaultProvider;
        if (elementDescriptionProvider == null) {
            DeleteTypeDescriptionLocation.$$$reportNull$$$0(0);
        }
        return elementDescriptionProvider;
    }

    public boolean isPlural() {
        return this.myPlural;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/DeleteTypeDescriptionLocation", "getDefaultProvider"));
    }

    private static class DefaultProvider
    implements ElementDescriptionProvider {
        private DefaultProvider() {
        }

        public String getElementDescription(@NotNull PsiElement element2, @NotNull ElementDescriptionLocation location) {
            if (element2 == null) {
                DefaultProvider.$$$reportNull$$$0(0);
            }
            if (location == null) {
                DefaultProvider.$$$reportNull$$$0(1);
            }
            if (location instanceof DeleteTypeDescriptionLocation) {
                String typeName;
                int count;
                boolean plural = ((DeleteTypeDescriptionLocation)location).isPlural();
                int n = count = plural ? 2 : 1;
                if (element2 instanceof PsiFileSystemItem && PsiUtilBase.isSymLink((PsiFileSystemItem)((PsiFileSystemItem)element2))) {
                    return IdeBundle.message((String)"prompt.delete.symlink", (Object[])new Object[]{count});
                }
                if (element2 instanceof PsiFile) {
                    return IdeBundle.message((String)"prompt.delete.file", (Object[])new Object[]{count});
                }
                if (element2 instanceof PsiDirectory) {
                    return IdeBundle.message((String)"prompt.delete.directory", (Object[])new Object[]{count});
                }
                PsiMetaData metaData = element2 instanceof PsiMetaOwner ? ((PsiMetaOwner)element2).getMetaData() : null;
                String string = typeName = metaData instanceof PsiPresentableMetaData ? ((PsiPresentableMetaData)metaData).getTypeName() : null;
                if (typeName == null) {
                    typeName = LanguageFindUsages.getType((PsiElement)element2);
                }
                return !plural ? typeName : StringUtil.pluralize((String)typeName);
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "element";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "location";
                    break;
                }
            }
            objectArray[1] = "com/intellij/ide/util/DeleteTypeDescriptionLocation$DefaultProvider";
            objectArray[2] = "getElementDescription";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

