/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.actions;

import com.intellij.application.options.schemes.SchemeNameGenerator;
import com.intellij.ide.IdeEventQueue;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.keymap.KeyMapBundle;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.keymap.ex.KeymapManagerEx;
import com.intellij.openapi.ui.Messages;
import com.intellij.util.containers.ContainerUtil;
import java.awt.AWTEvent;
import java.awt.event.KeyEvent;
import java.util.HashSet;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CtrlYActionChooser {
    private static final String ASK_ABOUT_SHORTCUT = "ask.about.ctrl.y.shortcut.v2";
    private static final Set<String> TARGET_KEYMAPS = new HashSet<String>(){
        {
            this.add("$default");
            this.add("Default for XWin");
            this.add("Default for KDE");
            this.add("Default for GNOME");
        }
    };

    @Nullable
    private static Keymap getCurrentKeymap() {
        KeymapManager keymapManager2 = KeymapManager.getInstance();
        return keymapManager2 == null ? null : keymapManager2.getActiveKeymap();
    }

    @NotNull
    private static Keymap getRootKeymap(@NotNull Keymap keymap2) {
        Keymap parent;
        if (keymap2 == null) {
            CtrlYActionChooser.$$$reportNull$$$0(0);
        }
        while (keymap2.canModify() && (parent = keymap2.getParent()) != null) {
            keymap2 = parent;
        }
        Keymap keymap3 = keymap2;
        if (keymap3 == null) {
            CtrlYActionChooser.$$$reportNull$$$0(1);
        }
        return keymap3;
    }

    private static boolean isCtrlY(AWTEvent event) {
        if (!(event instanceof KeyEvent)) {
            return false;
        }
        KeyEvent keyEvent = (KeyEvent)event;
        int modifiers = keyEvent.getModifiers();
        return keyEvent.getKeyCode() == 89 && (modifiers & 2) != 0 && (modifiers & 1) == 0 && (modifiers & 0x20) == 0 && (modifiers & 8) == 0 && (modifiers & 4) == 0;
    }

    private static void patchKeymap(@NotNull Keymap currentKeymap) {
        if (currentKeymap == null) {
            CtrlYActionChooser.$$$reportNull$$$0(2);
        }
        KeymapManager keymapManager2 = KeymapManager.getInstance();
        assert (keymapManager2 instanceof KeymapManagerEx);
        Keymap[] allKeymaps = ((KeymapManagerEx)keymapManager2).getAllKeymaps();
        String name = SchemeNameGenerator.getUniqueName(KeyMapBundle.message((String)"keymap.with.patched.redo.name", (Object[])new Object[]{currentKeymap.getPresentableName()}), n -> ContainerUtil.exists((Object[])allKeymaps, t -> n.equals(t.getName()) || n.equals(t.getPresentableName())));
        Keymap newKeymap = currentKeymap.deriveKeymap(name);
        KeyboardShortcut shortcut = KeyboardShortcut.fromString((String)"control Y");
        newKeymap.removeShortcut("EditorDeleteLine", (Shortcut)shortcut);
        newKeymap.addShortcut("$Redo", (Shortcut)shortcut);
        ((KeymapManagerEx)keymapManager2).getSchemeManager().addScheme(newKeymap);
        ((KeymapManagerEx)keymapManager2).setActiveKeymap(newKeymap);
    }

    private static void invokeRedo(DataContext dataContext) {
        AnAction action2 = ActionManager.getInstance().getAction("$Redo");
        if (action2 != null) {
            ActionUtil.invokeAction((AnAction)action2, (DataContext)dataContext, (String)"MainMenu", null, null);
        }
    }

    public static boolean isCurrentShortcutOk(DataContext dataContext) {
        if (!PropertiesComponent.getInstance().isValueSet(ASK_ABOUT_SHORTCUT)) {
            return true;
        }
        Keymap keymap2 = CtrlYActionChooser.getCurrentKeymap();
        if (keymap2 == null) {
            return true;
        }
        Keymap rootKeymap = CtrlYActionChooser.getRootKeymap(keymap2);
        if (!TARGET_KEYMAPS.contains(rootKeymap.getName())) {
            return true;
        }
        AWTEvent event = IdeEventQueue.getInstance().getTrueCurrentEvent();
        if (!CtrlYActionChooser.isCtrlY(event)) {
            return true;
        }
        int savedCount = IdeEventQueue.getInstance().getEventCount();
        int choice = Messages.showDialog((String)KeyMapBundle.message((String)"keymap.patch.dialog.message", (Object[])new Object[0]), (String)KeyMapBundle.message((String)"keymap.patch.dialog.title", (Object[])new Object[0]), (String[])new String[]{KeyMapBundle.message((String)"keymap.patch.dialog.redo.option", (Object[])new Object[0]), KeyMapBundle.message((String)"keymap.patch.dialog.delete.line.option", (Object[])new Object[0]), KeyMapBundle.message((String)"keymap.patch.dialog.cancel.option", (Object[])new Object[0])}, (int)2, (Icon)Messages.getInformationIcon(), null);
        IdeEventQueue.getInstance().setEventCount(savedCount);
        if (choice < 0 || choice > 1) {
            return false;
        }
        PropertiesComponent.getInstance().unsetValue(ASK_ABOUT_SHORTCUT);
        if (choice == 1) {
            return true;
        }
        CtrlYActionChooser.patchKeymap(keymap2);
        CtrlYActionChooser.invokeRedo(dataContext);
        return false;
    }

    public static void askAboutShortcut() {
        PropertiesComponent.getInstance().setValue(ASK_ABOUT_SHORTCUT, true);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keymap";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/editor/actions/CtrlYActionChooser";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentKeymap";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/editor/actions/CtrlYActionChooser";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootKeymap";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getRootKeymap";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "patchKeymap";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

