/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.autoimport;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.NonBlockingReadAction;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.externalSystem.autoimport.AutoImportProjectTracker;
import com.intellij.openapi.externalSystem.autoimport.ExternalSystemProjectAware;
import com.intellij.openapi.externalSystem.autoimport.ExternalSystemProjectRefreshListener;
import com.intellij.openapi.externalSystem.autoimport.ExternalSystemRefreshStatus;
import com.intellij.openapi.externalSystem.autoimport.ProjectSettingsTracker;
import com.intellij.openapi.externalSystem.autoimport.ProjectSettingsTracker$sam$java_lang_Runnable$0;
import com.intellij.openapi.externalSystem.autoimport.ProjectSettingsTracker$sam$java_util_function_Consumer$0;
import com.intellij.openapi.externalSystem.autoimport.ProjectStatus;
import com.intellij.openapi.externalSystem.autoimport.changes.AsyncFilesChangesProviderImpl;
import com.intellij.openapi.externalSystem.autoimport.changes.FilesChangesListener;
import com.intellij.openapi.externalSystem.util.CrcUtils;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.observable.operations.AnonymousParallelOperationTrace;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.LocalTimeCounter;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0007\u0018\u00002\u00020\u0001:\u0002:;B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u0014\u0010\u001a\u001a\u00020\u001b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001dJ\b\u0010\u001e\u001a\u00020\u001bH\u0002J\b\u0010\u001f\u001a\u00020\u001bH\u0002J\u0014\u0010 \u001a\u00020\u001b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001dJ\u0010\u0010!\u001a\u00020\u00162\u0006\u0010\"\u001a\u00020#H\u0002J\u0014\u0010$\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00160\u0014H\u0002J\u000e\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00150&H\u0002J\b\u0010'\u001a\u0004\u0018\u00010(J\u0006\u0010)\u001a\u00020*J\u001c\u0010+\u001a\u00020,2\u0012\u0010-\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00160\u0014H\u0002J\u0016\u0010.\u001a\u00020\u001b2\f\u0010/\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001dH\u0002J\b\u00100\u001a\u00020,H\u0002J\u0006\u00101\u001a\u00020,J\u000e\u00102\u001a\u00020\u001b2\u0006\u00103\u001a\u00020*J\u0006\u00104\u001a\u00020\u001bJ(\u00105\u001a\u00020\u001b2\u001e\u0010/\u001a\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00160\u0014\u0012\u0004\u0012\u00020\u001b06H\u0002J\"\u00107\u001a\u00020\u001b2\u0018\u0010/\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00150&\u0012\u0004\u0012\u00020\u001b06H\u0002J\u0018\u00108\u001a\u00020\u001b2\u000e\b\u0002\u00109\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001dH\u0002R\u0013\u0010\r\u001a\u00070\u000e\u00a2\u0006\u0002\b\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R4\u0010\u0012\u001a(\u0012$\u0012\"\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u0016 \u0017*\u0010\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u0016\u0018\u00010\u00140\u00140\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006<"}, d2={"Lcom/intellij/openapi/externalSystem/autoimport/ProjectSettingsTracker;", "", "project", "Lcom/intellij/openapi/project/Project;", "projectTracker", "Lcom/intellij/openapi/externalSystem/autoimport/AutoImportProjectTracker;", "backgroundExecutor", "Ljava/util/concurrent/Executor;", "projectAware", "Lcom/intellij/openapi/externalSystem/autoimport/ExternalSystemProjectAware;", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/externalSystem/autoimport/AutoImportProjectTracker;Ljava/util/concurrent/Executor;Lcom/intellij/openapi/externalSystem/autoimport/ExternalSystemProjectAware;Lcom/intellij/openapi/Disposable;)V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "applyChangesOperation", "Lcom/intellij/openapi/observable/operations/AnonymousParallelOperationTrace;", "settingsFilesCRC", "Ljava/util/concurrent/atomic/AtomicReference;", "", "", "", "kotlin.jvm.PlatformType", "status", "Lcom/intellij/openapi/externalSystem/autoimport/ProjectStatus;", "afterApplyChanges", "", "listener", "Lkotlin/Function0;", "applyChanges", "applyUnknownChanges", "beforeApplyChanges", "calculateCrc", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "calculateSettingsFilesCRC", "collectSettingsFiles", "", "getModificationType", "Lcom/intellij/openapi/externalSystem/autoimport/ProjectStatus$ModificationType;", "getState", "Lcom/intellij/openapi/externalSystem/autoimport/ProjectSettingsTracker$State;", "hasChanges", "", "newSettingsFilesCRC", "invokeLater", "action", "isAsyncAllowed", "isUpToDate", "loadState", "state", "refreshChanges", "submitSettingsFilesCRCCalculation", "Lkotlin/Function1;", "submitSettingsFilesCollection", "submitSettingsFilesRefresh", "callback", "ProjectSettingsListener", "State", "intellij.platform.externalSystem.impl"})
@ApiStatus.Internal
public final class ProjectSettingsTracker {
    private final Logger LOG;
    private final ProjectStatus status;
    private final AtomicReference<Map<String, Long>> settingsFilesCRC;
    private final AnonymousParallelOperationTrace applyChangesOperation;
    private final Project project;
    private final AutoImportProjectTracker projectTracker;
    private final Executor backgroundExecutor;
    private final ExternalSystemProjectAware projectAware;
    private final Disposable parentDisposable;

    private final Set<String> collectSettingsFiles() {
        return SetsKt.plus((Set)this.projectAware.getSettingsFiles(), (Iterable)this.settingsFilesCRC.get().keySet());
    }

    /*
     * WARNING - void declaration
     */
    private final Map<String, Long> calculateSettingsFilesCRC() {
        void $this$mapTo$iv$iv;
        Iterable $this$mapNotNullTo$iv$iv;
        LocalFileSystem localFileSystem2 = LocalFileSystem.getInstance();
        Iterable $this$mapNotNull$iv = this.projectAware.getSettingsFiles();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        VirtualFile virtualFile = $this$forEach$iv$iv$iv.iterator();
        while (virtualFile.hasNext()) {
            VirtualFile virtualFile2;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = virtualFile.next();
            boolean bl = false;
            String it = (String)element$iv$iv;
            boolean bl2 = false;
            if (localFileSystem2.findFileByPath(it) == null) continue;
            boolean bl3 = false;
            boolean bl4 = false;
            VirtualFile it$iv$iv = virtualFile2;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$mapNotNullTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            virtualFile = (VirtualFile)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            void v0 = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)v0, (String)"it");
            Pair pair = TuplesKt.to((Object)v0.getPath(), (Object)this.calculateCrc((VirtualFile)it));
            collection.add(pair);
        }
        return MapsKt.toMap((Iterable)((List)destination$iv$iv));
    }

    private final long calculateCrc(VirtualFile file2) {
        FileDocumentManager fileDocumentManager = FileDocumentManager.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)fileDocumentManager, (String)"FileDocumentManager.getInstance()");
        FileDocumentManager fileDocumentManager2 = fileDocumentManager;
        Document document = fileDocumentManager2.getCachedDocument(file2);
        if (document != null) {
            return CrcUtils.calculateCrc(document, this.project, file2);
        }
        return CrcUtils.calculateCrc(file2, this.project);
    }

    public final boolean isUpToDate() {
        return this.status.isUpToDate();
    }

    @Nullable
    public final ProjectStatus.ModificationType getModificationType() {
        return this.status.getModificationType();
    }

    private final boolean hasChanges(Map<String, Long> newSettingsFilesCRC) {
        boolean bl;
        block4: {
            Map<String, Long> oldSettingsFilesCRC = this.settingsFilesCRC.get();
            if (newSettingsFilesCRC.size() != oldSettingsFilesCRC.size()) {
                return true;
            }
            Map<String, Long> $this$any$iv = newSettingsFilesCRC;
            boolean $i$f$any = false;
            if ($this$any$iv.isEmpty()) {
                bl = false;
            } else {
                Map<String, Long> map2 = $this$any$iv;
                boolean bl2 = false;
                Iterator<Map.Entry<String, Long>> iterator2 = map2.entrySet().iterator();
                while (iterator2.hasNext()) {
                    Map.Entry<String, Long> element$iv;
                    Map.Entry<String, Long> it = element$iv = iterator2.next();
                    boolean bl3 = false;
                    Long l = oldSettingsFilesCRC.get(it.getKey());
                    if (!(l == null || ((Number)it.getValue()).longValue() != l.longValue())) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        return bl;
    }

    private final void applyChanges() {
        this.applyChangesOperation.startTask();
        this.submitSettingsFilesRefresh((Function0<Unit>)((Function0)new Function0<Unit>(this){
            final /* synthetic */ ProjectSettingsTracker this$0;

            public final void invoke() {
                ProjectSettingsTracker.access$submitSettingsFilesCRCCalculation(this.this$0, (Function1)new Function1<Map<String, ? extends Long>, Unit>(this){
                    final /* synthetic */ applyChanges.1 this$0;

                    public final void invoke(@NotNull Map<String, Long> newSettingsFilesCRC) {
                        Intrinsics.checkParameterIsNotNull(newSettingsFilesCRC, (String)"newSettingsFilesCRC");
                        ProjectSettingsTracker.access$getSettingsFilesCRC$p(this.this$0.this$0).set(newSettingsFilesCRC);
                        ProjectSettingsTracker.access$getStatus$p(this.this$0.this$0).markSynchronized(LocalTimeCounter.currentTime());
                        ProjectSettingsTracker.access$getApplyChangesOperation$p(this.this$0.this$0).finishTask();
                    }
                    {
                        this.this$0 = var1_1;
                        super(1);
                    }
                });
            }
            {
                this.this$0 = projectSettingsTracker;
                super(0);
            }
        }));
    }

    private final void applyUnknownChanges() {
        this.applyChangesOperation.startTask();
        this.submitSettingsFilesRefresh((Function0<Unit>)((Function0)new Function0<Unit>(this){
            final /* synthetic */ ProjectSettingsTracker this$0;

            public final void invoke() {
                ProjectSettingsTracker.access$submitSettingsFilesCRCCalculation(this.this$0, (Function1)new Function1<Map<String, ? extends Long>, Unit>(this){
                    final /* synthetic */ applyUnknownChanges.1 this$0;

                    public final void invoke(@NotNull Map<String, Long> newSettingsFilesCRC) {
                        Intrinsics.checkParameterIsNotNull(newSettingsFilesCRC, (String)"newSettingsFilesCRC");
                        ProjectSettingsTracker.access$getSettingsFilesCRC$p(this.this$0.this$0).updateAndGet((UnaryOperator)new UnaryOperator<Map<String, ? extends Long>>(newSettingsFilesCRC){
                            final /* synthetic */ Map $newSettingsFilesCRC;

                            @NotNull
                            public final Map<String, Long> apply(Map<String, Long> it) {
                                Map<String, Long> map2 = it;
                                Intrinsics.checkExpressionValueIsNotNull(map2, (String)"it");
                                return MapsKt.plus((Map)this.$newSettingsFilesCRC, map2);
                            }
                            {
                                this.$newSettingsFilesCRC = map2;
                            }
                        });
                        if (!ProjectSettingsTracker.access$hasChanges(this.this$0.this$0, newSettingsFilesCRC)) {
                            ProjectSettingsTracker.access$getStatus$p(this.this$0.this$0).markSynchronized(LocalTimeCounter.currentTime());
                        }
                        ProjectSettingsTracker.access$getApplyChangesOperation$p(this.this$0.this$0).finishTask();
                    }
                    {
                        this.this$0 = var1_1;
                        super(1);
                    }
                });
            }
            {
                this.this$0 = projectSettingsTracker;
                super(0);
            }
        }));
    }

    public final void refreshChanges() {
        this.submitSettingsFilesRefresh((Function0<Unit>)((Function0)new Function0<Unit>(this){
            final /* synthetic */ ProjectSettingsTracker this$0;

            public final void invoke() {
                ProjectSettingsTracker.access$submitSettingsFilesCRCCalculation(this.this$0, (Function1)new Function1<Map<String, ? extends Long>, Unit>(this){
                    final /* synthetic */ refreshChanges.1 this$0;

                    public final void invoke(@NotNull Map<String, Long> newSettingsFilesCRC) {
                        Intrinsics.checkParameterIsNotNull(newSettingsFilesCRC, (String)"newSettingsFilesCRC");
                        boolean bl = ProjectSettingsTracker.access$hasChanges(this.this$0.this$0, newSettingsFilesCRC);
                        if (bl) {
                            ProjectSettingsTracker.access$getStatus$p(this.this$0.this$0).markDirty(LocalTimeCounter.currentTime(), ProjectStatus.ModificationType.EXTERNAL);
                        } else {
                            ProjectSettingsTracker.access$getStatus$p(this.this$0.this$0).markReverted(LocalTimeCounter.currentTime());
                        }
                        ProjectSettingsTracker.access$getProjectTracker$p(this.this$0.this$0).scheduleChangeProcessing();
                    }
                    {
                        this.this$0 = var1_1;
                        super(1);
                    }
                });
            }
            {
                this.this$0 = projectSettingsTracker;
                super(0);
            }
        }));
    }

    @NotNull
    public final State getState() {
        boolean bl = this.status.isDirty();
        Map<String, Long> map2 = this.settingsFilesCRC.get();
        Intrinsics.checkExpressionValueIsNotNull(map2, (String)"settingsFilesCRC.get()");
        return new State(bl, MapsKt.toMap(map2));
    }

    public final void loadState(@NotNull State state) {
        Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
        if (state.isDirty()) {
            this.status.markDirty(LocalTimeCounter.currentTime(), ProjectStatus.ModificationType.EXTERNAL);
        }
        this.settingsFilesCRC.set(MapsKt.toMap(state.getSettingsFiles()));
    }

    private final boolean isAsyncAllowed() {
        return this.projectTracker.isAsyncChangesProcessing();
    }

    private final void submitSettingsFilesRefresh(Function0<Unit> callback2) {
        this.invokeLater((Function0<Unit>)((Function0)new Function0<Unit>(this, callback2){
            final /* synthetic */ ProjectSettingsTracker this$0;
            final /* synthetic */ Function0 $callback;

            public final void invoke() {
                FileDocumentManager fileDocumentManager = FileDocumentManager.getInstance();
                Intrinsics.checkExpressionValueIsNotNull((Object)fileDocumentManager, (String)"FileDocumentManager.getInstance()");
                FileDocumentManager fileDocumentManager2 = fileDocumentManager;
                fileDocumentManager2.saveAllDocuments();
                ProjectSettingsTracker.access$submitSettingsFilesCollection(this.this$0, (Function1)new Function1<Set<? extends String>, Unit>(this){
                    final /* synthetic */ submitSettingsFilesRefresh.2 this$0;

                    /*
                     * WARNING - void declaration
                     */
                    public final void invoke(@NotNull Set<String> settingsPaths) {
                        void $this$mapTo$iv$iv;
                        Intrinsics.checkParameterIsNotNull(settingsPaths, (String)"settingsPaths");
                        LocalFileSystem localFileSystem2 = LocalFileSystem.getInstance();
                        Iterable $this$map$iv = settingsPaths;
                        boolean $i$f$map = false;
                        Iterable iterable = $this$map$iv;
                        Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        boolean $i$f$mapTo = false;
                        for (T item$iv$iv : $this$mapTo$iv$iv) {
                            void it;
                            String string = (String)item$iv$iv;
                            Collection collection = destination$iv$iv;
                            boolean bl = false;
                            File file2 = new File((String)it);
                            collection.add(file2);
                        }
                        List settingsFiles = (List)destination$iv$iv;
                        Iterable iterable2 = settingsFiles;
                        boolean bl = ProjectSettingsTracker.access$isAsyncAllowed(this.this$0.this$0);
                        Object object = this.this$0.$callback;
                        if (object != null) {
                            Function0 function0 = object;
                            object = new ProjectSettingsTracker$sam$java_lang_Runnable$0(function0);
                        }
                        localFileSystem2.refreshIoFiles(iterable2, bl, false, (Runnable)object);
                    }
                    {
                        this.this$0 = var1_1;
                        super(1);
                    }
                });
            }
            {
                this.this$0 = projectSettingsTracker;
                this.$callback = function0;
                super(0);
            }
        }));
    }

    static /* synthetic */ void submitSettingsFilesRefresh$default(ProjectSettingsTracker projectSettingsTracker, Function0 function0, int n, Object object) {
        if ((n & 1) != 0) {
            function0 = submitSettingsFilesRefresh.1.INSTANCE;
        }
        projectSettingsTracker.submitSettingsFilesRefresh((Function0<Unit>)function0);
    }

    private final void submitSettingsFilesCollection(Function1<? super Set<String>, Unit> action2) {
        if (!this.isAsyncAllowed()) {
            action2.invoke(this.collectSettingsFiles());
            return;
        }
        NonBlockingReadAction nonBlockingReadAction = ReadAction.nonBlocking((Callable)new Callable<T>(this){
            final /* synthetic */ ProjectSettingsTracker this$0;

            @NotNull
            public final Set<String> call() {
                return ProjectSettingsTracker.access$collectSettingsFiles(this.this$0);
            }
            {
                this.this$0 = projectSettingsTracker;
            }
        }).expireWith(this.parentDisposable);
        ModalityState modalityState = ModalityState.defaultModalityState();
        Object object = action2;
        if (object != null) {
            Function1<? super Set<String>, Unit> function1 = object;
            object = new ProjectSettingsTracker$sam$java_util_function_Consumer$0(function1);
        }
        nonBlockingReadAction.finishOnUiThread(modalityState, (Consumer)object).submit(this.backgroundExecutor);
    }

    private final void submitSettingsFilesCRCCalculation(Function1<? super Map<String, Long>, Unit> action2) {
        if (!this.isAsyncAllowed()) {
            action2.invoke(this.calculateSettingsFilesCRC());
            return;
        }
        NonBlockingReadAction nonBlockingReadAction = ReadAction.nonBlocking((Callable)new Callable<T>(this){
            final /* synthetic */ ProjectSettingsTracker this$0;

            @NotNull
            public final Map<String, Long> call() {
                return ProjectSettingsTracker.access$calculateSettingsFilesCRC(this.this$0);
            }
            {
                this.this$0 = projectSettingsTracker;
            }
        }).expireWith(this.parentDisposable);
        ModalityState modalityState = ModalityState.defaultModalityState();
        Object object = action2;
        if (object != null) {
            Function1<? super Map<String, Long>, Unit> function1 = object;
            object = new ProjectSettingsTracker$sam$java_util_function_Consumer$0(function1);
        }
        nonBlockingReadAction.finishOnUiThread(modalityState, (Consumer)object).submit(this.backgroundExecutor);
    }

    private final void invokeLater(Function0<Unit> action2) {
        Application application = ApplicationManager.getApplication();
        if (!this.isAsyncAllowed()) {
            Object object = action2;
            if (object != null) {
                Function0<Unit> function0 = object;
                object = new ProjectSettingsTracker$sam$java_lang_Runnable$0(function0);
            }
            application.invokeAndWait((Runnable)object);
        } else {
            Object object = action2;
            if (object != null) {
                Function0<Unit> function0 = object;
                object = new ProjectSettingsTracker$sam$java_lang_Runnable$0(function0);
            }
            application.invokeLater((Runnable)object, (Condition)new Condition<Object>(this){
                final /* synthetic */ ProjectSettingsTracker this$0;

                public final boolean value(Object it) {
                    return Disposer.isDisposed((Disposable)ProjectSettingsTracker.access$getParentDisposable$p(this.this$0));
                }
                {
                    this.this$0 = projectSettingsTracker;
                }
            });
        }
    }

    public final void beforeApplyChanges(@NotNull Function0<Unit> listener2) {
        Intrinsics.checkParameterIsNotNull(listener2, (String)"listener");
        this.applyChangesOperation.beforeOperation(listener2);
    }

    public final void afterApplyChanges(@NotNull Function0<Unit> listener2) {
        Intrinsics.checkParameterIsNotNull(listener2, (String)"listener");
        this.applyChangesOperation.afterOperation(listener2);
    }

    public ProjectSettingsTracker(@NotNull Project project, @NotNull AutoImportProjectTracker projectTracker, @NotNull Executor backgroundExecutor, @NotNull ExternalSystemProjectAware projectAware, @NotNull Disposable parentDisposable) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)projectTracker, (String)"projectTracker");
        Intrinsics.checkParameterIsNotNull((Object)backgroundExecutor, (String)"backgroundExecutor");
        Intrinsics.checkParameterIsNotNull((Object)projectAware, (String)"projectAware");
        Intrinsics.checkParameterIsNotNull((Object)parentDisposable, (String)"parentDisposable");
        this.project = project;
        this.projectTracker = projectTracker;
        this.backgroundExecutor = backgroundExecutor;
        this.projectAware = projectAware;
        this.parentDisposable = parentDisposable;
        Logger logger = Logger.getInstance((String)"#com.intellij.openapi.externalSystem.autoimport");
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logger.getInstance(\"#com\u2026ternalSystem.autoimport\")");
        this.LOG = logger;
        this.status = new ProjectStatus("Settings " + this.projectAware.getProjectId().getReadableName());
        this.settingsFilesCRC = new AtomicReference<Map>(MapsKt.emptyMap());
        this.applyChangesOperation = new AnonymousParallelOperationTrace("Apply changes operation");
        ExternalSystemProjectRefreshListener projectRefreshListener2 = new ExternalSystemProjectRefreshListener(this){
            final /* synthetic */ ProjectSettingsTracker this$0;

            public void beforeProjectRefresh() {
                ProjectSettingsTracker.access$getApplyChangesOperation$p(this.this$0).startTask();
                ProjectSettingsTracker.access$applyChanges(this.this$0);
            }

            public void afterProjectRefresh(@NotNull ExternalSystemRefreshStatus status) {
                Intrinsics.checkParameterIsNotNull((Object)status, (String)"status");
                ProjectSettingsTracker.access$applyUnknownChanges(this.this$0);
                ProjectSettingsTracker.access$getApplyChangesOperation$p(this.this$0).finishTask();
            }
            {
                this.this$0 = $outer;
            }
        };
        this.projectAware.subscribe(projectRefreshListener2, this.parentDisposable);
        new AsyncFilesChangesProviderImpl(this.backgroundExecutor, (Function0<? extends Set<String>>)((Function0)new Function0<Set<? extends String>>(this){

            @NotNull
            public final Set<String> invoke() {
                return ((ProjectSettingsTracker)this.receiver).collectSettingsFiles();
            }

            public final KDeclarationContainer getOwner() {
                return Reflection.getOrCreateKotlinClass(ProjectSettingsTracker.class);
            }

            public final String getName() {
                return "collectSettingsFiles";
            }

            public final String getSignature() {
                return "collectSettingsFiles()Ljava/util/Set;";
            }
        })).subscribe(new ProjectSettingsListener(), this.parentDisposable);
    }

    public static final /* synthetic */ boolean access$hasChanges(ProjectSettingsTracker $this, Map newSettingsFilesCRC) {
        return $this.hasChanges(newSettingsFilesCRC);
    }

    public static final /* synthetic */ AutoImportProjectTracker access$getProjectTracker$p(ProjectSettingsTracker $this) {
        return $this.projectTracker;
    }

    public static final /* synthetic */ AtomicReference access$getSettingsFilesCRC$p(ProjectSettingsTracker $this) {
        return $this.settingsFilesCRC;
    }

    public static final /* synthetic */ void access$submitSettingsFilesCollection(ProjectSettingsTracker $this, Function1 action2) {
        $this.submitSettingsFilesCollection((Function1<? super Set<String>, Unit>)action2);
    }

    public static final /* synthetic */ boolean access$isAsyncAllowed(ProjectSettingsTracker $this) {
        return $this.isAsyncAllowed();
    }

    public static final /* synthetic */ Map access$calculateSettingsFilesCRC(ProjectSettingsTracker $this) {
        return $this.calculateSettingsFilesCRC();
    }

    public static final /* synthetic */ Disposable access$getParentDisposable$p(ProjectSettingsTracker $this) {
        return $this.parentDisposable;
    }

    public static final /* synthetic */ void access$applyChanges(ProjectSettingsTracker $this) {
        $this.applyChanges();
    }

    public static final /* synthetic */ void access$applyUnknownChanges(ProjectSettingsTracker $this) {
        $this.applyUnknownChanges();
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\t\n\u0002\b\u000e\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B%\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\u0014\b\u0002\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\u0002\u0010\bJ\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\u0015\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005H\u00c6\u0003J)\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u0014\b\u0002\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00032\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001J\t\u0010\u0017\u001a\u00020\u0006H\u00d6\u0001R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0002\u0010\t\"\u0004\b\n\u0010\u000bR&\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0018"}, d2={"Lcom/intellij/openapi/externalSystem/autoimport/ProjectSettingsTracker$State;", "", "isDirty", "", "settingsFiles", "", "", "", "(ZLjava/util/Map;)V", "()Z", "setDirty", "(Z)V", "getSettingsFiles", "()Ljava/util/Map;", "setSettingsFiles", "(Ljava/util/Map;)V", "component1", "component2", "copy", "equals", "other", "hashCode", "", "toString", "intellij.platform.externalSystem.impl"})
    public static final class State {
        private boolean isDirty;
        @NotNull
        private Map<String, Long> settingsFiles;

        public final boolean isDirty() {
            return this.isDirty;
        }

        public final void setDirty(boolean bl) {
            this.isDirty = bl;
        }

        @NotNull
        public final Map<String, Long> getSettingsFiles() {
            return this.settingsFiles;
        }

        public final void setSettingsFiles(@NotNull Map<String, Long> map2) {
            Intrinsics.checkParameterIsNotNull(map2, (String)"<set-?>");
            this.settingsFiles = map2;
        }

        public State(boolean isDirty, @NotNull Map<String, Long> settingsFiles) {
            Intrinsics.checkParameterIsNotNull(settingsFiles, (String)"settingsFiles");
            this.isDirty = isDirty;
            this.settingsFiles = settingsFiles;
        }

        public /* synthetic */ State(boolean bl, Map map2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                bl = true;
            }
            if ((n & 2) != 0) {
                map2 = MapsKt.emptyMap();
            }
            this(bl, map2);
        }

        public State() {
            this(false, null, 3, null);
        }

        public final boolean component1() {
            return this.isDirty;
        }

        @NotNull
        public final Map<String, Long> component2() {
            return this.settingsFiles;
        }

        @NotNull
        public final State copy(boolean isDirty, @NotNull Map<String, Long> settingsFiles) {
            Intrinsics.checkParameterIsNotNull(settingsFiles, (String)"settingsFiles");
            return new State(isDirty, settingsFiles);
        }

        public static /* synthetic */ State copy$default(State state, boolean bl, Map map2, int n, Object object) {
            if ((n & 1) != 0) {
                bl = state.isDirty;
            }
            if ((n & 2) != 0) {
                map2 = state.settingsFiles;
            }
            return state.copy(bl, map2);
        }

        @NotNull
        public String toString() {
            return "State(isDirty=" + this.isDirty + ", settingsFiles=" + this.settingsFiles + ")";
        }

        public int hashCode() {
            int n = this.isDirty ? 1 : 0;
            if (n != 0) {
                n = 1;
            }
            Map<String, Long> map2 = this.settingsFiles;
            return n * 31 + (map2 != null ? ((Object)map2).hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof State)) break block3;
                    State state = (State)object;
                    if (this.isDirty != state.isDirty || !Intrinsics.areEqual(this.settingsFiles, state.settingsFiles)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\u0006H\u0016J \u0010\b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J \u0010\u000f\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u000eH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/openapi/externalSystem/autoimport/ProjectSettingsTracker$ProjectSettingsListener;", "Lcom/intellij/openapi/externalSystem/autoimport/changes/FilesChangesListener;", "(Lcom/intellij/openapi/externalSystem/autoimport/ProjectSettingsTracker;)V", "hasRelevantChanges", "", "apply", "", "init", "logModificationAsDebug", "path", "", "modificationStamp", "", "type", "Lcom/intellij/openapi/externalSystem/autoimport/ProjectStatus$ModificationType;", "onFileChange", "modificationType", "intellij.platform.externalSystem.impl"})
    private final class ProjectSettingsListener
    implements FilesChangesListener {
        private boolean hasRelevantChanges;

        @Override
        public void onFileChange(@NotNull String path, long modificationStamp, @NotNull ProjectStatus.ModificationType modificationType) {
            Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
            Intrinsics.checkParameterIsNotNull((Object)((Object)modificationType), (String)"modificationType");
            this.hasRelevantChanges = true;
            this.logModificationAsDebug(path, modificationStamp, modificationType);
            if (ProjectSettingsTracker.this.applyChangesOperation.isOperationCompleted()) {
                ProjectSettingsTracker.this.status.markModified(LocalTimeCounter.currentTime(), modificationType);
            } else {
                ProjectSettingsTracker.this.status.markDirty(LocalTimeCounter.currentTime(), modificationType);
            }
        }

        @Override
        public void init() {
            this.hasRelevantChanges = false;
        }

        @Override
        public void apply() {
            if (this.hasRelevantChanges) {
                ProjectSettingsTracker.this.submitSettingsFilesCRCCalculation((Function1<? super Map<String, Long>, Unit>)((Function1)new Function1<Map<String, ? extends Long>, Unit>(this){
                    final /* synthetic */ ProjectSettingsListener this$0;

                    public final void invoke(@NotNull Map<String, Long> newSettingsFilesCRC) {
                        Intrinsics.checkParameterIsNotNull(newSettingsFilesCRC, (String)"newSettingsFilesCRC");
                        if (!ProjectSettingsTracker.access$hasChanges(this.this$0.ProjectSettingsTracker.this, newSettingsFilesCRC)) {
                            ProjectSettingsTracker.access$getStatus$p(this.this$0.ProjectSettingsTracker.this).markReverted(LocalTimeCounter.currentTime());
                        }
                        ProjectSettingsTracker.access$getProjectTracker$p(this.this$0.ProjectSettingsTracker.this).scheduleChangeProcessing();
                    }
                    {
                        this.this$0 = projectSettingsListener;
                        super(1);
                    }
                }));
            }
        }

        private final void logModificationAsDebug(String path, long modificationStamp, ProjectStatus.ModificationType type) {
            if (ProjectSettingsTracker.this.LOG.isDebugEnabled()) {
                String projectPath = ProjectSettingsTracker.this.projectAware.getProjectId().getExternalProjectPath();
                String string = FileUtil.getRelativePath((String)projectPath, (String)path, (char)'/');
                if (string == null) {
                    string = path;
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"FileUtil.getRelativePath\u2026tPath, path, '/') ?: path");
                String relativePath = string;
                ProjectSettingsTracker.this.LOG.debug("File " + relativePath + " is modified at " + modificationStamp + " as " + (Object)((Object)type));
            }
        }
    }
}

