/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.task.ui;

import com.intellij.icons.AllIcons;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.util.treeView.AbstractTreeBuilder;
import com.intellij.ide.util.treeView.AbstractTreeStructure;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.ide.util.treeView.TreeState;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionToolbarPosition;
import com.intellij.openapi.externalSystem.ExternalSystemUiAware;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.ExternalProjectInfo;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.task.TaskData;
import com.intellij.openapi.externalSystem.service.project.ProjectDataManager;
import com.intellij.openapi.externalSystem.service.project.manage.ExternalProjectsManagerImpl;
import com.intellij.openapi.externalSystem.service.project.manage.ExternalSystemTaskActivator;
import com.intellij.openapi.externalSystem.service.project.manage.TaskActivationState;
import com.intellij.openapi.externalSystem.settings.AbstractExternalSystemSettings;
import com.intellij.openapi.externalSystem.settings.ExternalProjectSettings;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemBundle;
import com.intellij.openapi.externalSystem.util.ExternalSystemUiUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.treeStructure.CachingSimpleNode;
import com.intellij.ui.treeStructure.SimpleNode;
import com.intellij.ui.treeStructure.SimpleTree;
import com.intellij.ui.treeStructure.SimpleTreeStructure;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.SwingHelper;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConfigureTasksActivationDialog
extends DialogWrapper {
    @NotNull
    private final Project myProject;
    @NotNull
    private final ExternalSystemTaskActivator myTaskActivator;
    @NotNull
    ProjectSystemId myProjectSystemId;
    private JPanel contentPane;
    private JPanel tasksPanel;
    private JPanel projectFieldPanel;
    private SimpleTree myTree;
    private AbstractTreeBuilder treeBuilder;
    private ComboBox projectCombobox;
    @NotNull
    private final ExternalSystemUiAware uiAware;
    private RootNode myRootNode;

    public ConfigureTasksActivationDialog(@NotNull Project project, @NotNull ProjectSystemId externalSystemId, @NotNull String projectPath) {
        if (project == null) {
            ConfigureTasksActivationDialog.$$$reportNull$$$0(0);
        }
        if (externalSystemId == null) {
            ConfigureTasksActivationDialog.$$$reportNull$$$0(1);
        }
        if (projectPath == null) {
            ConfigureTasksActivationDialog.$$$reportNull$$$0(2);
        }
        super(project, true);
        this.myProject = project;
        this.myProjectSystemId = externalSystemId;
        this.$$$setupUI$$$();
        this.uiAware = ExternalSystemUiUtil.getUiAware(this.myProjectSystemId);
        this.setUpDialog(projectPath);
        this.setModal(true);
        this.setTitle(ExternalSystemBundle.message((String)"external.system.task.activation.title", (Object[])new Object[]{externalSystemId.getReadableName()}));
        this.init();
        this.myTaskActivator = ExternalProjectsManagerImpl.getInstance(this.myProject).getTaskActivator();
    }

    protected Action @NotNull [] createActions() {
        Action[] actionArray = new Action[]{this.getOKAction()};
        if (actionArray == null) {
            ConfigureTasksActivationDialog.$$$reportNull$$$0(3);
        }
        return actionArray;
    }

    private void setUpDialog(@NotNull String projectPath) {
        if (projectPath == null) {
            ConfigureTasksActivationDialog.$$$reportNull$$$0(4);
        }
        AbstractExternalSystemSettings externalSystemSettings = ExternalSystemApiUtil.getSettings((Project)this.myProject, (ProjectSystemId)this.myProjectSystemId);
        Collection projectsSettings = externalSystemSettings.getLinkedProjectsSettings();
        List projects = ContainerUtil.map((Collection)projectsSettings, settings -> new ProjectItem(this.uiAware.getProjectRepresentationName(settings.getExternalProjectPath(), null), (ExternalProjectSettings)settings));
        this.myTree = new SimpleTree();
        this.myRootNode = new RootNode();
        this.treeBuilder = ConfigureTasksActivationDialog.createTreeBuilder(this.myProject, (SimpleNode)this.myRootNode, (Tree)this.myTree);
        ExternalProjectSettings currentProjectSettings = externalSystemSettings.getLinkedProjectSettings(projectPath);
        if (currentProjectSettings != null) {
            SwingHelper.updateItems(this.projectCombobox, projects, new ProjectItem(this.uiAware.getProjectRepresentationName(projectPath, null), currentProjectSettings));
        }
        this.projectCombobox.addActionListener(e -> this.updateTree(this.myRootNode));
    }

    private static AbstractTreeBuilder createTreeBuilder(@NotNull Project project, @NotNull SimpleNode root, @NotNull Tree tree) {
        if (project == null) {
            ConfigureTasksActivationDialog.$$$reportNull$$$0(5);
        }
        if (root == null) {
            ConfigureTasksActivationDialog.$$$reportNull$$$0(6);
        }
        if (tree == null) {
            ConfigureTasksActivationDialog.$$$reportNull$$$0(7);
        }
        DefaultTreeModel treeModel = new DefaultTreeModel(new DefaultMutableTreeNode(root));
        tree.setModel((TreeModel)treeModel);
        tree.setRootVisible(false);
        tree.getSelectionModel().setSelectionMode(4);
        AbstractTreeBuilder treeBuilder = new AbstractTreeBuilder((JTree)tree, treeModel, (AbstractTreeStructure)new SimpleTreeStructure.Impl(root), null){};
        Disposer.register((Disposable)project, (Disposable)treeBuilder);
        return treeBuilder;
    }

    protected JComponent createCenterPanel() {
        ToolbarDecorator decorator = ToolbarDecorator.createDecorator((JTree)this.myTree).setAddAction(button2 -> {
            ChooseProjectStep step;
            ProjectItem projectItem = (ProjectItem)this.projectCombobox.getSelectedItem();
            if (projectItem == null) {
                return;
            }
            ExternalProjectInfo projectData2 = ProjectDataManager.getInstance().getExternalProjectData(this.myProject, this.myProjectSystemId, projectItem.myProjectSettings.getExternalProjectPath());
            if (projectData2 == null || projectData2.getExternalProjectStructure() == null) {
                return;
            }
            ArrayList<ProjectPopupItem> popupItems = new ArrayList<ProjectPopupItem>();
            for (DataNode moduleDataNode : ExternalSystemApiUtil.findAllRecursively((DataNode)projectData2.getExternalProjectStructure(), (Key)ProjectKeys.MODULE)) {
                List tasks;
                if (moduleDataNode.isIgnored() || (tasks = ContainerUtil.map((Collection)ExternalSystemApiUtil.findAll((DataNode)moduleDataNode, (Key)ProjectKeys.TASK), node -> ((TaskData)node.getData()).getName())).isEmpty()) continue;
                popupItems.add(new ProjectPopupItem((ModuleData)moduleDataNode.getData(), tasks));
            }
            ChooseProjectStep projectStep = new ChooseProjectStep(popupItems);
            List projectItems = projectStep.getValues();
            ChooseProjectStep chooseProjectStep = step = projectItems.size() == 1 ? (ListPopupStep)projectStep.onChosen((ProjectPopupItem)projectItems.get(0), false) : projectStep;
            assert (step != null);
            JBPopupFactory.getInstance().createListPopup((ListPopupStep)step).show((RelativePoint)ObjectUtils.notNull((Object)button2.getPreferredPopupPoint(), (Object)RelativePoint.getSouthEastOf((JComponent)this.projectCombobox)));
        }).setRemoveAction(button2 -> {
            List<ExternalSystemTaskActivator.TaskActivationEntry> tasks = this.findSelectedTasks();
            this.myTaskActivator.removeTasks(tasks);
            this.updateTree(null);
        }).setMoveUpAction(button2 -> this.moveAction(-1)).setMoveUpActionUpdater(e -> this.isMoveActionEnabled(-1)).setMoveDownAction(button2 -> this.moveAction(1)).setMoveDownActionUpdater(e -> this.isMoveActionEnabled(1)).setToolbarPosition(ActionToolbarPosition.RIGHT);
        this.tasksPanel.add(decorator.createPanel());
        return this.contentPane;
    }

    private boolean isMoveActionEnabled(int increment) {
        DefaultMutableTreeNode sibling;
        DefaultMutableTreeNode[] selectedNodes = (DefaultMutableTreeNode[])this.myTree.getSelectedNodes(DefaultMutableTreeNode.class, null);
        if (selectedNodes.length == 0) {
            return false;
        }
        boolean enabled = true;
        for (DefaultMutableTreeNode node : selectedNodes) {
            sibling = increment == -1 ? node.getPreviousSibling() : node.getNextSibling();
            enabled = enabled && node.getUserObject() instanceof TaskNode && sibling != null;
        }
        if (!enabled) {
            enabled = true;
            for (DefaultMutableTreeNode node : selectedNodes) {
                sibling = increment == -1 ? node.getPreviousSibling() : node.getNextSibling();
                enabled = enabled && node.getUserObject() instanceof ProjectNode && sibling != null;
            }
        }
        return enabled;
    }

    private void moveAction(int increment) {
        List<ExternalSystemTaskActivator.TaskActivationEntry> tasks = this.findSelectedTasks();
        if (!tasks.isEmpty()) {
            this.myTaskActivator.moveTasks(tasks, increment);
        } else {
            List<String> projectsPaths = this.findSelectedProjects();
            if (projectsPaths.isEmpty()) {
                return;
            }
            ProjectItem item = (ProjectItem)this.projectCombobox.getSelectedItem();
            this.myTaskActivator.moveProjects(this.myProjectSystemId, projectsPaths, item.myProjectSettings.getModules(), increment);
        }
        ConfigureTasksActivationDialog.moveSelectedRows(this.myTree, increment);
    }

    private static void moveSelectedRows(final @NotNull SimpleTree tree, final int direction) {
        Object[] selectionPaths;
        if (tree == null) {
            ConfigureTasksActivationDialog.$$$reportNull$$$0(8);
        }
        if ((selectionPaths = tree.getSelectionPaths()) == null) {
            return;
        }
        ContainerUtil.sort((Object[])selectionPaths, (Comparator)new Comparator<TreePath>(){

            @Override
            public int compare(TreePath o1, TreePath o2) {
                return -direction * this.compare(tree.getRowForPath(o1), tree.getRowForPath(o2));
            }

            @Override
            private int compare(int x, int y) {
                return Integer.compare(x, y);
            }
        });
        for (Object selectionPath : selectionPaths) {
            DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)((TreePath)selectionPath).getLastPathComponent();
            DefaultMutableTreeNode parent = (DefaultMutableTreeNode)treeNode.getParent();
            int idx = parent.getIndex(treeNode);
            ((DefaultTreeModel)tree.getModel()).removeNodeFromParent(treeNode);
            ((DefaultTreeModel)tree.getModel()).insertNodeInto(treeNode, parent, idx + direction);
        }
        tree.addSelectionPaths((TreePath[])selectionPaths);
    }

    @NotNull
    private List<ExternalSystemTaskActivator.TaskActivationEntry> findSelectedTasks() {
        SmartList tasks = new SmartList();
        for (DefaultMutableTreeNode node : (DefaultMutableTreeNode[])this.myTree.getSelectedNodes(DefaultMutableTreeNode.class, null)) {
            tasks.addAll(this.findTasksUnder((SimpleNode[])ContainerUtil.ar((Object[])new MyNode[]{(MyNode)((Object)node.getUserObject())})));
        }
        SmartList smartList = tasks;
        if (smartList == null) {
            ConfigureTasksActivationDialog.$$$reportNull$$$0(9);
        }
        return smartList;
    }

    @NotNull
    private List<ExternalSystemTaskActivator.TaskActivationEntry> findTasksUnder(SimpleNode @NotNull [] nodes) {
        if (nodes == null) {
            ConfigureTasksActivationDialog.$$$reportNull$$$0(10);
        }
        SmartList tasks = new SmartList();
        for (SimpleNode node : nodes) {
            if (node instanceof TaskNode) {
                TaskNode taskNode = (TaskNode)node;
                String taskName = taskNode.getName();
                PhaseNode phaseNode = (PhaseNode)taskNode.getParent();
                tasks.add(new ExternalSystemTaskActivator.TaskActivationEntry(this.myProjectSystemId, phaseNode.myPhase, phaseNode.myProjectPath, taskName));
                continue;
            }
            tasks.addAll(this.findTasksUnder(node.getChildren()));
        }
        SmartList smartList = tasks;
        if (smartList == null) {
            ConfigureTasksActivationDialog.$$$reportNull$$$0(11);
        }
        return smartList;
    }

    private List<String> findSelectedProjects() {
        ArrayList<String> tasks = new ArrayList<String>();
        for (DefaultMutableTreeNode node : (DefaultMutableTreeNode[])this.myTree.getSelectedNodes(DefaultMutableTreeNode.class, null)) {
            if (!(node.getUserObject() instanceof ProjectNode)) continue;
            ProjectNode projectNode = (ProjectNode)((Object)node.getUserObject());
            tasks.add(projectNode.myProjectPath);
        }
        return tasks;
    }

    private MyNode[] buildProjectsNodes(ExternalProjectSettings projectSettings, ExternalProjectsManagerImpl.ExternalProjectsStateProvider stateProvider, RootNode parent) {
        ArrayList<String> paths = new ArrayList<String>(stateProvider.getProjectsTasksActivationMap(this.myProjectSystemId).keySet());
        paths.retainAll(projectSettings.getModules());
        return (MyNode[])ContainerUtil.mapNotNull((Object[])ArrayUtilRt.toStringArray(paths), path -> {
            ProjectNode node = new ProjectNode(parent, stateProvider, projectSettings.getExternalProjectPath(), (String)path);
            return node.getChildren().length > 0 ? node : null;
        }, (Object[])new MyNode[0]);
    }

    private MyNode[] buildProjectPhasesNodes(String projectPath, TaskActivationState tasksActivation, MyNode parent) {
        return (MyNode[])ContainerUtil.mapNotNull((Object[])ExternalSystemTaskActivator.Phase.values(), phase -> tasksActivation.getTasks((ExternalSystemTaskActivator.Phase)((Object)phase)).isEmpty() ? null : new PhaseNode(projectPath, (ExternalSystemTaskActivator.Phase)((Object)phase), tasksActivation, (SimpleNode)parent), (Object[])new MyNode[0]);
    }

    private void updateTree(@Nullable CachingSimpleNode nodeToUpdate) {
        ReferenceOpenHashSet toUpdate = new ReferenceOpenHashSet();
        if (nodeToUpdate == null) {
            for (DefaultMutableTreeNode node : (DefaultMutableTreeNode[])this.myTree.getSelectedNodes(DefaultMutableTreeNode.class, null)) {
                Object userObject = node.getUserObject();
                if (!(userObject instanceof SimpleNode) || !(((SimpleNode)userObject).getParent() instanceof CachingSimpleNode)) continue;
                toUpdate.add((CachingSimpleNode)((SimpleNode)userObject).getParent());
            }
        } else {
            toUpdate.add(nodeToUpdate);
        }
        if (toUpdate.isEmpty()) {
            toUpdate.add(this.myRootNode);
        }
        Element treeStateElement = new Element("root");
        try {
            TreeState.createOn((JTree)this.myTree).writeExternal(treeStateElement);
        }
        catch (WriteExternalException writeExternalException) {
            // empty catch block
        }
        for (CachingSimpleNode node : toUpdate) {
            this.cleanUpEmptyNodes(node);
        }
        TreeState.createFrom((Element)treeStateElement).applyTo((JTree)this.myTree);
    }

    private void cleanUpEmptyNodes(@NotNull CachingSimpleNode node) {
        if (node == null) {
            ConfigureTasksActivationDialog.$$$reportNull$$$0(12);
        }
        node.cleanUpCache();
        this.treeBuilder.addSubtreeToUpdateByElement((Object)node);
        if (node.getChildren().length == 0 && node.getParent() instanceof CachingSimpleNode) {
            this.cleanUpEmptyNodes((CachingSimpleNode)node.getParent());
        }
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel2;
        ComboBox comboBox2;
        JPanel jPanel3;
        JPanel jPanel4;
        this.contentPane = jPanel4 = new JPanel();
        jPanel4.setLayout(new BorderLayout(10, 10));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel5, "North");
        this.projectFieldPanel = jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout(0, 0));
        jPanel5.add((Component)jPanel3, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.projectCombobox = comboBox2 = new ComboBox();
        jPanel3.add((Component)comboBox2, "Center");
        this.tasksPanel = jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(0, 0));
        jPanel5.add((Component)jPanel2, new GridConstraints(1, 0, 2, 1, 0, 3, 3, 3, new Dimension(300, 300), null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.contentPane;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 9: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 9: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "externalSystemId";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectPath";
                break;
            }
            case 3: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/externalSystem/service/task/ui/ConfigureTasksActivationDialog";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodes";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/externalSystem/service/task/ui/ConfigureTasksActivationDialog";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createActions";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "findSelectedTasks";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "findTasksUnder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 9: 
            case 11: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setUpDialog";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createTreeBuilder";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "moveSelectedRows";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "findTasksUnder";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "cleanUpEmptyNodes";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 9: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class TaskNode
    extends MyNode {
        private final String myTaskName;

        TaskNode(String taskName, PhaseNode parent) {
            super((SimpleNode)parent);
            this.myTaskName = taskName;
        }

        protected void update(@NotNull PresentationData presentation2) {
            if (presentation2 == null) {
                TaskNode.$$$reportNull$$$0(0);
            }
            super.update(presentation2);
            presentation2.setIcon(ConfigureTasksActivationDialog.this.uiAware.getTaskIcon());
        }

        public MyNode[] buildChildren() {
            return new MyNode[0];
        }

        public String getName() {
            return this.myTaskName;
        }

        public boolean isAlwaysLeaf() {
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "presentation", "com/intellij/openapi/externalSystem/service/task/ui/ConfigureTasksActivationDialog$TaskNode", "update"));
        }
    }

    private class PhaseNode
    extends MyNode {
        private final ExternalSystemTaskActivator.Phase myPhase;
        private final TaskActivationState myTaskActivationState;
        private final String myProjectPath;

        PhaseNode(String projectPath, ExternalSystemTaskActivator.Phase phase, TaskActivationState taskActivationState, SimpleNode parent) {
            super(parent);
            this.myPhase = phase;
            this.myTaskActivationState = taskActivationState;
            this.myProjectPath = projectPath;
        }

        protected void update(@NotNull PresentationData presentation2) {
            if (presentation2 == null) {
                PhaseNode.$$$reportNull$$$0(0);
            }
            super.update(presentation2);
            presentation2.setIcon(AllIcons.Nodes.ConfigFolder);
        }

        public boolean isAutoExpandNode() {
            return true;
        }

        public MyNode[] buildChildren() {
            return (MyNode[])ContainerUtil.map2Array(this.myTaskActivationState.getTasks(this.myPhase), MyNode.class, taskName -> new TaskNode((String)taskName, this));
        }

        public String getName() {
            return this.myPhase.toString();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "presentation", "com/intellij/openapi/externalSystem/service/task/ui/ConfigureTasksActivationDialog$PhaseNode", "update"));
        }
    }

    private class ProjectNode
    extends MyNode {
        private final ExternalProjectsManagerImpl.ExternalProjectsStateProvider myStateProvider;
        private final String myRootProjectPath;
        private final String myProjectPath;
        private final String myProjectName;

        ProjectNode(RootNode parent, ExternalProjectsManagerImpl.ExternalProjectsStateProvider stateProvider, String rootProjectPath, String projectPath) {
            super((SimpleNode)parent);
            this.myStateProvider = stateProvider;
            this.myProjectPath = projectPath;
            this.myRootProjectPath = rootProjectPath;
            this.myProjectName = ConfigureTasksActivationDialog.this.uiAware.getProjectRepresentationName(this.myProjectPath, this.myRootProjectPath);
        }

        protected void update(@NotNull PresentationData presentation2) {
            if (presentation2 == null) {
                ProjectNode.$$$reportNull$$$0(0);
            }
            super.update(presentation2);
            presentation2.setIcon(AllIcons.Nodes.ConfigFolder);
        }

        public String getName() {
            return this.myProjectName;
        }

        protected MyNode[] buildChildren() {
            TaskActivationState tasksActivation = this.myStateProvider.getTasksActivation(ConfigureTasksActivationDialog.this.myProjectSystemId, this.myProjectPath);
            return ConfigureTasksActivationDialog.this.buildProjectPhasesNodes(this.myProjectPath, tasksActivation, this);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "presentation", "com/intellij/openapi/externalSystem/service/task/ui/ConfigureTasksActivationDialog$ProjectNode", "update"));
        }
    }

    private class RootNode
    extends MyNode {
        private final ExternalProjectsManagerImpl.ExternalProjectsStateProvider myStateProvider;

        RootNode() {
            super(ConfigureTasksActivationDialog.this.myProject, null);
            this.myStateProvider = ExternalProjectsManagerImpl.getInstance(ConfigureTasksActivationDialog.this.myProject).getStateProvider();
        }

        public boolean isAutoExpandNode() {
            return true;
        }

        protected MyNode[] buildChildren() {
            ProjectItem item = (ProjectItem)ConfigureTasksActivationDialog.this.projectCombobox.getSelectedItem();
            if (item == null) {
                return new MyNode[0];
            }
            if (item.myProjectSettings.getModules().isEmpty() || item.myProjectSettings.getModules().size() == 1) {
                TaskActivationState tasksActivation = this.myStateProvider.getTasksActivation(ConfigureTasksActivationDialog.this.myProjectSystemId, item.myProjectSettings.getExternalProjectPath());
                return ConfigureTasksActivationDialog.this.buildProjectPhasesNodes(item.myProjectSettings.getExternalProjectPath(), tasksActivation, this);
            }
            return ConfigureTasksActivationDialog.this.buildProjectsNodes(item.myProjectSettings, this.myStateProvider, this);
        }
    }

    private static abstract class MyNode
    extends CachingSimpleNode {
        protected MyNode(SimpleNode aParent) {
            super(aParent);
        }

        MyNode(Project aProject, @Nullable NodeDescriptor aParentDescriptor) {
            super(aProject, aParentDescriptor);
        }
    }

    private class ChooseProjectStep
    extends BaseListPopupStep<ProjectPopupItem> {
        protected ChooseProjectStep(List<? extends ProjectPopupItem> values2) {
            super(ExternalSystemBundle.message((String)"popup.title.choose.project", (Object[])new Object[0]), values2);
        }

        public PopupStep onChosen(final ProjectPopupItem projectPopupItem, boolean finalChoice) {
            return new BaseListPopupStep<ExternalSystemTaskActivator.Phase>(ExternalSystemBundle.message((String)"popup.title.choose.activation.phase", (Object[])new Object[0]), ExternalSystemTaskActivator.Phase.values()){

                public PopupStep onChosen(final ExternalSystemTaskActivator.Phase selectedPhase, boolean finalChoice) {
                    Map<String, TaskActivationState> activationMap = ExternalProjectsManagerImpl.getInstance(ConfigureTasksActivationDialog.this.myProject).getStateProvider().getProjectsTasksActivationMap(ConfigureTasksActivationDialog.this.myProjectSystemId);
                    final String projectPath = projectPopupItem.myModuleData.getLinkedExternalProjectPath();
                    List<String> tasks = activationMap.get(projectPath).getTasks(selectedPhase);
                    ArrayList<String> tasksToSuggest = new ArrayList<String>(projectPopupItem.myTasks);
                    tasksToSuggest.removeAll(tasks);
                    return new BaseListPopupStep<String>(ExternalSystemBundle.message((String)"popup.title.choose.task", (Object[])new Object[0]), tasksToSuggest){

                        public PopupStep onChosen(String taskName, boolean finalChoice) {
                            return this.doFinalStep(() -> {
                                ConfigureTasksActivationDialog.this.myTaskActivator.addTask(new ExternalSystemTaskActivator.TaskActivationEntry(ConfigureTasksActivationDialog.this.myProjectSystemId, selectedPhase, projectPath, taskName));
                                ConfigureTasksActivationDialog.this.updateTree(ConfigureTasksActivationDialog.this.myRootNode);
                            });
                        }
                    };
                }

                public boolean hasSubstep(ExternalSystemTaskActivator.Phase phase) {
                    return true;
                }
            };
        }

        public boolean hasSubstep(ProjectPopupItem selectedValue) {
            return true;
        }
    }

    private static class ProjectPopupItem {
        ModuleData myModuleData;
        List<String> myTasks;

        ProjectPopupItem(ModuleData moduleData, List<String> tasks) {
            this.myModuleData = moduleData;
            this.myTasks = tasks;
        }

        public String toString() {
            return this.myModuleData.getId();
        }
    }

    private static class ProjectItem {
        private static final int MAX_LENGTH = 80;
        @NotNull
        String projectName;
        @NotNull
        ExternalProjectSettings myProjectSettings;

        ProjectItem(@NotNull String projectName, @NotNull ExternalProjectSettings projectPath) {
            if (projectName == null) {
                ProjectItem.$$$reportNull$$$0(0);
            }
            if (projectPath == null) {
                ProjectItem.$$$reportNull$$$0(1);
            }
            this.projectName = projectName;
            this.myProjectSettings = projectPath;
        }

        public String toString() {
            return this.projectName + " (" + ProjectItem.truncate(this.myProjectSettings.getExternalProjectPath()) + ")";
        }

        @NotNull
        private static String truncate(@NotNull String s) {
            if (s == null) {
                ProjectItem.$$$reportNull$$$0(2);
            }
            String string = s.length() < 80 ? s : s.substring(0, 40) + "..." + s.substring(s.length() - 40 - 3);
            if (string == null) {
                ProjectItem.$$$reportNull$$$0(3);
            }
            return string;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ProjectItem)) {
                return false;
            }
            ProjectItem item = (ProjectItem)o;
            return this.myProjectSettings.equals((Object)item.myProjectSettings);
        }

        public int hashCode() {
            return this.myProjectSettings.hashCode();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "projectName";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "projectPath";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "s";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/externalSystem/service/task/ui/ConfigureTasksActivationDialog$ProjectItem";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/externalSystem/service/task/ui/ConfigureTasksActivationDialog$ProjectItem";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "truncate";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "truncate";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

