/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.keymap.impl.ui;

import com.intellij.DynamicBundle;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.ex.QuickList;
import com.intellij.openapi.actionSystem.ex.QuickListsManager;
import com.intellij.openapi.keymap.KeyMapBundle;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.keymap.impl.ui.ActionsTree;
import com.intellij.openapi.keymap.impl.ui.ChooseActionsDialog;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.CollectionListModel;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.components.JBList;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.List;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class QuickListPanel {
    private final CollectionListModel<Object> actionsModel;
    private JPanel myPanel;
    private final JBList myActionsList;
    JTextField myName;
    private JTextField myDescription;
    private JPanel myListPanel;
    QuickList item;

    QuickListPanel(final @NotNull CollectionListModel<QuickList> model) {
        if (model == null) {
            QuickListPanel.$$$reportNull$$$0(0);
        }
        Object[] objectArray = new Object[]{};
        this.$$$setupUI$$$();
        this.actionsModel = new CollectionListModel(objectArray);
        this.myActionsList = new JBList(this.actionsModel);
        this.myActionsList.setCellRenderer((ListCellRenderer)new MyListCellRenderer());
        this.myActionsList.getEmptyText().setText(KeyMapBundle.message((String)"no.actions", (Object[])new Object[0]));
        this.myActionsList.setEnabled(true);
        this.myListPanel.add((Component)ToolbarDecorator.createDecorator((JList)this.myActionsList).setAddAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button2) {
                List items = model.getItems();
                ChooseActionsDialog dialog2 = new ChooseActionsDialog((Component)QuickListPanel.this.myActionsList, KeymapManager.getInstance().getActiveKeymap(), items.toArray(new QuickList[0]));
                if (dialog2.showAndGet()) {
                    String[] ids;
                    for (String id2 : ids = dialog2.getTreeSelectedActionIds()) {
                        QuickListPanel.this.includeActionId(id2);
                    }
                    List list2 = QuickListPanel.this.actionsModel.getItems();
                    int size = list2.size();
                    ListSelectionModel selectionModel = QuickListPanel.this.myActionsList.getSelectionModel();
                    if (size > 0) {
                        selectionModel.removeIndexInterval(0, size - 1);
                    }
                    for (String id1 : ids) {
                        int idx = list2.lastIndexOf(id1);
                        if (idx < 0) continue;
                        selectionModel.addSelectionInterval(idx, idx);
                    }
                }
            }
        }).addExtraAction(new AnActionButton(KeyMapBundle.messagePointer((String)"action.AnActionButton.text.add.separator", (Object[])new Object[0]), AllIcons.General.SeparatorH){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                QuickListPanel.this.actionsModel.add((Object)"QuickList.$Separator$");
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/keymap/impl/ui/QuickListPanel$1", "actionPerformed"));
            }
        }).setButtonComparator(new String[]{"Add", "Add Separator", "Remove", "Up", "Down"}).createPanel(), "Center");
    }

    public void apply() {
        String[] ids;
        if (this.item == null) {
            return;
        }
        this.item.setName(this.myName.getText().trim());
        this.item.setDescription(this.myDescription.getText().trim());
        ListModel model = this.myActionsList.getModel();
        int size = model.getSize();
        if (size == 0) {
            ids = ArrayUtilRt.EMPTY_STRING_ARRAY;
        } else {
            ids = new String[size];
            for (int i2 = 0; i2 < size; ++i2) {
                ids[i2] = (String)model.getElementAt(i2);
            }
        }
        this.item.setActionIds(ids);
    }

    public void setItem(@Nullable QuickList item) {
        this.apply();
        this.item = item;
        if (item == null) {
            return;
        }
        this.myName.setText(item.getName());
        this.myName.setEnabled(QuickListsManager.getInstance().getSchemeManager().isMetadataEditable(item));
        this.myDescription.setText(item.getDescription());
        this.actionsModel.removeAll();
        for (String id2 : item.getActionIds()) {
            this.includeActionId(id2);
        }
    }

    private void includeActionId(@NotNull String id2) {
        if (id2 == null) {
            QuickListPanel.$$$reportNull$$$0(1);
        }
        if ("QuickList.$Separator$".equals(id2) || this.actionsModel.getElementIndex((Object)id2) == -1) {
            this.actionsModel.add((Object)id2);
        }
    }

    public JPanel getPanel() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel2;
        JTextField jTextField;
        JTextField jTextField2;
        JPanel jPanel3;
        this.myPanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel4, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 0, null, null, null));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, DynamicBundle.getBundle((String)"messages/KeyMapBundle", QuickListPanel.class).getString("quick.list.panel.display.name.label"));
        jPanel4.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myDescription = jTextField2 = new JTextField();
        jPanel4.add((Component)jTextField2, new GridConstraints(1, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myName = jTextField = new JTextField();
        jPanel4.add((Component)jTextField, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, DynamicBundle.getBundle((String)"messages/KeyMapBundle", QuickListPanel.class).getString("quick.list.panel.description.label"));
        jPanel4.add((Component)jLabel2, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myListPanel = jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(0, 0));
        jPanel3.add((Component)jPanel2, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jLabel.setLabelFor(jTextField);
        jLabel2.setLabelFor(jTextField2);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int j = 0; j < string.length(); ++j) {
            if (string.charAt(j) == '&') {
                if (++j == string.length()) break;
                if (!bl && string.charAt(j) != '&') {
                    bl = true;
                    c = string.charAt(j);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(j));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/keymap/impl/ui/QuickListPanel";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "includeActionId";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class MyListCellRenderer
    extends DefaultListCellRenderer {
        private MyListCellRenderer() {
        }

        @Override
        @NotNull
        public Component getListCellRendererComponent(@NotNull JList list2, Object value2, int index, boolean isSelected, boolean cellHasFocus) {
            if (list2 == null) {
                MyListCellRenderer.$$$reportNull$$$0(0);
            }
            super.getListCellRendererComponent((JList<?>)list2, value2, index, isSelected, cellHasFocus);
            Icon icon2 = null;
            String actionId = (String)value2;
            if ("QuickList.$Separator$".equals(actionId)) {
                this.setText("-------------");
            } else {
                Icon actionIcon;
                AnAction action2 = ActionManager.getInstance().getAction(actionId);
                this.setText(action2 != null ? action2.getTemplatePresentation().getText() : actionId);
                if (action2 != null && (actionIcon = action2.getTemplatePresentation().getIcon()) != null) {
                    icon2 = actionIcon;
                }
                if (actionId.startsWith("QuickList.")) {
                    icon2 = null;
                }
                this.setIcon(ActionsTree.getEvenIcon(icon2));
            }
            MyListCellRenderer myListCellRenderer = this;
            if (myListCellRenderer == null) {
                MyListCellRenderer.$$$reportNull$$$0(1);
            }
            return myListCellRenderer;
        }

        @Override
        public Dimension getPreferredSize() {
            return UIUtil.updateListRowHeight((Dimension)super.getPreferredSize());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "list";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/keymap/impl/ui/QuickListPanel$MyListCellRenderer";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/keymap/impl/ui/QuickListPanel$MyListCellRenderer";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getListCellRendererComponent";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getListCellRendererComponent";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

