/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.project;

import com.intellij.internal.statistic.IdeActivity;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbServiceMergingTaskQueue;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.ex.ProgressIndicatorEx;
import com.intellij.util.io.storage.HeavyProcessLatch;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;

final class DumbServiceGuiTaskQueue {
    private static final Logger LOG = Logger.getInstance(DumbServiceGuiTaskQueue.class);
    private final Project myProject;
    private final DumbServiceMergingTaskQueue myTaskQueue;

    DumbServiceGuiTaskQueue(@NotNull Project project, @NotNull DumbServiceMergingTaskQueue queue) {
        if (project == null) {
            DumbServiceGuiTaskQueue.$$$reportNull$$$0(0);
        }
        if (queue == null) {
            DumbServiceGuiTaskQueue.$$$reportNull$$$0(1);
        }
        this.myProject = project;
        this.myTaskQueue = queue;
    }

    void processTasksWithProgress(@NotNull Consumer<ProgressIndicatorEx> bindProgress, @NotNull IdeActivity activity) {
        if (bindProgress == null) {
            DumbServiceGuiTaskQueue.$$$reportNull$$$0(2);
        }
        if (activity == null) {
            DumbServiceGuiTaskQueue.$$$reportNull$$$0(3);
        }
        while (!this.myProject.isDisposed()) {
            DumbServiceMergingTaskQueue.QueuedDumbModeTask pair = this.myTaskQueue.extractNextTask();
            try {
                if (pair == null) break;
                bindProgress.accept(pair.getIndicator());
                pair.registerStageStarted(activity);
                AccessToken ignored = HeavyProcessLatch.INSTANCE.processStarted("Performing indexing tasks", HeavyProcessLatch.Type.Indexing);
                try {
                    DumbServiceGuiTaskQueue.runSingleTask(pair);
                }
                finally {
                    if (ignored == null) continue;
                    ignored.close();
                }
            }
            finally {
                if (pair == null) continue;
                pair.close();
            }
        }
    }

    private static void runSingleTask(@NotNull DumbServiceMergingTaskQueue.QueuedDumbModeTask task2) {
        if (task2 == null) {
            DumbServiceGuiTaskQueue.$$$reportNull$$$0(4);
        }
        if (ApplicationManager.getApplication().isInternal()) {
            LOG.info("Running dumb mode task: " + task2.getInfoString());
        }
        ProgressManager.getInstance().runProcess(() -> {
            try {
                task2.executeTask();
            }
            catch (ProcessCanceledException processCanceledException) {
            }
            catch (Throwable unexpected) {
                LOG.error("Failed to execute task " + task2 + ". " + unexpected.getMessage(), unexpected);
            }
        }, (ProgressIndicator)task2.getIndicator());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "queue";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bindProgress";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "activity";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/project/DumbServiceGuiTaskQueue";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "processTasksWithProgress";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "runSingleTask";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

