/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.newvfs;

import com.intellij.diagnostic.PerformanceWatcher;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.application.impl.ApplicationImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.util.ProgressWindow;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.AsyncFileListener;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.ex.VirtualFileManagerEx;
import com.intellij.openapi.vfs.impl.local.LocalFileSystemImpl;
import com.intellij.openapi.vfs.newvfs.ArchiveFileSystem;
import com.intellij.openapi.vfs.newvfs.AsyncEventSupport;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.intellij.openapi.vfs.newvfs.RefreshQueue;
import com.intellij.openapi.vfs.newvfs.RefreshQueueImpl;
import com.intellij.openapi.vfs.newvfs.RefreshSession;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.persistent.RefreshWorker;
import com.intellij.util.Consumer;
import com.intellij.util.SystemProperties;
import com.intellij.util.concurrency.Semaphore;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class RefreshSessionImpl
extends RefreshSession {
    private static final Logger LOG = Logger.getInstance(RefreshSession.class);
    private static final int REFRESH_SESSION_DURATION_REPORT_THRESHOLD_SECONDS = SystemProperties.getIntProperty((String)"refresh.session.duration.report.threshold.seconds", (int)-1);
    private static final AtomicLong ID_COUNTER = new AtomicLong(0L);
    private final long myId;
    private final boolean myIsAsync;
    private final boolean myIsRecursive;
    private final Runnable myFinishRunnable;
    private final Throwable myStartTrace;
    private final Semaphore mySemaphore;
    private List<VirtualFile> myWorkQueue;
    private final List<VFileEvent> myEvents;
    private volatile RefreshWorker myWorker;
    private volatile boolean myCancelled;
    private final ModalityState myModality;
    private boolean myLaunched;

    RefreshSessionImpl(boolean async, boolean recursive, @Nullable Runnable finishRunnable, @NotNull ModalityState modality) {
        if (modality == null) {
            RefreshSessionImpl.$$$reportNull$$$0(0);
        }
        this.myId = ID_COUNTER.incrementAndGet();
        this.mySemaphore = new Semaphore();
        this.myWorkQueue = new ArrayList<VirtualFile>();
        this.myEvents = new ArrayList<VFileEvent>();
        this.myIsAsync = async;
        this.myIsRecursive = recursive;
        this.myFinishRunnable = finishRunnable;
        this.myModality = modality;
        TransactionGuard.getInstance().assertWriteSafeContext(modality);
        this.myStartTrace = this.rememberStartTrace();
    }

    private Throwable rememberStartTrace() {
        boolean trace = ApplicationManager.getApplication().isUnitTestMode() && (this.myIsAsync || !ApplicationManager.getApplication().isDispatchThread());
        return trace ? new Throwable() : null;
    }

    RefreshSessionImpl(@NotNull List<? extends VFileEvent> events) {
        if (events == null) {
            RefreshSessionImpl.$$$reportNull$$$0(1);
        }
        this(false, false, null, ModalityState.defaultModalityState());
        this.myEvents.addAll(events);
    }

    public long getId() {
        return this.myId;
    }

    public void addAllFiles(@NotNull Collection<? extends VirtualFile> files2) {
        if (files2 == null) {
            RefreshSessionImpl.$$$reportNull$$$0(2);
        }
        for (VirtualFile virtualFile : files2) {
            if (virtualFile == null) {
                LOG.error("null passed among " + files2);
                continue;
            }
            this.addFile(virtualFile);
        }
    }

    public void addFile(@NotNull VirtualFile file2) {
        if (file2 == null) {
            RefreshSessionImpl.$$$reportNull$$$0(3);
        }
        if (this.myLaunched) {
            throw new IllegalStateException("Adding files is only allowed before launch");
        }
        if (file2 instanceof NewVirtualFile) {
            this.myWorkQueue.add(file2);
        } else {
            LOG.debug("skipped: " + file2 + " / " + file2.getClass());
        }
    }

    public boolean isAsynchronous() {
        return this.myIsAsync;
    }

    public void launch() {
        if (this.myLaunched) {
            throw new IllegalStateException("launch() can be called only once");
        }
        this.myLaunched = true;
        this.mySemaphore.down();
        ((RefreshQueueImpl)RefreshQueue.getInstance()).execute(this);
    }

    void scan() {
        boolean forceRefresh;
        List<VirtualFile> workQueue = this.myWorkQueue;
        this.myWorkQueue = new ArrayList<VirtualFile>();
        boolean bl = forceRefresh = !this.myIsRecursive && !this.myIsAsync;
        if (!workQueue.isEmpty()) {
            LocalFileSystem fs = LocalFileSystem.getInstance();
            if (!forceRefresh && fs instanceof LocalFileSystemImpl) {
                ((LocalFileSystemImpl)fs).markSuspiciousFilesDirty(workQueue);
            }
            if (LOG.isTraceEnabled()) {
                LOG.trace("scanning " + workQueue);
            }
            long t = System.currentTimeMillis();
            PerformanceWatcher.Snapshot snapshot = PerformanceWatcher.takeSnapshot();
            int count = 0;
            block0: do {
                if (LOG.isTraceEnabled()) {
                    LOG.trace("try=" + count);
                }
                for (VirtualFile file2 : workQueue) {
                    RefreshWorker worker;
                    if (this.myCancelled) break block0;
                    NewVirtualFile nvf = (NewVirtualFile)file2;
                    if (forceRefresh) {
                        nvf.markDirty();
                    } else if (!nvf.isDirty()) continue;
                    this.myWorker = worker = new RefreshWorker(nvf, this.myIsRecursive);
                    worker.scan();
                    this.myEvents.addAll(worker.getEvents());
                }
                ++count;
                if (!LOG.isTraceEnabled()) continue;
                LOG.trace("events=" + this.myEvents.size());
            } while (!this.myCancelled && this.myIsRecursive && count < 3 && ContainerUtil.exists(workQueue, f -> ((NewVirtualFile)f).isDirty()));
            t = System.currentTimeMillis() - t;
            if (LOG.isTraceEnabled()) {
                LOG.trace((this.myCancelled ? "cancelled, " : "done, ") + t + " ms, tries " + count + ", events " + this.myEvents);
            } else if (REFRESH_SESSION_DURATION_REPORT_THRESHOLD_SECONDS > 0 && t > (long)REFRESH_SESSION_DURATION_REPORT_THRESHOLD_SECONDS * 1000L) {
                snapshot.logResponsivenessSinceCreation(String.format("Refresh session (queue size: %s, root types: %s, result: %s, tries: %s, events: %d)", workQueue.size(), workQueue.stream().collect(Collectors.groupingBy(f -> !f.isDirectory() ? "file" : (f.getFileSystem() instanceof ArchiveFileSystem ? "arc" : "dir"), Collectors.counting())), this.myCancelled ? "cancelled" : "done", count, this.myEvents.size()));
            }
        }
        this.myWorker = null;
    }

    void cancel() {
        this.myCancelled = true;
        RefreshWorker worker = this.myWorker;
        if (worker != null) {
            worker.cancel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fireEvents(@NotNull List<? extends VFileEvent> events, @Nullable List<? extends AsyncFileListener.ChangeApplier> appliers) {
        if (events == null) {
            RefreshSessionImpl.$$$reportNull$$$0(4);
        }
        try {
            ApplicationImpl app = (ApplicationImpl)ApplicationManager.getApplication();
            if (!(this.myFinishRunnable == null && events.isEmpty() || app.isDisposed())) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("events are about to fire: " + events);
                }
                WriteAction.run(() -> app.runWriteActionWithNonCancellableProgressInDispatchThread(IdeBundle.message((String)"progress.title.file.system.synchronization", (Object[])new Object[0]), null, null, (Consumer<? super ProgressIndicator>)((Consumer)indicator -> {
                    indicator.setText(IdeBundle.message((String)"progress.text.processing.detected.file.changes", (Object[])new Object[]{events.size()}));
                    int progressThresholdMillis = 5000;
                    ((ProgressWindow)indicator).setDelayInMillis(progressThresholdMillis);
                    long start2 = System.currentTimeMillis();
                    this.fireEventsInWriteAction(events, appliers);
                    long elapsed = System.currentTimeMillis() - start2;
                    if (elapsed > (long)progressThresholdMillis) {
                        LOG.warn("Long VFS change processing (" + elapsed + "ms, " + events.size() + " events): " + StringUtil.trimLog((String)events.toString(), (int)10000));
                    }
                })));
            }
        }
        finally {
            this.mySemaphore.up();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireEventsInWriteAction(@NotNull List<? extends VFileEvent> events, @Nullable List<? extends AsyncFileListener.ChangeApplier> appliers) {
        if (events == null) {
            RefreshSessionImpl.$$$reportNull$$$0(5);
        }
        VirtualFileManagerEx manager = (VirtualFileManagerEx)VirtualFileManager.getInstance();
        manager.fireBeforeRefreshStart(this.myIsAsync);
        try {
            AsyncEventSupport.processEventsFromRefresh(events, appliers);
        }
        catch (AssertionError e) {
            if ("PSI/document/model changes are not allowed during highlighting".equals(((Throwable)((Object)e)).getMessage())) {
                throw new AssertionError("VFS changes are not allowed during highlighting", this.myStartTrace);
            }
            throw e;
        }
        finally {
            try {
                manager.fireAfterRefreshFinish(this.myIsAsync);
            }
            finally {
                if (this.myFinishRunnable != null) {
                    this.myFinishRunnable.run();
                }
            }
        }
    }

    void waitFor() {
        this.mySemaphore.waitFor();
    }

    @NotNull
    ModalityState getModality() {
        ModalityState modalityState = this.myModality;
        if (modalityState == null) {
            RefreshSessionImpl.$$$reportNull$$$0(6);
        }
        return modalityState;
    }

    @NotNull
    List<? extends VFileEvent> getEvents() {
        return new ArrayList<VFileEvent>(new LinkedHashSet<VFileEvent>(this.myEvents));
    }

    public String toString() {
        return this.myWorkQueue.size() <= 1 ? "" : this.myWorkQueue.size() + " roots in the queue.";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modality";
                break;
            }
            case 1: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "events";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vfs/newvfs/RefreshSessionImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vfs/newvfs/RefreshSessionImpl";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getModality";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addAllFiles";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addFile";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "fireEvents";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "fireEventsInWriteAction";
                break;
            }
            case 6: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

