/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profile.codeInspection.ui;

import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.ex.Descriptor;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.ex.ComboBoxAction;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.profile.codeInspection.ui.ScopesOrderDialog;
import com.intellij.psi.search.scope.NonProjectFilesScope;
import com.intellij.psi.search.scope.packageSet.CustomScopesProviderEx;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import com.intellij.psi.search.scope.packageSet.NamedScopesHolder;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public abstract class ScopesChooser
extends ComboBoxAction
implements DumbAware {
    public static final String TITLE = "Select a Scope to Change Its Settings";
    private final List<Descriptor> myDefaultDescriptors;
    @NotNull
    private final InspectionProfileImpl myInspectionProfile;
    private final Project myProject;
    private final Set<String> myExcludedScopeNames;

    public ScopesChooser(List<Descriptor> defaultDescriptors, @NotNull InspectionProfileImpl inspectionProfile, @NotNull Project project, String[] excludedScopeNames) {
        if (inspectionProfile == null) {
            ScopesChooser.$$$reportNull$$$0(0);
        }
        if (project == null) {
            ScopesChooser.$$$reportNull$$$0(1);
        }
        this.myDefaultDescriptors = defaultDescriptors;
        this.myInspectionProfile = inspectionProfile;
        this.myProject = project;
        this.myExcludedScopeNames = excludedScopeNames == null ? Collections.emptySet() : ContainerUtil.newHashSet((Object[])excludedScopeNames);
        this.setPopupTitle(TITLE);
        this.getTemplatePresentation().setText(InspectionsBundle.messagePointer((String)"action.presentation.ScopesChooser.text", (Object[])new Object[0]));
    }

    @NotNull
    public DefaultActionGroup createPopupActionGroup(final JComponent component2) {
        DefaultActionGroup group = new DefaultActionGroup();
        ArrayList<NamedScope> predefinedScopes = new ArrayList<NamedScope>();
        ArrayList<NamedScope> customScopes = new ArrayList<NamedScope>();
        for (NamedScopesHolder holder : NamedScopesHolder.getAllNamedScopeHolders((Project)this.myProject)) {
            Collections.addAll(customScopes, holder.getEditableScopes());
            predefinedScopes.addAll(holder.getPredefinedScopes());
        }
        predefinedScopes.remove(CustomScopesProviderEx.getAllScope());
        for (NamedScope predefinedScope : predefinedScopes) {
            if (!(predefinedScope instanceof NonProjectFilesScope)) continue;
            predefinedScopes.remove(predefinedScope);
            break;
        }
        this.fillActionGroup(group, predefinedScopes, this.myDefaultDescriptors, this.myInspectionProfile, this.myExcludedScopeNames);
        group.addSeparator();
        this.fillActionGroup(group, customScopes, this.myDefaultDescriptors, this.myInspectionProfile, this.myExcludedScopeNames);
        group.addSeparator();
        group.add((AnAction)new DumbAwareAction(IdeBundle.messagePointer((String)"action.Anonymous.text.edit.scopes.order", (Object[])new Object[0])){

            public void actionPerformed(@NotNull AnActionEvent e) {
                ScopesOrderDialog dlg;
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((dlg = new ScopesOrderDialog(component2, ScopesChooser.this.myInspectionProfile, ScopesChooser.this.myProject)).showAndGet()) {
                    ScopesChooser.this.onScopesOrderChanged();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/profile/codeInspection/ui/ScopesChooser$1", "actionPerformed"));
            }
        });
        DefaultActionGroup defaultActionGroup = group;
        if (defaultActionGroup == null) {
            ScopesChooser.$$$reportNull$$$0(2);
        }
        return defaultActionGroup;
    }

    protected abstract void onScopesOrderChanged();

    protected abstract void onScopeAdded(@NotNull String var1);

    private void fillActionGroup(DefaultActionGroup group, List<NamedScope> scopes, final List<Descriptor> defaultDescriptors, final InspectionProfileImpl inspectionProfile, Set<String> excludedScopeNames) {
        for (final NamedScope scope : scopes) {
            final String scopeName = scope.getName();
            if (excludedScopeNames.contains(scopeName)) continue;
            group.add((AnAction)new DumbAwareAction(scopeName){

                public void actionPerformed(@NotNull AnActionEvent e) {
                    if (e == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    for (Descriptor defaultDescriptor : defaultDescriptors) {
                        InspectionToolWrapper wrapper2 = defaultDescriptor.getToolWrapper().createCopy();
                        wrapper2.getTool().readSettings(Descriptor.createConfigElement(defaultDescriptor.getToolWrapper()));
                        inspectionProfile.addScope(wrapper2, scope, defaultDescriptor.getLevel(), true, e.getProject());
                    }
                    ScopesChooser.this.onScopeAdded(scopeName);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/profile/codeInspection/ui/ScopesChooser$2", "actionPerformed"));
                }
            });
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inspectionProfile";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/profile/codeInspection/ui/ScopesChooser";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/profile/codeInspection/ui/ScopesChooser";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createPopupActionGroup";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

