/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.reference.impl.providers;

import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileInfoManager;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceCompletion;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceResolver;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.CommonProcessors;
import com.intellij.util.FilteringProcessor;
import com.intellij.util.Processor;
import gnu.trove.THashSet;
import gnu.trove.TObjectHashingStrategy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class FileReferenceCompletionImpl
extends FileReferenceCompletion {
    private static final TObjectHashingStrategy<PsiElement> VARIANTS_HASHING_STRATEGY = new TObjectHashingStrategy<PsiElement>(){

        public int computeHashCode(PsiElement object) {
            String name;
            if (object instanceof PsiNamedElement && (name = ((PsiNamedElement)object).getName()) != null) {
                return name.hashCode();
            }
            return object.hashCode();
        }

        public boolean equals(PsiElement o1, PsiElement o2) {
            if (o1 instanceof PsiNamedElement && o2 instanceof PsiNamedElement) {
                return Objects.equals(((PsiNamedElement)o1).getName(), ((PsiNamedElement)o2).getName());
            }
            return o1.equals(o2);
        }
    };

    @Override
    public Object @NotNull [] getFileReferenceCompletionVariants(final FileReference reference2) {
        int i2;
        String s = reference2.getText();
        if (s != null && s.equals("/")) {
            if (ArrayUtilRt.EMPTY_OBJECT_ARRAY == null) {
                FileReferenceCompletionImpl.$$$reportNull$$$0(0);
            }
            return ArrayUtilRt.EMPTY_OBJECT_ARRAY;
        }
        final CommonProcessors.CollectUniquesProcessor collector = new CommonProcessors.CollectUniquesProcessor();
        PsiElementProcessor<PsiFileSystemItem> processor2 = new PsiElementProcessor<PsiFileSystemItem>(){

            public boolean execute(@NotNull PsiFileSystemItem fileSystemItem) {
                if (fileSystemItem == null) {
                    2.$$$reportNull$$$0(0);
                }
                return new FilteringProcessor(reference2.getFileReferenceSet().getReferenceCompletionFilter(), (Processor)collector).process((Object)FileReference.getOriginalFile(fileSystemItem));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileSystemItem", "com/intellij/psi/impl/source/resolve/reference/impl/providers/FileReferenceCompletionImpl$2", "execute"));
            }
        };
        ArrayList<Object> additionalItems = new ArrayList<Object>();
        for (PsiFileSystemItem context : reference2.getContexts()) {
            for (PsiElement child2 : context.getChildren()) {
                if (!(child2 instanceof PsiFileSystemItem)) continue;
                processor2.execute((PsiElement)((PsiFileSystemItem)child2));
            }
            if (!(context instanceof FileReferenceResolver)) continue;
            additionalItems.addAll(((FileReferenceResolver)context).getVariants(reference2));
        }
        Object[] types = reference2.getFileReferenceSet().getSuitableFileTypes();
        THashSet set = new THashSet(collector.getResults(), VARIANTS_HASHING_STRATEGY);
        PsiElement[] candidates = PsiUtilCore.toPsiElementArray((Collection)set);
        Object[] variants = new Object[candidates.length + additionalItems.size()];
        for (i2 = 0; i2 < candidates.length; ++i2) {
            PsiElement candidate = candidates[i2];
            Object item = reference2.createLookupItem(candidate);
            if (item == null) {
                item = FileInfoManager.getFileLookupItem(candidate);
            }
            if (candidate instanceof PsiFile && item instanceof LookupElement && types.length > 0 && ArrayUtil.contains((Object)((PsiFile)candidate).getFileType(), (Object[])types)) {
                item = PrioritizedLookupElement.withPriority((LookupElement)((LookupElement)item), (double)Double.MAX_VALUE);
            }
            variants[i2] = item;
        }
        for (i2 = 0; i2 < additionalItems.size(); ++i2) {
            variants[i2 + candidates.length] = additionalItems.get(i2);
        }
        if (!reference2.getFileReferenceSet().isUrlEncoded()) {
            if (variants == null) {
                FileReferenceCompletionImpl.$$$reportNull$$$0(1);
            }
            return variants;
        }
        ArrayList<Object> encodedVariants = new ArrayList<Object>(variants.length + additionalItems.size());
        for (int i3 = 0; i3 < candidates.length; ++i3) {
            PsiNamedElement psiElement;
            String name;
            String encoded;
            PsiElement element2 = candidates[i3];
            if (!(element2 instanceof PsiNamedElement) || (encoded = reference2.encode(name = (psiElement = (PsiNamedElement)element2).getName(), (PsiElement)psiElement)) == null) continue;
            if (!encoded.equals(name)) {
                Icon icon2 = psiElement.getIcon(3);
                LookupElementBuilder item = FileInfoManager.getFileLookupItem(candidates[i3], encoded, icon2);
                encodedVariants.add(item.withTailText(" (" + name + ")"));
                continue;
            }
            encodedVariants.add(variants[i3]);
        }
        encodedVariants.addAll(additionalItems);
        Object[] objectArray = ArrayUtil.toObjectArray(encodedVariants);
        if (objectArray == null) {
            FileReferenceCompletionImpl.$$$reportNull$$$0(2);
        }
        return objectArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/reference/impl/providers/FileReferenceCompletionImpl", "getFileReferenceCompletionVariants"));
    }
}

