/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileFilter;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.openapi.vfs.newvfs.impl.VirtualFileSystemEntry;
import com.intellij.psi.search.FileTypeIndex;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.FileBasedIndexImpl;
import com.intellij.util.indexing.FileBasedIndexInfrastructureExtension;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.FileIndexingState;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.IndexedFileImpl;
import com.intellij.util.indexing.IndexedFileWrapper;
import com.intellij.util.indexing.IndexingStamp;
import com.intellij.util.indexing.StorageException;
import com.intellij.util.indexing.UpdatableIndex;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

class UnindexedFilesFinder
implements VirtualFileFilter {
    private static final Logger LOG = Logger.getInstance(UnindexedFilesFinder.class);
    private final Project myProject;
    private final boolean myDoTraceForFilesToBeIndexed;
    private final FileBasedIndexImpl myFileBasedIndex;
    private final UpdatableIndex<FileType, Void, FileContent> myFileTypeIndex;
    private final Collection<FileBasedIndexInfrastructureExtension.FileIndexingStatusProcessor> myStateProcessors;
    private final boolean myRunExtensionsForFilesMarkedAsIndexed;
    private final boolean myShouldProcessUpToDateFiles;

    UnindexedFilesFinder(@NotNull Project project, @NotNull FileBasedIndexImpl fileBasedIndex, boolean runExtensionsForFilesMarkedAsIndexed) {
        if (project == null) {
            UnindexedFilesFinder.$$$reportNull$$$0(0);
        }
        if (fileBasedIndex == null) {
            UnindexedFilesFinder.$$$reportNull$$$0(1);
        }
        this.myDoTraceForFilesToBeIndexed = FileBasedIndexImpl.LOG.isTraceEnabled();
        this.myProject = project;
        this.myFileBasedIndex = fileBasedIndex;
        this.myFileTypeIndex = fileBasedIndex.getIndex(FileTypeIndex.NAME);
        this.myRunExtensionsForFilesMarkedAsIndexed = runExtensionsForFilesMarkedAsIndexed;
        this.myStateProcessors = FileBasedIndexInfrastructureExtension.EP_NAME.extensions().map(ex -> ex.createFileIndexingStatusProcessor(project)).filter(Objects::nonNull).collect(Collectors.toList());
        this.myShouldProcessUpToDateFiles = ContainerUtil.find(this.myStateProcessors, p -> p.shouldProcessUpToDateFiles()) != null;
    }

    public boolean accept(VirtualFile file2) {
        return (Boolean)ReadAction.compute(() -> {
            if (this.myProject.isDisposed() || !file2.isValid() || !(file2 instanceof VirtualFileWithId)) {
                return false;
            }
            if (file2 instanceof VirtualFileSystemEntry && ((VirtualFileSystemEntry)file2).isFileIndexed()) {
                if (this.myRunExtensionsForFilesMarkedAsIndexed && this.myShouldProcessUpToDateFiles) {
                    int inputId = Math.abs(FileBasedIndexImpl.getIdMaskingNonIdBasedFile(file2));
                    List<ID<?, ?>> ids = IndexingStamp.getNontrivialFileIndexedStates(inputId);
                    for (FileBasedIndexInfrastructureExtension.FileIndexingStatusProcessor processor2 : this.myStateProcessors) {
                        for (ID<?, ?> id2 : ids) {
                            if (!this.myFileBasedIndex.needsFileContentLoading(id2)) continue;
                            processor2.processUpToDateFile(file2, inputId, id2);
                        }
                    }
                }
                return false;
            }
            AtomicBoolean shouldIndexFile = new AtomicBoolean(false);
            FileBasedIndexImpl.getFileTypeManager().freezeFileTypeTemporarilyIn(file2, () -> {
                IndexedFileImpl fileContent = new IndexedFileImpl(file2, this.myProject);
                boolean isDirectory = file2.isDirectory();
                int inputId = Math.abs(FileBasedIndexImpl.getIdMaskingNonIdBasedFile(file2));
                FileIndexingState fileTypeIndexState = null;
                if (!isDirectory && !this.myFileBasedIndex.isTooLarge(file2)) {
                    fileTypeIndexState = this.myFileTypeIndex.getIndexingStateForFile(inputId, fileContent);
                    if (fileTypeIndexState == FileIndexingState.OUT_DATED) {
                        this.myFileBasedIndex.dropNontrivialIndexedStates(inputId);
                        shouldIndexFile.set(true);
                    } else {
                        List<ID<?, ?>> affectedIndexCandidates = this.myFileBasedIndex.getAffectedIndexCandidates(file2);
                        int size = affectedIndexCandidates.size();
                        for (int i2 = 0; i2 < size; ++i2) {
                            ID<?, ?> indexId = affectedIndexCandidates.get(i2);
                            try {
                                if (!this.myFileBasedIndex.needsFileContentLoading(indexId)) continue;
                                FileIndexingState fileIndexingState = this.myFileBasedIndex.shouldIndexFile(fileContent, indexId);
                                boolean indexInfrastructureExtensionInvalidated = false;
                                if (fileIndexingState == FileIndexingState.UP_TO_DATE && this.myShouldProcessUpToDateFiles) {
                                    for (FileBasedIndexInfrastructureExtension.FileIndexingStatusProcessor p : this.myStateProcessors) {
                                        if (p.processUpToDateFile(file2, inputId, indexId)) continue;
                                        indexInfrastructureExtensionInvalidated = true;
                                    }
                                }
                                if (indexInfrastructureExtensionInvalidated) {
                                    fileIndexingState = this.myFileBasedIndex.shouldIndexFile(fileContent, indexId);
                                }
                                if (!fileIndexingState.updateRequired()) continue;
                                if (this.myDoTraceForFilesToBeIndexed) {
                                    LOG.trace("Scheduling indexing of " + file2 + " by request of index " + indexId);
                                }
                                shouldIndexFile.set(true);
                                break;
                            }
                            catch (RuntimeException e) {
                                Throwable cause = e.getCause();
                                if (cause instanceof IOException || cause instanceof StorageException) {
                                    LOG.info((Throwable)e);
                                    this.myFileBasedIndex.requestRebuild(indexId);
                                    continue;
                                }
                                throw e;
                            }
                        }
                    }
                }
                for (ID<?, ?> indexId : this.myFileBasedIndex.getContentLessIndexes(isDirectory)) {
                    if (FileTypeIndex.NAME.equals(indexId) && fileTypeIndexState != null && !fileTypeIndexState.updateRequired() || !this.myFileBasedIndex.shouldIndexFile(fileContent, indexId).updateRequired()) continue;
                    this.myFileBasedIndex.updateSingleIndex(indexId, file2, inputId, new IndexedFileWrapper(fileContent));
                }
                IndexingStamp.flushCache(inputId);
                if (!shouldIndexFile.get() && file2 instanceof VirtualFileSystemEntry) {
                    ((VirtualFileSystemEntry)file2).setFileIndexed(true);
                }
            });
            return shouldIndexFile.get();
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "fileBasedIndex";
                break;
            }
        }
        objectArray[1] = "com/intellij/util/indexing/UnindexedFilesFinder";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

