/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.breakpoints.ui;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.util.Disposer;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointUtil;
import com.intellij.xdebugger.impl.breakpoints.ui.BreakpointPanelProvider;
import com.intellij.xdebugger.impl.breakpoints.ui.BreakpointsDialog;
import org.jetbrains.annotations.Nullable;

public class BreakpointsDialogFactory {
    private final Project myProject;
    private Balloon myBalloonToHide;
    private Object myBreakpoint;
    private BreakpointsDialog myDialogShowing;

    public BreakpointsDialogFactory(Project project) {
        this.myProject = project;
    }

    public void setBalloonToHide(final Balloon balloonToHide, Object breakpoint) {
        this.myBalloonToHide = balloonToHide;
        this.myBreakpoint = breakpoint;
        Disposer.register((Disposable)this.myBalloonToHide, (Disposable)new Disposable(){

            public void dispose() {
                if (BreakpointsDialogFactory.this.myBalloonToHide == balloonToHide) {
                    BreakpointsDialogFactory.this.myBalloonToHide = null;
                    BreakpointsDialogFactory.this.myBreakpoint = null;
                }
            }
        });
    }

    public static BreakpointsDialogFactory getInstance(Project project) {
        return (BreakpointsDialogFactory)ServiceManager.getService((Project)project, BreakpointsDialogFactory.class);
    }

    public boolean popupRequested(Object breakpoint) {
        if (this.myBalloonToHide != null && !this.myBalloonToHide.isDisposed()) {
            return true;
        }
        if (this.myDialogShowing != null) {
            this.myDialogShowing.selectBreakpoint(breakpoint, true);
            this.myDialogShowing.toFront();
            return true;
        }
        return false;
    }

    public void showDialog(@Nullable Object initialBreakpoint) {
        if (this.myDialogShowing != null && this.myDialogShowing.getWindow().isDisplayable()) {
            this.myDialogShowing.selectBreakpoint(initialBreakpoint, true);
            this.myDialogShowing.toFront();
            return;
        }
        BreakpointsDialog dialog2 = new BreakpointsDialog(this.myProject, initialBreakpoint != null ? initialBreakpoint : this.myBreakpoint, XBreakpointUtil.collectPanelProviders()){

            @Override
            protected void dispose() {
                BreakpointsDialogFactory.this.myBreakpoint = null;
                for (BreakpointPanelProvider provider : XBreakpointUtil.collectPanelProviders()) {
                    provider.onDialogClosed(BreakpointsDialogFactory.this.myProject);
                }
                BreakpointsDialogFactory.this.myDialogShowing = null;
                super.dispose();
            }
        };
        if (this.myBalloonToHide != null) {
            if (!this.myBalloonToHide.isDisposed()) {
                this.myBalloonToHide.hide();
            }
            this.myBalloonToHide = null;
        }
        this.myDialogShowing = dialog2;
        dialog2.show();
    }
}

