/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.ide.util.treeView.FileNameComparator;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FilePath;
import java.util.Comparator;
import org.jetbrains.annotations.NotNull;

public class HierarchicalFilePathComparator
implements Comparator<FilePath> {
    public static final HierarchicalFilePathComparator CASE_SENSITIVE = new HierarchicalFilePathComparator(false);
    public static final HierarchicalFilePathComparator CASE_INSENSITIVE = new HierarchicalFilePathComparator(true);
    public static final HierarchicalFilePathComparator SYSTEM_CASE_SENSITIVE = SystemInfo.isFileSystemCaseSensitive ? CASE_SENSITIVE : CASE_INSENSITIVE;
    public static final HierarchicalFilePathComparator NATURAL = new HierarchicalFilePathComparator(true){

        @Override
        protected int compareFileNames(@NotNull String name1, @NotNull String name2) {
            if (name1 == null) {
                1.$$$reportNull$$$0(0);
            }
            if (name2 == null) {
                1.$$$reportNull$$$0(1);
            }
            return FileNameComparator.INSTANCE.compare(name1, name2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "name1";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "name2";
                    break;
                }
            }
            objectArray[1] = "com/intellij/openapi/vcs/changes/HierarchicalFilePathComparator$1";
            objectArray[2] = "compareFileNames";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    };
    private final boolean myIgnoreCase;

    private HierarchicalFilePathComparator(boolean ignoreCase) {
        this.myIgnoreCase = ignoreCase;
    }

    @Override
    public int compare(@NotNull FilePath filePath1, @NotNull FilePath filePath2) {
        boolean isDirectory2;
        String path2;
        String path1;
        int commonPrefix;
        if (filePath1 == null) {
            HierarchicalFilePathComparator.$$$reportNull$$$0(0);
        }
        if (filePath2 == null) {
            HierarchicalFilePathComparator.$$$reportNull$$$0(1);
        }
        if ((commonPrefix = StringUtil.commonPrefixLength((CharSequence)(path1 = filePath1.getPath()), (CharSequence)(path2 = filePath2.getPath()), (boolean)this.myIgnoreCase)) == path1.length() && commonPrefix == path2.length()) {
            if (filePath1.isDirectory() != filePath2.isDirectory()) {
                return filePath1.isDirectory() ? -1 : 1;
            }
            return 0;
        }
        if (commonPrefix == path1.length() && path2.charAt(commonPrefix) == '/') {
            return filePath1.isDirectory() ? -1 : 1;
        }
        if (commonPrefix == path2.length() && path1.charAt(commonPrefix) == '/') {
            return filePath2.isDirectory() ? 1 : -1;
        }
        int start2 = StringUtil.lastIndexOf((CharSequence)path1, (char)'/', (int)0, (int)commonPrefix) + 1;
        int end1 = path1.indexOf(47, start2);
        int end2 = path2.indexOf(47, start2);
        String name1 = end1 == -1 ? path1.substring(start2) : path1.substring(start2, end1);
        String name2 = end2 == -1 ? path2.substring(start2) : path2.substring(start2, end2);
        boolean isDirectory1 = end1 != -1 || filePath1.isDirectory();
        boolean bl = isDirectory2 = end2 != -1 || filePath2.isDirectory();
        if (isDirectory1 != isDirectory2) {
            return isDirectory1 ? -1 : 1;
        }
        return this.compareFileNames(name1, name2);
    }

    protected int compareFileNames(@NotNull String name1, @NotNull String name2) {
        if (name1 == null) {
            HierarchicalFilePathComparator.$$$reportNull$$$0(2);
        }
        if (name2 == null) {
            HierarchicalFilePathComparator.$$$reportNull$$$0(3);
        }
        return StringUtil.compare((String)name1, (String)name2, (boolean)this.myIgnoreCase);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath1";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath2";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name1";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name2";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/vcs/changes/HierarchicalFilePathComparator";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "compare";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "compareFileNames";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

