/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python;

import com.intellij.lang.Language;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.util.text.CharSequenceReader;
import com.jetbrains.python.PyPsiApiBundle;
import com.jetbrains.python.PythonLanguage;
import icons.PythonPsiApiIcons;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.StandardCharsets;
import java.nio.charset.UnsupportedCharsetException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PythonFileType
extends LanguageFileType {
    private static final Pattern ENCODING_PATTERN = Pattern.compile("coding[:=]\\s*([-\\w.]+)");
    public static final int MAX_CHARSET_ENCODING_LINE = 2;
    public static final PythonFileType INSTANCE = new PythonFileType();

    private PythonFileType() {
        this(PythonLanguage.INSTANCE);
    }

    protected PythonFileType(Language language) {
        super(language);
    }

    @NotNull
    @NonNls
    public String getName() {
        return "Python";
    }

    @NotNull
    public String getDescription() {
        String string = PyPsiApiBundle.message("python.file.type", new Object[0]);
        if (string == null) {
            PythonFileType.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getDefaultExtension() {
        return "py";
    }

    @NotNull
    public Icon getIcon() {
        Icon icon = PythonPsiApiIcons.PythonFile;
        if (icon == null) {
            PythonFileType.$$$reportNull$$$0(1);
        }
        return icon;
    }

    public String getCharset(@NotNull VirtualFile file, byte @NotNull [] content2) {
        if (file == null) {
            PythonFileType.$$$reportNull$$$0(2);
        }
        if (content2 == null) {
            PythonFileType.$$$reportNull$$$0(3);
        }
        if (CharsetToolkit.hasUTF8Bom((byte[])content2)) {
            return "UTF-8";
        }
        ByteBuffer bytes = ByteBuffer.wrap(content2, 0, Math.min(256, content2.length));
        String decoded = StandardCharsets.UTF_8.decode(bytes).toString();
        return PythonFileType.getCharsetFromEncodingDeclaration(StringUtil.convertLineSeparators((String)decoded));
    }

    public Charset extractCharsetFromFileContent(@Nullable Project project, @Nullable VirtualFile file, @NotNull CharSequence content2) {
        String charsetName;
        if (content2 == null) {
            PythonFileType.$$$reportNull$$$0(4);
        }
        if ((charsetName = PythonFileType.getCharsetFromEncodingDeclaration(content2)) == null) {
            return null;
        }
        try {
            return Charset.forName(charsetName);
        }
        catch (IllegalCharsetNameException | UnsupportedCharsetException e) {
            return null;
        }
    }

    @Nullable
    public static String getCharsetFromEncodingDeclaration(@NotNull PsiFile file) {
        String content2;
        Document document;
        if (file == null) {
            PythonFileType.$$$reportNull$$$0(5);
        }
        if ((document = PsiDocumentManager.getInstance((Project)file.getProject()).getDocument(file)) != null && document.getLineCount() > 2) {
            int offset = document.getLineEndOffset(2);
            content2 = document.getText(TextRange.create((int)0, (int)offset));
        } else {
            content2 = file.getText();
        }
        return PythonFileType.getCharsetFromEncodingDeclaration(content2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    private static String getCharsetFromEncodingDeclaration(@Nullable CharSequence content2) {
        if (content2 == null) return null;
        if (content2.length() == 0) {
            return null;
        }
        try (BufferedReader reader = new BufferedReader((Reader)new CharSequenceReader(content2));){
            int i = 0;
            while (i < 2) {
                String line2 = reader.readLine();
                if (line2 == null) {
                    String string = null;
                    return string;
                }
                Matcher matcher = ENCODING_PATTERN.matcher(line2);
                if (matcher.find()) {
                    String charset = matcher.group(1);
                    String string = PythonFileType.normalizeCharset(charset);
                    return string;
                }
                ++i;
            }
            return null;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    @Nullable
    private static String normalizeCharset(String charset) {
        if (charset == null) {
            return null;
        }
        if ("latin-1".equals(charset = StringUtil.toLowerCase((String)charset))) {
            return "iso-8859-1";
        }
        return charset;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/PythonFileType";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescription";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getIcon";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/PythonFileType";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getCharset";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "extractCharsetFromFileContent";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getCharsetFromEncodingDeclaration";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

