/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.PyPsiBundle;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.inspections.PyInspection;
import com.jetbrains.python.inspections.PyInspectionExtension;
import com.jetbrains.python.inspections.PyInspectionVisitor;
import com.jetbrains.python.inspections.quickfix.StatementEffectFunctionCallQuickFix;
import com.jetbrains.python.inspections.quickfix.StatementEffectIntroduceVariableQuickFix;
import com.jetbrains.python.psi.AccessDirection;
import com.jetbrains.python.psi.PyBinaryExpression;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyConditionalExpression;
import com.jetbrains.python.psi.PyElementType;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyExpressionStatement;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyListCompExpression;
import com.jetbrains.python.psi.PyNoneLiteralExpression;
import com.jetbrains.python.psi.PyParenthesizedExpression;
import com.jetbrains.python.psi.PyPrefixExpression;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyStatementList;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PyTryPart;
import com.jetbrains.python.psi.PyTupleExpression;
import com.jetbrains.python.psi.PyYieldExpression;
import com.jetbrains.python.psi.types.PyType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyStatementEffectInspection
extends PyInspection {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            PyStatementEffectInspection.$$$reportNull$$$0(0);
        }
        if (session == null) {
            PyStatementEffectInspection.$$$reportNull$$$0(1);
        }
        return new Visitor(holder, session);
    }

    @Override
    protected boolean isSuppressForCodeFragment() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "holder";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "session";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/python/inspections/PyStatementEffectInspection";
        objectArray[2] = "buildVisitor";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class Visitor
    extends PyInspectionVisitor {
        public Visitor(ProblemsHolder holder, LocalInspectionToolSession session) {
            super(holder, session);
        }

        @Override
        public void visitPyExpressionStatement(PyExpressionStatement node) {
            PyStatementList statementList;
            PyExpression expression = node.getExpression();
            if (PsiTreeUtil.hasErrorElements((PsiElement)expression)) {
                return;
            }
            if (this.hasEffect(expression)) {
                return;
            }
            if (expression instanceof PyStringLiteralExpression) {
                return;
            }
            PyTryPart tryPart = (PyTryPart)PsiTreeUtil.getParentOfType((PsiElement)node, PyTryPart.class);
            if (tryPart != null && (statementList = tryPart.getStatementList()).getStatements().length == 1 && statementList.getStatements()[0] == node) {
                return;
            }
            if (ContainerUtil.exists((Iterable)PyInspectionExtension.EP_NAME.getExtensionList(), extension -> extension.ignoreNoEffectStatement(node))) {
                return;
            }
            if (expression instanceof PyReferenceExpression && !((PyReferenceExpression)expression).isQualified()) {
                this.registerProblem((PsiElement)expression, PyPsiBundle.message("INSP.NAME.statement.message", new Object[0]));
            } else {
                this.registerProblem((PsiElement)expression, PyPsiBundle.message("INSP.NAME.statement.message", new Object[0]), new StatementEffectIntroduceVariableQuickFix());
            }
        }

        private boolean hasEffect(@Nullable PyExpression expression) {
            if (expression == null) {
                return false;
            }
            if (expression instanceof PyCallExpression || expression instanceof PyYieldExpression) {
                return true;
            }
            if (expression instanceof PyListCompExpression) {
                if (this.hasEffect(((PyListCompExpression)expression).getResultExpression())) {
                    return true;
                }
            } else if (expression instanceof PyBinaryExpression) {
                String method;
                PyBinaryExpression binary = (PyBinaryExpression)expression;
                PyElementType operator = binary.getOperator();
                if (PyTokenTypes.COMPARISON_OPERATIONS.contains((IElementType)operator)) {
                    return false;
                }
                PyExpression leftExpression = binary.getLeftExpression();
                PyExpression rightExpression = binary.getRightExpression();
                if (this.hasEffect(leftExpression) || this.hasEffect(rightExpression)) {
                    return true;
                }
                String string = method = operator == null ? null : operator.getSpecialMethodName();
                if (method != null) {
                    PyType type = this.myTypeEvalContext.getType(leftExpression);
                    if (type != null && !type.isBuiltin() && type.resolveMember(method, null, AccessDirection.READ, this.getResolveContext()) != null) {
                        return true;
                    }
                    if (rightExpression != null && (type = this.myTypeEvalContext.getType(rightExpression)) != null) {
                        String rmethod = "__r" + method.substring(2);
                        if (!type.isBuiltin() && type.resolveMember(rmethod, null, AccessDirection.READ, this.getResolveContext()) != null) {
                            return true;
                        }
                    }
                }
            } else {
                if (expression instanceof PyConditionalExpression) {
                    PyConditionalExpression conditionalExpression = (PyConditionalExpression)expression;
                    return this.hasEffect(conditionalExpression.getTruePart()) || this.hasEffect(conditionalExpression.getFalsePart());
                }
                if (expression instanceof PyParenthesizedExpression) {
                    PyParenthesizedExpression parenthesizedExpression = (PyParenthesizedExpression)expression;
                    return this.hasEffect(parenthesizedExpression.getContainedExpression());
                }
                if (expression instanceof PyReferenceExpression) {
                    ResolveResult[] results;
                    PyReferenceExpression referenceExpression = (PyReferenceExpression)expression;
                    for (ResolveResult res : results = referenceExpression.getReference(this.getResolveContext()).multiResolve(true)) {
                        if (!(res.getElement() instanceof PyFunction)) continue;
                        this.registerProblem((PsiElement)expression, "Statement seems to have no effect and can be replaced with function call to have effect", new StatementEffectFunctionCallQuickFix());
                        return true;
                    }
                } else if (expression instanceof PyTupleExpression) {
                    PyExpression[] elements;
                    for (PyExpression element : elements = ((PyTupleExpression)expression).getElements()) {
                        if (!this.hasEffect(element)) continue;
                        return true;
                    }
                } else {
                    if (expression instanceof PyPrefixExpression) {
                        PyPrefixExpression prefixExpr = (PyPrefixExpression)expression;
                        return prefixExpr.getOperator() == PyTokenTypes.AWAIT_KEYWORD;
                    }
                    if (expression instanceof PyNoneLiteralExpression && ((PyNoneLiteralExpression)expression).isEllipsis()) {
                        return true;
                    }
                }
            }
            return false;
        }
    }
}

