/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.validation;

import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.codeInsight.functionTypeComments.psi.PyParameterTypeList;
import com.jetbrains.python.psi.PyParenthesizedExpression;
import com.jetbrains.python.psi.PyStarExpression;
import com.jetbrains.python.psi.PyTupleExpression;
import com.jetbrains.python.psi.PyYieldExpression;
import com.jetbrains.python.validation.PyAnnotator;
import org.jetbrains.annotations.NotNull;

public class StarAnnotator
extends PyAnnotator {
    @Override
    public void visitPyStarExpression(PyStarExpression node) {
        super.visitPyStarExpression(node);
        if (!(node.isAssignmentTarget() || StarAnnotator.allowedUnpacking(node) || node.getParent() instanceof PyParameterTypeList)) {
            this.getHolder().newAnnotation(HighlightSeverity.ERROR, PyBundle.message("ANN.can.t.use.starred.expression.here", new Object[0])).create();
        }
    }

    private static boolean allowedUnpacking(@NotNull PyStarExpression starExpression) {
        PsiElement tupleParent;
        if (starExpression == null) {
            StarAnnotator.$$$reportNull$$$0(0);
        }
        if (!starExpression.isUnpacking()) {
            return false;
        }
        PsiElement parent = PsiTreeUtil.skipParentsOfType((PsiElement)starExpression, (Class[])new Class[]{PyParenthesizedExpression.class});
        return !(parent instanceof PyTupleExpression) || !((tupleParent = parent.getParent()) instanceof PyYieldExpression) || !((PyYieldExpression)tupleParent).isDelegating();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "starExpression", "com/jetbrains/python/validation/StarAnnotator", "allowedUnpacking"));
    }
}

