/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.code;

import java.util.List;
import sun.jvm.hotspot.code.CompressedReadStream;
import sun.jvm.hotspot.code.NMethod;
import sun.jvm.hotspot.code.ObjectValue;
import sun.jvm.hotspot.code.ScopeValue;
import sun.jvm.hotspot.debugger.OopHandle;
import sun.jvm.hotspot.runtime.VM;
import sun.jvm.hotspot.utilities.Assert;

public class DebugInfoReadStream
extends CompressedReadStream {
    private NMethod code;
    private int InvocationEntryBCI = VM.getVM().getInvocationEntryBCI();
    private List objectPool;

    public DebugInfoReadStream(NMethod code, int offset) {
        super(code.scopesDataBegin(), offset);
        this.code = code;
        this.objectPool = null;
    }

    public DebugInfoReadStream(NMethod code, int offset, List objectPool) {
        super(code.scopesDataBegin(), offset);
        this.code = code;
        this.objectPool = objectPool;
    }

    public OopHandle readOopHandle() {
        return this.code.getOopAt(this.readInt());
    }

    ScopeValue readObjectValue() {
        int id = this.readInt();
        if (Assert.ASSERTS_ENABLED) {
            Assert.that(this.objectPool != null, "object pool does not exist");
            for (ObjectValue ov : this.objectPool) {
                Assert.that(ov.id() != id, "should not be read twice");
            }
        }
        ObjectValue result = new ObjectValue(id);
        this.objectPool.add(result);
        result.readObject(this);
        return result;
    }

    ScopeValue getCachedObject() {
        int id = this.readInt();
        Assert.that(this.objectPool != null, "object pool does not exist");
        for (ObjectValue ov : this.objectPool) {
            if (ov.id() != id) continue;
            return ov;
        }
        Assert.that(false, "should not reach here");
        return null;
    }

    public int readBCI() {
        return this.readInt() + this.InvocationEntryBCI;
    }
}

