/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.TimeZone;
import sun.util.calendar.BaseCalendar;
import sun.util.calendar.CalendarDate;
import sun.util.calendar.CalendarSystem;
import sun.util.calendar.CalendarUtils;
import sun.util.calendar.Era;
import sun.util.calendar.Gregorian;
import sun.util.calendar.LocalGregorianCalendar;
import sun.util.calendar.ZoneInfo;
import sun.util.resources.LocaleData;

class JapaneseImperialCalendar
extends Calendar {
    public static final int BEFORE_MEIJI = 0;
    public static final int MEIJI = 1;
    public static final int TAISHO = 2;
    public static final int SHOWA = 3;
    public static final int HEISEI = 4;
    private static final int REIWA = 5;
    private static final int EPOCH_OFFSET = 719163;
    private static final int ONE_SECOND = 1000;
    private static final int ONE_MINUTE = 60000;
    private static final int ONE_HOUR = 3600000;
    private static final long ONE_DAY = 86400000L;
    private static final long ONE_WEEK = 604800000L;
    private static final LocalGregorianCalendar jcal;
    private static final Gregorian gcal;
    private static final Era BEFORE_MEIJI_ERA;
    private static final Era[] eras;
    private static final long[] sinceFixedDates;
    private static final int currentEra;
    static final int[] MIN_VALUES;
    static final int[] LEAST_MAX_VALUES;
    static final int[] MAX_VALUES;
    private static final long serialVersionUID = -3364572813905467929L;
    private transient LocalGregorianCalendar.Date jdate;
    private transient int[] zoneOffsets;
    private transient int[] originalFields;
    private transient long cachedFixedDate = Long.MIN_VALUE;

    JapaneseImperialCalendar(TimeZone zone, Locale aLocale) {
        super(zone, aLocale);
        this.jdate = jcal.newCalendarDate(zone);
        this.setTimeInMillis(System.currentTimeMillis());
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof JapaneseImperialCalendar && super.equals(obj);
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ this.jdate.hashCode();
    }

    @Override
    public void add(int field, int amount) {
        if (amount == 0) {
            return;
        }
        if (field < 0 || field >= 15) {
            throw new IllegalArgumentException();
        }
        this.complete();
        if (field == 1) {
            LocalGregorianCalendar.Date d = (LocalGregorianCalendar.Date)this.jdate.clone();
            d.addYear(amount);
            this.pinDayOfMonth(d);
            this.set(0, JapaneseImperialCalendar.getEraIndex(d));
            this.set(1, d.getYear());
            this.set(2, d.getMonth() - 1);
            this.set(5, d.getDayOfMonth());
        } else if (field == 2) {
            LocalGregorianCalendar.Date d = (LocalGregorianCalendar.Date)this.jdate.clone();
            d.addMonth(amount);
            this.pinDayOfMonth(d);
            this.set(0, JapaneseImperialCalendar.getEraIndex(d));
            this.set(1, d.getYear());
            this.set(2, d.getMonth() - 1);
            this.set(5, d.getDayOfMonth());
        } else if (field == 0) {
            int era = this.internalGet(0) + amount;
            if (era < 0) {
                era = 0;
            } else if (era > eras.length - 1) {
                era = eras.length - 1;
            }
            this.set(0, era);
        } else {
            long delta = amount;
            long timeOfDay = 0L;
            switch (field) {
                case 10: 
                case 11: {
                    delta *= 3600000L;
                    break;
                }
                case 12: {
                    delta *= 60000L;
                    break;
                }
                case 13: {
                    delta *= 1000L;
                    break;
                }
                case 14: {
                    break;
                }
                case 3: 
                case 4: 
                case 8: {
                    delta *= 7L;
                    break;
                }
                case 5: 
                case 6: 
                case 7: {
                    break;
                }
                case 9: {
                    delta = amount / 2;
                    timeOfDay = 12 * (amount % 2);
                }
            }
            if (field >= 10) {
                this.setTimeInMillis(this.time + delta);
                return;
            }
            long fd = this.cachedFixedDate;
            timeOfDay += (long)this.internalGet(11);
            timeOfDay *= 60L;
            timeOfDay += (long)this.internalGet(12);
            timeOfDay *= 60L;
            timeOfDay += (long)this.internalGet(13);
            timeOfDay *= 1000L;
            if ((timeOfDay += (long)this.internalGet(14)) >= 86400000L) {
                ++fd;
                timeOfDay -= 86400000L;
            } else if (timeOfDay < 0L) {
                --fd;
                timeOfDay += 86400000L;
            }
            int zoneOffset = this.internalGet(15) + this.internalGet(16);
            this.setTimeInMillis(((fd += delta) - 719163L) * 86400000L + timeOfDay - (long)zoneOffset);
            if ((zoneOffset -= this.internalGet(15) + this.internalGet(16)) != 0) {
                this.setTimeInMillis(this.time + (long)zoneOffset);
                long fd2 = this.cachedFixedDate;
                if (fd2 != fd) {
                    this.setTimeInMillis(this.time - (long)zoneOffset);
                }
            }
        }
    }

    @Override
    public void roll(int field, boolean up) {
        this.roll(field, up ? 1 : -1);
    }

    @Override
    public void roll(int field, int amount) {
        if (amount == 0) {
            return;
        }
        if (field < 0 || field >= 15) {
            throw new IllegalArgumentException();
        }
        this.complete();
        int min = this.getMinimum(field);
        int max = this.getMaximum(field);
        switch (field) {
            case 0: 
            case 9: 
            case 12: 
            case 13: 
            case 14: {
                break;
            }
            case 10: 
            case 11: {
                int unit = max + 1;
                int h = this.internalGet(field);
                int nh = (h + amount) % unit;
                if (nh < 0) {
                    nh += unit;
                }
                this.time += (long)(3600000 * (nh - h));
                LocalGregorianCalendar.Date d = jcal.getCalendarDate(this.time, this.getZone());
                if (this.internalGet(5) != d.getDayOfMonth()) {
                    ((CalendarDate)d).setEra(this.jdate.getEra());
                    d.setDate(this.internalGet(1), this.internalGet(2) + 1, this.internalGet(5));
                    if (field == 10) {
                        assert (this.internalGet(9) == 1);
                        d.addHours(12);
                    }
                    this.time = jcal.getTime(d);
                }
                int hourOfDay = d.getHours();
                this.internalSet(field, hourOfDay % unit);
                if (field == 10) {
                    this.internalSet(11, hourOfDay);
                } else {
                    this.internalSet(9, hourOfDay / 12);
                    this.internalSet(10, hourOfDay % 12);
                }
                int zoneOffset = d.getZoneOffset();
                int saving = d.getDaylightSaving();
                this.internalSet(15, zoneOffset - saving);
                this.internalSet(16, saving);
                return;
            }
            case 1: {
                min = this.getActualMinimum(field);
                max = this.getActualMaximum(field);
                break;
            }
            case 2: {
                if (!this.isTransitionYear(this.jdate.getNormalizedYear())) {
                    int year = this.jdate.getYear();
                    if (year == this.getMaximum(1)) {
                        LocalGregorianCalendar.Date jd = jcal.getCalendarDate(this.time, this.getZone());
                        LocalGregorianCalendar.Date d = jcal.getCalendarDate(Long.MAX_VALUE, this.getZone());
                        max = d.getMonth() - 1;
                        int n = JapaneseImperialCalendar.getRolledValue(this.internalGet(field), amount, min, max);
                        if (n == max) {
                            ((CalendarDate)jd).addYear(-400);
                            jd.setMonth(n + 1);
                            if (jd.getDayOfMonth() > d.getDayOfMonth()) {
                                jd.setDayOfMonth(d.getDayOfMonth());
                                jcal.normalize(jd);
                            }
                            if (jd.getDayOfMonth() == d.getDayOfMonth() && jd.getTimeOfDay() > d.getTimeOfDay()) {
                                jd.setMonth(n + 1);
                                jd.setDayOfMonth(d.getDayOfMonth() - 1);
                                jcal.normalize(jd);
                                n = jd.getMonth() - 1;
                            }
                            this.set(5, jd.getDayOfMonth());
                        }
                        this.set(2, n);
                    } else if (year == this.getMinimum(1)) {
                        LocalGregorianCalendar.Date jd = jcal.getCalendarDate(this.time, this.getZone());
                        LocalGregorianCalendar.Date d = jcal.getCalendarDate(Long.MIN_VALUE, this.getZone());
                        min = d.getMonth() - 1;
                        int n = JapaneseImperialCalendar.getRolledValue(this.internalGet(field), amount, min, max);
                        if (n == min) {
                            ((CalendarDate)jd).addYear(400);
                            jd.setMonth(n + 1);
                            if (jd.getDayOfMonth() < d.getDayOfMonth()) {
                                jd.setDayOfMonth(d.getDayOfMonth());
                                jcal.normalize(jd);
                            }
                            if (jd.getDayOfMonth() == d.getDayOfMonth() && jd.getTimeOfDay() < d.getTimeOfDay()) {
                                jd.setMonth(n + 1);
                                jd.setDayOfMonth(d.getDayOfMonth() + 1);
                                jcal.normalize(jd);
                                n = jd.getMonth() - 1;
                            }
                            this.set(5, jd.getDayOfMonth());
                        }
                        this.set(2, n);
                    } else {
                        int mon = (this.internalGet(2) + amount) % 12;
                        if (mon < 0) {
                            mon += 12;
                        }
                        this.set(2, mon);
                        int monthLen = this.monthLength(mon);
                        if (this.internalGet(5) > monthLen) {
                            this.set(5, monthLen);
                        }
                    }
                } else {
                    int eraIndex = JapaneseImperialCalendar.getEraIndex(this.jdate);
                    CalendarDate transition = null;
                    if (this.jdate.getYear() == 1) {
                        transition = eras[eraIndex].getSinceDate();
                        min = transition.getMonth() - 1;
                    } else if (eraIndex < eras.length - 1 && (transition = eras[eraIndex + 1].getSinceDate()).getYear() == this.jdate.getNormalizedYear()) {
                        max = transition.getMonth() - 1;
                        if (transition.getDayOfMonth() == 1) {
                            --max;
                        }
                    }
                    if (min == max) {
                        return;
                    }
                    int n = JapaneseImperialCalendar.getRolledValue(this.internalGet(field), amount, min, max);
                    this.set(2, n);
                    if (n == min) {
                        if ((transition.getMonth() != 1 || transition.getDayOfMonth() != 1) && this.jdate.getDayOfMonth() < transition.getDayOfMonth()) {
                            this.set(5, transition.getDayOfMonth());
                        }
                    } else if (n == max && transition.getMonth() - 1 == n) {
                        int dom = transition.getDayOfMonth();
                        if (this.jdate.getDayOfMonth() >= dom) {
                            this.set(5, dom - 1);
                        }
                    }
                }
                return;
            }
            case 3: {
                int y = this.jdate.getNormalizedYear();
                max = this.getActualMaximum(3);
                this.set(7, this.internalGet(7));
                int woy = this.internalGet(3);
                int value = woy + amount;
                if (!this.isTransitionYear(this.jdate.getNormalizedYear())) {
                    int year = this.jdate.getYear();
                    if (year == this.getMaximum(1)) {
                        max = this.getActualMaximum(3);
                    } else if (year == this.getMinimum(1)) {
                        min = this.getActualMinimum(3);
                        max = this.getActualMaximum(3);
                        if (value > min && value < max) {
                            this.set(3, value);
                            return;
                        }
                    }
                    if (value > min && value < max) {
                        this.set(3, value);
                        return;
                    }
                    long fd = this.cachedFixedDate;
                    long day1 = fd - (long)(7 * (woy - min));
                    if (year != this.getMinimum(1)) {
                        if (gcal.getYearFromFixedDate(day1) != y) {
                            ++min;
                        }
                    } else {
                        LocalGregorianCalendar.Date d = jcal.getCalendarDate(Long.MIN_VALUE, this.getZone());
                        if (day1 < jcal.getFixedDate(d)) {
                            ++min;
                        }
                    }
                    if (gcal.getYearFromFixedDate(fd += (long)(7 * (max - this.internalGet(3)))) == y) break;
                    --max;
                    break;
                }
                long fd = this.cachedFixedDate;
                long day1 = fd - (long)(7 * (woy - min));
                LocalGregorianCalendar.Date d = JapaneseImperialCalendar.getCalendarDate(day1);
                if (d.getEra() != this.jdate.getEra() || d.getYear() != this.jdate.getYear()) {
                    ++min;
                }
                jcal.getCalendarDateFromFixedDate(d, fd += (long)(7 * (max - woy)));
                if (d.getEra() != this.jdate.getEra() || d.getYear() != this.jdate.getYear()) {
                    --max;
                }
                value = JapaneseImperialCalendar.getRolledValue(woy, amount, min, max) - 1;
                d = JapaneseImperialCalendar.getCalendarDate(day1 + (long)(value * 7));
                this.set(2, d.getMonth() - 1);
                this.set(5, d.getDayOfMonth());
                return;
            }
            case 4: {
                int monthLength;
                long month1;
                boolean isTransitionYear = this.isTransitionYear(this.jdate.getNormalizedYear());
                int dow = this.internalGet(7) - this.getFirstDayOfWeek();
                if (dow < 0) {
                    dow += 7;
                }
                long fd = this.cachedFixedDate;
                if (isTransitionYear) {
                    month1 = this.getFixedDateMonth1(this.jdate, fd);
                    monthLength = this.actualMonthLength();
                } else {
                    month1 = fd - (long)this.internalGet(5) + 1L;
                    monthLength = jcal.getMonthLength(this.jdate);
                }
                long monthDay1st = LocalGregorianCalendar.getDayOfWeekDateOnOrBefore(month1 + 6L, this.getFirstDayOfWeek());
                if ((int)(monthDay1st - month1) >= this.getMinimalDaysInFirstWeek()) {
                    monthDay1st -= 7L;
                }
                max = this.getActualMaximum(field);
                int value = JapaneseImperialCalendar.getRolledValue(this.internalGet(field), amount, 1, max) - 1;
                long nfd = monthDay1st + (long)(value * 7) + (long)dow;
                if (nfd < month1) {
                    nfd = month1;
                } else if (nfd >= month1 + (long)monthLength) {
                    nfd = month1 + (long)monthLength - 1L;
                }
                this.set(5, (int)(nfd - month1) + 1);
                return;
            }
            case 5: {
                if (!this.isTransitionYear(this.jdate.getNormalizedYear())) {
                    max = jcal.getMonthLength(this.jdate);
                    break;
                }
                long month1 = this.getFixedDateMonth1(this.jdate, this.cachedFixedDate);
                int value = JapaneseImperialCalendar.getRolledValue((int)(this.cachedFixedDate - month1), amount, 0, this.actualMonthLength() - 1);
                LocalGregorianCalendar.Date d = JapaneseImperialCalendar.getCalendarDate(month1 + (long)value);
                assert (JapaneseImperialCalendar.getEraIndex(d) == this.internalGetEra() && d.getYear() == this.internalGet(1) && d.getMonth() - 1 == this.internalGet(2));
                this.set(5, d.getDayOfMonth());
                return;
            }
            case 6: {
                max = this.getActualMaximum(field);
                if (!this.isTransitionYear(this.jdate.getNormalizedYear())) break;
                int value = JapaneseImperialCalendar.getRolledValue(this.internalGet(6), amount, min, max);
                long jan0 = this.cachedFixedDate - (long)this.internalGet(6);
                LocalGregorianCalendar.Date d = JapaneseImperialCalendar.getCalendarDate(jan0 + (long)value);
                assert (JapaneseImperialCalendar.getEraIndex(d) == this.internalGetEra() && d.getYear() == this.internalGet(1));
                this.set(2, d.getMonth() - 1);
                this.set(5, d.getDayOfMonth());
                return;
            }
            case 7: {
                long dowFirst;
                int weekOfYear;
                int normalizedYear = this.jdate.getNormalizedYear();
                if (!this.isTransitionYear(normalizedYear) && !this.isTransitionYear(normalizedYear - 1) && (weekOfYear = this.internalGet(3)) > 1 && weekOfYear < 52) {
                    this.set(3, this.internalGet(3));
                    max = 7;
                    break;
                }
                if ((amount %= 7) == 0) {
                    return;
                }
                long fd = this.cachedFixedDate;
                if ((fd += (long)amount) < (dowFirst = LocalGregorianCalendar.getDayOfWeekDateOnOrBefore(fd, this.getFirstDayOfWeek()))) {
                    fd += 7L;
                } else if (fd >= dowFirst + 7L) {
                    fd -= 7L;
                }
                LocalGregorianCalendar.Date d = JapaneseImperialCalendar.getCalendarDate(fd);
                this.set(0, JapaneseImperialCalendar.getEraIndex(d));
                this.set(d.getYear(), d.getMonth() - 1, d.getDayOfMonth());
                return;
            }
            case 8: {
                min = 1;
                if (!this.isTransitionYear(this.jdate.getNormalizedYear())) {
                    int dom = this.internalGet(5);
                    int monthLength = jcal.getMonthLength(this.jdate);
                    int lastDays = monthLength % 7;
                    max = monthLength / 7;
                    int x = (dom - 1) % 7;
                    if (x < lastDays) {
                        ++max;
                    }
                    this.set(7, this.internalGet(7));
                    break;
                }
                long fd = this.cachedFixedDate;
                long month1 = this.getFixedDateMonth1(this.jdate, fd);
                int monthLength = this.actualMonthLength();
                int lastDays = monthLength % 7;
                max = monthLength / 7;
                int x = (int)(fd - month1) % 7;
                if (x < lastDays) {
                    ++max;
                }
                int value = JapaneseImperialCalendar.getRolledValue(this.internalGet(field), amount, min, max) - 1;
                fd = month1 + (long)(value * 7) + (long)x;
                LocalGregorianCalendar.Date d = JapaneseImperialCalendar.getCalendarDate(fd);
                this.set(5, d.getDayOfMonth());
                return;
            }
        }
        this.set(field, JapaneseImperialCalendar.getRolledValue(this.internalGet(field), amount, min, max));
    }

    @Override
    public String getDisplayName(int field, int style, Locale locale) {
        if (!this.checkDisplayNameParams(field, style, 1, 2, locale, 647)) {
            return null;
        }
        if (field == 1 && (style == 1 || this.get(1) != 1 || this.get(0) == 0)) {
            return null;
        }
        ResourceBundle rb = LocaleData.getDateFormatData(locale);
        String name = null;
        String key = this.getKey(field, style);
        if (key != null) {
            String[] strings = rb.getStringArray(key);
            if (field == 1) {
                if (strings.length > 0) {
                    name = strings[0];
                }
            } else {
                int index = this.get(field);
                if (field == 0 && index >= strings.length && index < eras.length) {
                    Era era = eras[index];
                    name = style == 1 ? era.getAbbreviation() : era.getName();
                } else {
                    if (field == 7) {
                        --index;
                    }
                    name = strings[index];
                }
            }
        }
        return name;
    }

    @Override
    public Map<String, Integer> getDisplayNames(int field, int style, Locale locale) {
        if (!this.checkDisplayNameParams(field, style, 0, 2, locale, 647)) {
            return null;
        }
        if (style == 0) {
            Map<String, Integer> shortNames = this.getDisplayNamesImpl(field, 1, locale);
            if (field == 9) {
                return shortNames;
            }
            Map<String, Integer> longNames = this.getDisplayNamesImpl(field, 2, locale);
            if (shortNames == null) {
                return longNames;
            }
            if (longNames != null) {
                shortNames.putAll(longNames);
            }
            return shortNames;
        }
        return this.getDisplayNamesImpl(field, style, locale);
    }

    private Map<String, Integer> getDisplayNamesImpl(int field, int style, Locale locale) {
        ResourceBundle rb = LocaleData.getDateFormatData(locale);
        String key = this.getKey(field, style);
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        if (key != null) {
            String[] strings = rb.getStringArray(key);
            if (field == 1) {
                if (strings.length > 0) {
                    map.put(strings[0], 1);
                }
            } else {
                int i;
                int base = field == 7 ? 1 : 0;
                for (i = 0; i < strings.length; ++i) {
                    map.put(strings[i], base + i);
                }
                if (field == 0 && strings.length < eras.length) {
                    for (i = strings.length; i < eras.length; ++i) {
                        Era era = eras[i];
                        String name = style == 1 ? era.getAbbreviation() : era.getName();
                        map.put(name, i);
                    }
                }
            }
        }
        return map.size() > 0 ? map : null;
    }

    private String getKey(int field, int style) {
        String className = JapaneseImperialCalendar.class.getName();
        StringBuilder key = new StringBuilder();
        switch (field) {
            case 0: {
                key.append(className);
                if (style == 1) {
                    key.append(".short");
                }
                key.append(".Eras");
                break;
            }
            case 1: {
                key.append(className).append(".FirstYear");
                break;
            }
            case 2: {
                key.append(style == 1 ? "MonthAbbreviations" : "MonthNames");
                break;
            }
            case 7: {
                key.append(style == 1 ? "DayAbbreviations" : "DayNames");
                break;
            }
            case 9: {
                key.append("AmPmMarkers");
            }
        }
        return key.length() > 0 ? key.toString() : null;
    }

    @Override
    public int getMinimum(int field) {
        return MIN_VALUES[field];
    }

    @Override
    public int getMaximum(int field) {
        switch (field) {
            case 1: {
                LocalGregorianCalendar.Date d = jcal.getCalendarDate(Long.MAX_VALUE, this.getZone());
                return Math.max(LEAST_MAX_VALUES[1], d.getYear());
            }
        }
        return MAX_VALUES[field];
    }

    @Override
    public int getGreatestMinimum(int field) {
        return field == 1 ? 1 : MIN_VALUES[field];
    }

    @Override
    public int getLeastMaximum(int field) {
        switch (field) {
            case 1: {
                return Math.min(LEAST_MAX_VALUES[1], this.getMaximum(1));
            }
        }
        return LEAST_MAX_VALUES[field];
    }

    @Override
    public int getActualMinimum(int field) {
        if (!JapaneseImperialCalendar.isFieldSet(14, field)) {
            return this.getMinimum(field);
        }
        int value = 0;
        JapaneseImperialCalendar jc = this.getNormalizedCalendar();
        LocalGregorianCalendar.Date jd = jcal.getCalendarDate(jc.getTimeInMillis(), this.getZone());
        int eraIndex = JapaneseImperialCalendar.getEraIndex(jd);
        switch (field) {
            case 1: {
                if (eraIndex > 0) {
                    value = 1;
                    long since = eras[eraIndex].getSince(this.getZone());
                    LocalGregorianCalendar.Date d = jcal.getCalendarDate(since, this.getZone());
                    jd.setYear(d.getYear());
                    jcal.normalize(jd);
                    assert (jd.isLeapYear() == d.isLeapYear());
                    if (this.getYearOffsetInMillis(jd) >= this.getYearOffsetInMillis(d)) break;
                    ++value;
                    break;
                }
                value = this.getMinimum(field);
                LocalGregorianCalendar.Date d = jcal.getCalendarDate(Long.MIN_VALUE, this.getZone());
                int y = d.getYear();
                if (y > 400) {
                    y -= 400;
                }
                jd.setYear(y);
                jcal.normalize(jd);
                if (this.getYearOffsetInMillis(jd) >= this.getYearOffsetInMillis(d)) break;
                ++value;
                break;
            }
            case 2: {
                if (eraIndex <= 1 || jd.getYear() != 1) break;
                long since = eras[eraIndex].getSince(this.getZone());
                LocalGregorianCalendar.Date d = jcal.getCalendarDate(since, this.getZone());
                value = d.getMonth() - 1;
                if (jd.getDayOfMonth() >= d.getDayOfMonth()) break;
                ++value;
                break;
            }
            case 3: {
                value = 1;
                LocalGregorianCalendar.Date d = jcal.getCalendarDate(Long.MIN_VALUE, this.getZone());
                ((CalendarDate)d).addYear(400);
                jcal.normalize(d);
                jd.setEra(d.getEra());
                jd.setYear(d.getYear());
                jcal.normalize(jd);
                long jan1 = jcal.getFixedDate(d);
                long fd = jcal.getFixedDate(jd);
                int woy = this.getWeekNumber(jan1, fd);
                long day1 = fd - (long)(7 * (woy - 1));
                if (day1 >= jan1 && (day1 != jan1 || jd.getTimeOfDay() >= d.getTimeOfDay())) break;
                ++value;
            }
        }
        return value;
    }

    @Override
    public int getActualMaximum(int field) {
        int fieldsForFixedMax = 130689;
        if ((0x1FE81 & 1 << field) != 0) {
            return this.getMaximum(field);
        }
        JapaneseImperialCalendar jc = this.getNormalizedCalendar();
        LocalGregorianCalendar.Date date = jc.jdate;
        int normalizedYear = date.getNormalizedYear();
        int value = -1;
        switch (field) {
            case 2: {
                value = 11;
                if (this.isTransitionYear(date.getNormalizedYear())) {
                    int eraIndex = JapaneseImperialCalendar.getEraIndex(date);
                    if (date.getYear() != 1) assert (++eraIndex < eras.length);
                    long fd = jc.cachedFixedDate;
                    long transition = sinceFixedDates[eraIndex];
                    if (fd >= transition) break;
                    LocalGregorianCalendar.Date ldate = (LocalGregorianCalendar.Date)date.clone();
                    jcal.getCalendarDateFromFixedDate(ldate, transition - 1L);
                    value = ldate.getMonth() - 1;
                    break;
                }
                LocalGregorianCalendar.Date d = jcal.getCalendarDate(Long.MAX_VALUE, this.getZone());
                if (date.getEra() != d.getEra() || date.getYear() != d.getYear()) break;
                value = d.getMonth() - 1;
                break;
            }
            case 5: {
                value = jcal.getMonthLength(date);
                break;
            }
            case 6: {
                if (this.isTransitionYear(date.getNormalizedYear())) {
                    int eraIndex = JapaneseImperialCalendar.getEraIndex(date);
                    if (date.getYear() != 1) assert (++eraIndex < eras.length);
                    long transition = sinceFixedDates[eraIndex];
                    long fd = jc.cachedFixedDate;
                    Gregorian.Date d = gcal.newCalendarDate(TimeZone.NO_TIMEZONE);
                    d.setDate(date.getNormalizedYear(), 1, 1);
                    if (fd < transition) {
                        value = (int)(transition - gcal.getFixedDate(d));
                        break;
                    }
                    d.addYear(1);
                    value = (int)(gcal.getFixedDate(d) - transition);
                    break;
                }
                LocalGregorianCalendar.Date d = jcal.getCalendarDate(Long.MAX_VALUE, this.getZone());
                if (date.getEra() == d.getEra() && date.getYear() == d.getYear()) {
                    long fd = jcal.getFixedDate(d);
                    long jan1 = this.getFixedDateJan1(d, fd);
                    value = (int)(fd - jan1) + 1;
                    break;
                }
                if (date.getYear() == this.getMinimum(1)) {
                    LocalGregorianCalendar.Date d1 = jcal.getCalendarDate(Long.MIN_VALUE, this.getZone());
                    long fd1 = jcal.getFixedDate(d1);
                    ((CalendarDate)d1).addYear(1);
                    d1.setMonth(1).setDayOfMonth(1);
                    jcal.normalize(d1);
                    long fd2 = jcal.getFixedDate(d1);
                    value = (int)(fd2 - fd1);
                    break;
                }
                value = jcal.getYearLength(date);
                break;
            }
            case 3: {
                if (!this.isTransitionYear(date.getNormalizedYear())) {
                    LocalGregorianCalendar.Date jd = jcal.getCalendarDate(Long.MAX_VALUE, this.getZone());
                    if (date.getEra() == jd.getEra() && date.getYear() == jd.getYear()) {
                        long fd = jcal.getFixedDate(jd);
                        long jan1 = this.getFixedDateJan1(jd, fd);
                        value = this.getWeekNumber(jan1, fd);
                        break;
                    }
                    if (date.getEra() == null && date.getYear() == this.getMinimum(1)) {
                        LocalGregorianCalendar.Date d = jcal.getCalendarDate(Long.MIN_VALUE, this.getZone());
                        ((CalendarDate)d).addYear(400);
                        jcal.normalize(d);
                        jd.setEra(d.getEra());
                        jd.setDate(d.getYear() + 1, 1, 1);
                        jcal.normalize(jd);
                        long jan1 = jcal.getFixedDate(d);
                        long nextJan1 = jcal.getFixedDate(jd);
                        long nextJan1st = LocalGregorianCalendar.getDayOfWeekDateOnOrBefore(nextJan1 + 6L, this.getFirstDayOfWeek());
                        int ndays = (int)(nextJan1st - nextJan1);
                        if (ndays >= this.getMinimalDaysInFirstWeek()) {
                            nextJan1st -= 7L;
                        }
                        value = this.getWeekNumber(jan1, nextJan1st);
                        break;
                    }
                    Gregorian.Date d = gcal.newCalendarDate(TimeZone.NO_TIMEZONE);
                    d.setDate(date.getNormalizedYear(), 1, 1);
                    int dayOfWeek = gcal.getDayOfWeek(d);
                    if ((dayOfWeek -= this.getFirstDayOfWeek()) < 0) {
                        dayOfWeek += 7;
                    }
                    value = 52;
                    int magic = dayOfWeek + this.getMinimalDaysInFirstWeek() - 1;
                    if (magic != 6 && (!date.isLeapYear() || magic != 5 && magic != 12)) break;
                    ++value;
                    break;
                }
                if (jc == this) {
                    jc = (JapaneseImperialCalendar)jc.clone();
                }
                int max = this.getActualMaximum(6);
                jc.set(6, max);
                value = jc.get(3);
                if (value != 1 || max <= 7) break;
                jc.add(3, -1);
                value = jc.get(3);
                break;
            }
            case 4: {
                LocalGregorianCalendar.Date jd = jcal.getCalendarDate(Long.MAX_VALUE, this.getZone());
                if (date.getEra() != jd.getEra() || date.getYear() != jd.getYear()) {
                    Gregorian.Date d = gcal.newCalendarDate(TimeZone.NO_TIMEZONE);
                    d.setDate(date.getNormalizedYear(), date.getMonth(), 1);
                    int dayOfWeek = gcal.getDayOfWeek(d);
                    int monthLength = gcal.getMonthLength(d);
                    if ((dayOfWeek -= this.getFirstDayOfWeek()) < 0) {
                        dayOfWeek += 7;
                    }
                    int nDaysFirstWeek = 7 - dayOfWeek;
                    value = 3;
                    if (nDaysFirstWeek >= this.getMinimalDaysInFirstWeek()) {
                        ++value;
                    }
                    if ((monthLength -= nDaysFirstWeek + 21) <= 0) break;
                    ++value;
                    if (monthLength <= 7) break;
                    ++value;
                    break;
                }
                long fd = jcal.getFixedDate(jd);
                long month1 = fd - (long)jd.getDayOfMonth() + 1L;
                value = this.getWeekNumber(month1, fd);
                break;
            }
            case 8: {
                int dow = date.getDayOfWeek();
                BaseCalendar.Date d = (BaseCalendar.Date)date.clone();
                int ndays = jcal.getMonthLength(d);
                d.setDayOfMonth(1);
                jcal.normalize(d);
                int dow1 = d.getDayOfWeek();
                int x = dow - dow1;
                if (x < 0) {
                    x += 7;
                }
                value = ((ndays -= x) + 6) / 7;
                break;
            }
            case 1: {
                LocalGregorianCalendar.Date d;
                LocalGregorianCalendar.Date jd = jcal.getCalendarDate(jc.getTimeInMillis(), this.getZone());
                int eraIndex = JapaneseImperialCalendar.getEraIndex(date);
                if (eraIndex == eras.length - 1) {
                    d = jcal.getCalendarDate(Long.MAX_VALUE, this.getZone());
                    value = d.getYear();
                    if (value > 400) {
                        ((CalendarDate)jd).setYear(value - 400);
                    }
                } else {
                    d = jcal.getCalendarDate(eras[eraIndex + 1].getSince(this.getZone()) - 1L, this.getZone());
                    value = d.getYear();
                    ((CalendarDate)jd).setYear(value);
                }
                jcal.normalize(jd);
                if (this.getYearOffsetInMillis(jd) <= this.getYearOffsetInMillis(d)) break;
                --value;
                break;
            }
            default: {
                throw new ArrayIndexOutOfBoundsException(field);
            }
        }
        return value;
    }

    private long getYearOffsetInMillis(CalendarDate date) {
        long t = (jcal.getDayOfYear(date) - 1L) * 86400000L;
        return t + date.getTimeOfDay() - (long)date.getZoneOffset();
    }

    @Override
    public Object clone() {
        JapaneseImperialCalendar other = (JapaneseImperialCalendar)super.clone();
        other.jdate = (LocalGregorianCalendar.Date)this.jdate.clone();
        other.originalFields = null;
        other.zoneOffsets = null;
        return other;
    }

    @Override
    public TimeZone getTimeZone() {
        TimeZone zone = super.getTimeZone();
        this.jdate.setZone(zone);
        return zone;
    }

    @Override
    public void setTimeZone(TimeZone zone) {
        super.setTimeZone(zone);
        this.jdate.setZone(zone);
    }

    @Override
    protected void computeFields() {
        int mask = 0;
        if (this.isPartiallyNormalized()) {
            mask = this.getSetStateFields();
            int fieldMask = ~mask & 0x1FFFF;
            if (fieldMask != 0 || this.cachedFixedDate == Long.MIN_VALUE) {
                mask |= this.computeFields(fieldMask, mask & 0x18000);
                assert (mask == 131071);
            }
        } else {
            mask = 131071;
            this.computeFields(mask, 0);
        }
        this.setFieldsComputed(mask);
    }

    private int computeFields(int fieldMask, int tzMask) {
        int zoneOffset = 0;
        TimeZone tz = this.getZone();
        if (this.zoneOffsets == null) {
            this.zoneOffsets = new int[2];
        }
        if (tzMask != 98304) {
            if (tz instanceof ZoneInfo) {
                zoneOffset = ((ZoneInfo)tz).getOffsets(this.time, this.zoneOffsets);
            } else {
                zoneOffset = tz.getOffset(this.time);
                this.zoneOffsets[0] = tz.getRawOffset();
                this.zoneOffsets[1] = zoneOffset - this.zoneOffsets[0];
            }
        }
        if (tzMask != 0) {
            if (JapaneseImperialCalendar.isFieldSet(tzMask, 15)) {
                this.zoneOffsets[0] = this.internalGet(15);
            }
            if (JapaneseImperialCalendar.isFieldSet(tzMask, 16)) {
                this.zoneOffsets[1] = this.internalGet(16);
            }
            zoneOffset = this.zoneOffsets[0] + this.zoneOffsets[1];
        }
        long fixedDate = (long)zoneOffset / 86400000L;
        int timeOfDay = zoneOffset % 86400000;
        fixedDate += this.time / 86400000L;
        if ((long)(timeOfDay += (int)(this.time % 86400000L)) >= 86400000L) {
            timeOfDay = (int)((long)timeOfDay - 86400000L);
            ++fixedDate;
        } else {
            while (timeOfDay < 0) {
                timeOfDay = (int)((long)timeOfDay + 86400000L);
                --fixedDate;
            }
        }
        if ((fixedDate += 719163L) != this.cachedFixedDate || fixedDate < 0L) {
            jcal.getCalendarDateFromFixedDate(this.jdate, fixedDate);
            this.cachedFixedDate = fixedDate;
        }
        int era = JapaneseImperialCalendar.getEraIndex(this.jdate);
        int year = this.jdate.getYear();
        this.internalSet(0, era);
        this.internalSet(1, year);
        int mask = fieldMask | 3;
        int month = this.jdate.getMonth() - 1;
        int dayOfMonth = this.jdate.getDayOfMonth();
        if ((fieldMask & 0xA4) != 0) {
            this.internalSet(2, month);
            this.internalSet(5, dayOfMonth);
            this.internalSet(7, this.jdate.getDayOfWeek());
            mask |= 0xA4;
        }
        if ((fieldMask & 0x7E00) != 0) {
            if (timeOfDay != 0) {
                int hours = timeOfDay / 3600000;
                this.internalSet(11, hours);
                this.internalSet(9, hours / 12);
                this.internalSet(10, hours % 12);
                int r = timeOfDay % 3600000;
                this.internalSet(12, r / 60000);
                this.internalSet(13, (r %= 60000) / 1000);
                this.internalSet(14, r % 1000);
            } else {
                this.internalSet(11, 0);
                this.internalSet(9, 0);
                this.internalSet(10, 0);
                this.internalSet(12, 0);
                this.internalSet(13, 0);
                this.internalSet(14, 0);
            }
            mask |= 0x7E00;
        }
        if ((fieldMask & 0x18000) != 0) {
            this.internalSet(15, this.zoneOffsets[0]);
            this.internalSet(16, this.zoneOffsets[1]);
            mask |= 0x18000;
        }
        if ((fieldMask & 0x158) != 0) {
            int dayOfYear;
            long fixedDateJan1;
            int normalizedYear = this.jdate.getNormalizedYear();
            boolean transitionYear = this.isTransitionYear(this.jdate.getNormalizedYear());
            if (transitionYear) {
                fixedDateJan1 = this.getFixedDateJan1(this.jdate, fixedDate);
                dayOfYear = (int)(fixedDate - fixedDateJan1) + 1;
            } else if (normalizedYear == MIN_VALUES[1]) {
                LocalGregorianCalendar.Date dx = jcal.getCalendarDate(Long.MIN_VALUE, this.getZone());
                fixedDateJan1 = jcal.getFixedDate(dx);
                dayOfYear = (int)(fixedDate - fixedDateJan1) + 1;
            } else {
                dayOfYear = (int)jcal.getDayOfYear(this.jdate);
                fixedDateJan1 = fixedDate - (long)dayOfYear + 1L;
            }
            long fixedDateMonth1 = transitionYear ? this.getFixedDateMonth1(this.jdate, fixedDate) : fixedDate - (long)dayOfMonth + 1L;
            this.internalSet(6, dayOfYear);
            this.internalSet(8, (dayOfMonth - 1) / 7 + 1);
            int weekOfYear = this.getWeekNumber(fixedDateJan1, fixedDate);
            if (weekOfYear == 0) {
                long prevJan1;
                long fixedDec31 = fixedDateJan1 - 1L;
                LocalGregorianCalendar.Date d = JapaneseImperialCalendar.getCalendarDate(fixedDec31);
                if (!transitionYear && !this.isTransitionYear(d.getNormalizedYear())) {
                    prevJan1 = fixedDateJan1 - 365L;
                    if (d.isLeapYear()) {
                        --prevJan1;
                    }
                } else if (transitionYear) {
                    if (this.jdate.getYear() == 1) {
                        if (era > 5) {
                            CalendarDate pd = eras[era - 1].getSinceDate();
                            if (normalizedYear == pd.getYear()) {
                                d.setMonth(pd.getMonth()).setDayOfMonth(pd.getDayOfMonth());
                            }
                        } else {
                            d.setMonth(1).setDayOfMonth(1);
                        }
                        jcal.normalize(d);
                        prevJan1 = jcal.getFixedDate(d);
                    } else {
                        prevJan1 = fixedDateJan1 - 365L;
                        if (d.isLeapYear()) {
                            --prevJan1;
                        }
                    }
                } else {
                    CalendarDate cd = eras[JapaneseImperialCalendar.getEraIndex(this.jdate)].getSinceDate();
                    d.setMonth(cd.getMonth()).setDayOfMonth(cd.getDayOfMonth());
                    jcal.normalize(d);
                    prevJan1 = jcal.getFixedDate(d);
                }
                weekOfYear = this.getWeekNumber(prevJan1, fixedDec31);
            } else if (!transitionYear) {
                if (weekOfYear >= 52) {
                    long nextJan1st;
                    int ndays;
                    long nextJan1 = fixedDateJan1 + 365L;
                    if (this.jdate.isLeapYear()) {
                        ++nextJan1;
                    }
                    if ((ndays = (int)((nextJan1st = LocalGregorianCalendar.getDayOfWeekDateOnOrBefore(nextJan1 + 6L, this.getFirstDayOfWeek())) - nextJan1)) >= this.getMinimalDaysInFirstWeek() && fixedDate >= nextJan1st - 7L) {
                        weekOfYear = 1;
                    }
                }
            } else {
                long nextJan1;
                LocalGregorianCalendar.Date d = (LocalGregorianCalendar.Date)this.jdate.clone();
                if (this.jdate.getYear() == 1) {
                    d.addYear(1);
                    d.setMonth(1).setDayOfMonth(1);
                    nextJan1 = jcal.getFixedDate(d);
                } else {
                    int nextEraIndex = JapaneseImperialCalendar.getEraIndex(d) + 1;
                    CalendarDate cd = eras[nextEraIndex].getSinceDate();
                    d.setEra(eras[nextEraIndex]);
                    d.setDate(1, cd.getMonth(), cd.getDayOfMonth());
                    jcal.normalize(d);
                    nextJan1 = jcal.getFixedDate(d);
                }
                long nextJan1st = LocalGregorianCalendar.getDayOfWeekDateOnOrBefore(nextJan1 + 6L, this.getFirstDayOfWeek());
                int ndays = (int)(nextJan1st - nextJan1);
                if (ndays >= this.getMinimalDaysInFirstWeek() && fixedDate >= nextJan1st - 7L) {
                    weekOfYear = 1;
                }
            }
            this.internalSet(3, weekOfYear);
            this.internalSet(4, this.getWeekNumber(fixedDateMonth1, fixedDate));
            mask |= 0x158;
        }
        return mask;
    }

    private int getWeekNumber(long fixedDay1, long fixedDate) {
        int normalizedDayOfPeriod;
        long fixedDay1st = LocalGregorianCalendar.getDayOfWeekDateOnOrBefore(fixedDay1 + 6L, this.getFirstDayOfWeek());
        int ndays = (int)(fixedDay1st - fixedDay1);
        assert (ndays <= 7);
        if (ndays >= this.getMinimalDaysInFirstWeek()) {
            fixedDay1st -= 7L;
        }
        if ((normalizedDayOfPeriod = (int)(fixedDate - fixedDay1st)) >= 0) {
            return normalizedDayOfPeriod / 7 + 1;
        }
        return CalendarUtils.floorDivide(normalizedDayOfPeriod, 7) + 1;
    }

    @Override
    protected void computeTime() {
        int tzMask;
        int year;
        int era;
        if (!this.isLenient()) {
            if (this.originalFields == null) {
                this.originalFields = new int[17];
            }
            for (int field = 0; field < 17; ++field) {
                int value = this.internalGet(field);
                if (this.isExternallySet(field) && (value < this.getMinimum(field) || value > this.getMaximum(field))) {
                    throw new IllegalArgumentException(JapaneseImperialCalendar.getFieldName(field));
                }
                this.originalFields[field] = value;
            }
        }
        int fieldMask = this.selectFields();
        if (this.isSet(0)) {
            era = this.internalGet(0);
            year = this.isSet(1) ? this.internalGet(1) : 1;
        } else if (this.isSet(1)) {
            era = currentEra;
            year = this.internalGet(1);
        } else {
            era = 3;
            year = 45;
        }
        long timeOfDay = 0L;
        if (JapaneseImperialCalendar.isFieldSet(fieldMask, 11)) {
            timeOfDay += (long)this.internalGet(11);
        } else {
            timeOfDay += (long)this.internalGet(10);
            if (JapaneseImperialCalendar.isFieldSet(fieldMask, 9)) {
                timeOfDay += (long)(12 * this.internalGet(9));
            }
        }
        timeOfDay *= 60L;
        timeOfDay += (long)this.internalGet(12);
        timeOfDay *= 60L;
        timeOfDay += (long)this.internalGet(13);
        timeOfDay *= 1000L;
        long fixedDate = (timeOfDay += (long)this.internalGet(14)) / 86400000L;
        timeOfDay %= 86400000L;
        while (timeOfDay < 0L) {
            timeOfDay += 86400000L;
            --fixedDate;
        }
        long millis = ((fixedDate += this.getFixedDate(era, year, fieldMask)) - 719163L) * 86400000L + timeOfDay;
        TimeZone zone = this.getZone();
        if (this.zoneOffsets == null) {
            this.zoneOffsets = new int[2];
        }
        if ((tzMask = fieldMask & 0x18000) != 98304) {
            if (zone instanceof ZoneInfo) {
                ((ZoneInfo)zone).getOffsetsByWall(millis, this.zoneOffsets);
            } else {
                zone.getOffsets(millis - (long)zone.getRawOffset(), this.zoneOffsets);
            }
        }
        if (tzMask != 0) {
            if (JapaneseImperialCalendar.isFieldSet(tzMask, 15)) {
                this.zoneOffsets[0] = this.internalGet(15);
            }
            if (JapaneseImperialCalendar.isFieldSet(tzMask, 16)) {
                this.zoneOffsets[1] = this.internalGet(16);
            }
        }
        this.time = millis -= (long)(this.zoneOffsets[0] + this.zoneOffsets[1]);
        int mask = this.computeFields(fieldMask | this.getSetStateFields(), tzMask);
        if (!this.isLenient()) {
            for (int field = 0; field < 17; ++field) {
                if (!this.isExternallySet(field) || this.originalFields[field] == this.internalGet(field)) continue;
                int wrongValue = this.internalGet(field);
                System.arraycopy(this.originalFields, 0, this.fields, 0, this.fields.length);
                throw new IllegalArgumentException(JapaneseImperialCalendar.getFieldName(field) + "=" + wrongValue + ", expected " + this.originalFields[field]);
            }
        }
        this.setFieldsNormalized(mask);
    }

    private long getFixedDate(int era, int year, int fieldMask) {
        int month = 0;
        int firstDayOfMonth = 1;
        if (JapaneseImperialCalendar.isFieldSet(fieldMask, 2)) {
            month = this.internalGet(2);
            if (month > 11) {
                year += month / 12;
                month %= 12;
            } else if (month < 0) {
                int[] rem = new int[1];
                year += CalendarUtils.floorDivide(month, 12, rem);
                month = rem[0];
            }
        } else if (year == 1 && era != 0) {
            CalendarDate d = eras[era].getSinceDate();
            month = d.getMonth() - 1;
            firstDayOfMonth = d.getDayOfMonth();
        }
        if (year == MIN_VALUES[1]) {
            LocalGregorianCalendar.Date dx = jcal.getCalendarDate(Long.MIN_VALUE, this.getZone());
            int m = dx.getMonth() - 1;
            if (month < m) {
                month = m;
            }
            if (month == m) {
                firstDayOfMonth = dx.getDayOfMonth();
            }
        }
        LocalGregorianCalendar.Date date = jcal.newCalendarDate(TimeZone.NO_TIMEZONE);
        date.setEra(era > 0 ? eras[era] : null);
        date.setDate(year, month + 1, firstDayOfMonth);
        jcal.normalize(date);
        long fixedDate = jcal.getFixedDate(date);
        if (JapaneseImperialCalendar.isFieldSet(fieldMask, 2)) {
            if (JapaneseImperialCalendar.isFieldSet(fieldMask, 5)) {
                if (this.isSet(5)) {
                    fixedDate += (long)this.internalGet(5);
                    fixedDate -= (long)firstDayOfMonth;
                }
            } else if (JapaneseImperialCalendar.isFieldSet(fieldMask, 4)) {
                long firstDayOfWeek = LocalGregorianCalendar.getDayOfWeekDateOnOrBefore(fixedDate + 6L, this.getFirstDayOfWeek());
                if (firstDayOfWeek - fixedDate >= (long)this.getMinimalDaysInFirstWeek()) {
                    firstDayOfWeek -= 7L;
                }
                if (JapaneseImperialCalendar.isFieldSet(fieldMask, 7)) {
                    firstDayOfWeek = LocalGregorianCalendar.getDayOfWeekDateOnOrBefore(firstDayOfWeek + 6L, this.internalGet(7));
                }
                fixedDate = firstDayOfWeek + (long)(7 * (this.internalGet(4) - 1));
            } else {
                int dayOfWeek = JapaneseImperialCalendar.isFieldSet(fieldMask, 7) ? this.internalGet(7) : this.getFirstDayOfWeek();
                int dowim = JapaneseImperialCalendar.isFieldSet(fieldMask, 8) ? this.internalGet(8) : 1;
                if (dowim >= 0) {
                    fixedDate = LocalGregorianCalendar.getDayOfWeekDateOnOrBefore(fixedDate + (long)(7 * dowim) - 1L, dayOfWeek);
                } else {
                    int lastDate = this.monthLength(month, year) + 7 * (dowim + 1);
                    fixedDate = LocalGregorianCalendar.getDayOfWeekDateOnOrBefore(fixedDate + (long)lastDate - 1L, dayOfWeek);
                }
            }
        } else if (JapaneseImperialCalendar.isFieldSet(fieldMask, 6)) {
            if (this.isTransitionYear(date.getNormalizedYear())) {
                fixedDate = this.getFixedDateJan1(date, fixedDate);
            }
            fixedDate += (long)this.internalGet(6);
            --fixedDate;
        } else {
            int dayOfWeek;
            long firstDayOfWeek = LocalGregorianCalendar.getDayOfWeekDateOnOrBefore(fixedDate + 6L, this.getFirstDayOfWeek());
            if (firstDayOfWeek - fixedDate >= (long)this.getMinimalDaysInFirstWeek()) {
                firstDayOfWeek -= 7L;
            }
            if (JapaneseImperialCalendar.isFieldSet(fieldMask, 7) && (dayOfWeek = this.internalGet(7)) != this.getFirstDayOfWeek()) {
                firstDayOfWeek = LocalGregorianCalendar.getDayOfWeekDateOnOrBefore(firstDayOfWeek + 6L, dayOfWeek);
            }
            fixedDate = firstDayOfWeek + 7L * ((long)this.internalGet(3) - 1L);
        }
        return fixedDate;
    }

    private long getFixedDateJan1(LocalGregorianCalendar.Date date, long fixedDate) {
        Era era = date.getEra();
        if (date.getEra() != null && date.getYear() == 1) {
            for (int eraIndex = JapaneseImperialCalendar.getEraIndex(date); eraIndex > 0; --eraIndex) {
                CalendarDate d = eras[eraIndex].getSinceDate();
                long fd = gcal.getFixedDate(d);
                if (fd > fixedDate) continue;
                return fd;
            }
        }
        Gregorian.Date d = gcal.newCalendarDate(TimeZone.NO_TIMEZONE);
        d.setDate(date.getNormalizedYear(), 1, 1);
        return gcal.getFixedDate(d);
    }

    private long getFixedDateMonth1(LocalGregorianCalendar.Date date, long fixedDate) {
        long transition;
        int eraIndex = JapaneseImperialCalendar.getTransitionEraIndex(date);
        if (eraIndex != -1 && (transition = sinceFixedDates[eraIndex]) <= fixedDate) {
            return transition;
        }
        return fixedDate - (long)date.getDayOfMonth() + 1L;
    }

    private static LocalGregorianCalendar.Date getCalendarDate(long fd) {
        LocalGregorianCalendar.Date d = jcal.newCalendarDate(TimeZone.NO_TIMEZONE);
        jcal.getCalendarDateFromFixedDate(d, fd);
        return d;
    }

    private int monthLength(int month, int gregorianYear) {
        return CalendarUtils.isGregorianLeapYear(gregorianYear) ? GregorianCalendar.LEAP_MONTH_LENGTH[month] : GregorianCalendar.MONTH_LENGTH[month];
    }

    private int monthLength(int month) {
        assert (this.jdate.isNormalized());
        return this.jdate.isLeapYear() ? GregorianCalendar.LEAP_MONTH_LENGTH[month] : GregorianCalendar.MONTH_LENGTH[month];
    }

    private int actualMonthLength() {
        int length = jcal.getMonthLength(this.jdate);
        int eraIndex = JapaneseImperialCalendar.getTransitionEraIndex(this.jdate);
        if (eraIndex == -1) {
            long transitionFixedDate = sinceFixedDates[eraIndex];
            CalendarDate d = eras[eraIndex].getSinceDate();
            length = transitionFixedDate <= this.cachedFixedDate ? (length -= d.getDayOfMonth() - 1) : d.getDayOfMonth() - 1;
        }
        return length;
    }

    private static int getTransitionEraIndex(LocalGregorianCalendar.Date date) {
        int eraIndex = JapaneseImperialCalendar.getEraIndex(date);
        CalendarDate transitionDate = eras[eraIndex].getSinceDate();
        if (transitionDate.getYear() == date.getNormalizedYear() && transitionDate.getMonth() == date.getMonth()) {
            return eraIndex;
        }
        if (eraIndex < eras.length - 1 && (transitionDate = eras[++eraIndex].getSinceDate()).getYear() == date.getNormalizedYear() && transitionDate.getMonth() == date.getMonth()) {
            return eraIndex;
        }
        return -1;
    }

    private boolean isTransitionYear(int normalizedYear) {
        for (int i = eras.length - 1; i > 0; --i) {
            int transitionYear = eras[i].getSinceDate().getYear();
            if (normalizedYear == transitionYear) {
                return true;
            }
            if (normalizedYear > transitionYear) break;
        }
        return false;
    }

    private static int getEraIndex(LocalGregorianCalendar.Date date) {
        Era era = date.getEra();
        for (int i = eras.length - 1; i > 0; --i) {
            if (eras[i] != era) continue;
            return i;
        }
        return 0;
    }

    private JapaneseImperialCalendar getNormalizedCalendar() {
        JapaneseImperialCalendar jc;
        if (this.isFullyNormalized()) {
            jc = this;
        } else {
            jc = (JapaneseImperialCalendar)this.clone();
            jc.setLenient(true);
            jc.complete();
        }
        return jc;
    }

    private void pinDayOfMonth(LocalGregorianCalendar.Date date) {
        int year = date.getYear();
        int dom = date.getDayOfMonth();
        if (year != this.getMinimum(1)) {
            date.setDayOfMonth(1);
            jcal.normalize(date);
            int monthLength = jcal.getMonthLength(date);
            if (dom > monthLength) {
                date.setDayOfMonth(monthLength);
            } else {
                date.setDayOfMonth(dom);
            }
            jcal.normalize(date);
        } else {
            LocalGregorianCalendar.Date d = jcal.getCalendarDate(Long.MIN_VALUE, this.getZone());
            LocalGregorianCalendar.Date realDate = jcal.getCalendarDate(this.time, this.getZone());
            long tod = realDate.getTimeOfDay();
            realDate.addYear(400);
            realDate.setMonth(date.getMonth());
            realDate.setDayOfMonth(1);
            jcal.normalize(realDate);
            int monthLength = jcal.getMonthLength(realDate);
            if (dom > monthLength) {
                realDate.setDayOfMonth(monthLength);
            } else if (dom < d.getDayOfMonth()) {
                realDate.setDayOfMonth(d.getDayOfMonth());
            } else {
                realDate.setDayOfMonth(dom);
            }
            if (realDate.getDayOfMonth() == d.getDayOfMonth() && tod < d.getTimeOfDay()) {
                realDate.setDayOfMonth(Math.min(dom + 1, monthLength));
            }
            date.setDate(year, realDate.getMonth(), realDate.getDayOfMonth());
        }
    }

    private static int getRolledValue(int value, int amount, int min, int max) {
        assert (value >= min && value <= max);
        int range = max - min + 1;
        int n = value + (amount %= range);
        if (n > max) {
            n -= range;
        } else if (n < min) {
            n += range;
        }
        assert (n >= min && n <= max);
        return n;
    }

    private int internalGetEra() {
        return this.isSet(0) ? this.internalGet(0) : currentEra;
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        if (this.jdate == null) {
            this.jdate = jcal.newCalendarDate(this.getZone());
            this.cachedFixedDate = Long.MIN_VALUE;
        }
    }

    static {
        int index;
        jcal = (LocalGregorianCalendar)CalendarSystem.forName("japanese");
        gcal = CalendarSystem.getGregorianCalendar();
        BEFORE_MEIJI_ERA = new Era("BeforeMeiji", "BM", Long.MIN_VALUE, false);
        MIN_VALUES = new int[]{0, -292275055, 0, 1, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, -46800000, 0};
        LEAST_MAX_VALUES = new int[]{0, 0, 0, 0, 4, 28, 0, 7, 4, 1, 11, 23, 59, 59, 999, 50400000, 1200000};
        MAX_VALUES = new int[]{0, 292278994, 11, 53, 6, 31, 366, 7, 6, 1, 11, 23, 59, 59, 999, 50400000, 0x6DDD00};
        Era[] es = jcal.getEras();
        int length = es.length + 1;
        eras = new Era[length];
        sinceFixedDates = new long[length];
        int current = index = 0;
        JapaneseImperialCalendar.sinceFixedDates[index] = gcal.getFixedDate(BEFORE_MEIJI_ERA.getSinceDate());
        JapaneseImperialCalendar.eras[index++] = BEFORE_MEIJI_ERA;
        for (Era e : es) {
            if (e.getSince(TimeZone.NO_TIMEZONE) < System.currentTimeMillis()) {
                current = index;
            }
            CalendarDate d = e.getSinceDate();
            JapaneseImperialCalendar.sinceFixedDates[index] = gcal.getFixedDate(d);
            JapaneseImperialCalendar.eras[index++] = e;
        }
        currentEra = current;
        JapaneseImperialCalendar.LEAST_MAX_VALUES[0] = JapaneseImperialCalendar.MAX_VALUES[0] = eras.length - 1;
        int year = Integer.MAX_VALUE;
        int dayOfYear = Integer.MAX_VALUE;
        Gregorian.Date date = gcal.newCalendarDate(TimeZone.NO_TIMEZONE);
        for (int i = 1; i < eras.length; ++i) {
            long fd = sinceFixedDates[i];
            CalendarDate transitionDate = eras[i].getSinceDate();
            date.setDate(transitionDate.getYear(), 1, 1);
            long fdd = gcal.getFixedDate(date);
            dayOfYear = Math.min((int)(fdd - fd), dayOfYear);
            date.setDate(transitionDate.getYear(), 12, 31);
            fdd = gcal.getFixedDate(date) + 1L;
            dayOfYear = Math.min((int)(fd - fdd), dayOfYear);
            LocalGregorianCalendar.Date lgd = JapaneseImperialCalendar.getCalendarDate(fd - 1L);
            int y = lgd.getYear();
            if (lgd.getMonth() != 1 || lgd.getDayOfMonth() != 1) {
                --y;
            }
            year = Math.min(y, year);
        }
        JapaneseImperialCalendar.LEAST_MAX_VALUES[1] = year;
        JapaneseImperialCalendar.LEAST_MAX_VALUES[6] = dayOfYear;
    }
}

