/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import javax.naming.Binding;
import javax.naming.NameClassPair;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import org.apache.catalina.Context;
import org.apache.catalina.util.Extension;
import org.apache.catalina.util.ManifestResource;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.naming.resources.Resource;
import org.apache.tomcat.util.ExceptionUtils;
import org.apache.tomcat.util.res.StringManager;

public final class ExtensionValidator {
    private static final Log log = LogFactory.getLog(ExtensionValidator.class);
    private static final StringManager sm = StringManager.getManager((String)"org.apache.catalina.util");
    private static volatile ArrayList<Extension> containerAvailableExtensions = null;
    private static ArrayList<ManifestResource> containerManifestResources = new ArrayList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized boolean validateApplication(DirContext dirContext, Context context) throws IOException {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        NamingEnumeration<Binding> namingEnumeration;
        String string = context.getName();
        ArrayList<ManifestResource> arrayList = new ArrayList<ManifestResource>();
        if (dirContext == null) {
            return false;
        }
        InputStream inputStream = null;
        try {
            namingEnumeration = dirContext.listBindings("/META-INF/");
            object4 = (Binding)namingEnumeration.nextElement();
            if (((NameClassPair)object4).getName().toUpperCase(Locale.ENGLISH).equals("MANIFEST.MF")) {
                object3 = (Resource)dirContext.lookup("/META-INF/" + ((NameClassPair)object4).getName());
                inputStream = ((Resource)object3).streamContent();
                object2 = new Manifest(inputStream);
                inputStream.close();
                inputStream = null;
                object = new ManifestResource(sm.getString("extensionValidator.web-application-manifest"), (Manifest)object2, 2);
                arrayList.add((ManifestResource)object);
            }
        }
        catch (NamingException namingException) {
        }
        catch (NoSuchElementException noSuchElementException) {
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (Throwable throwable) {
                    ExceptionUtils.handleThrowable((Throwable)throwable);
                }
            }
        }
        namingEnumeration = null;
        object4 = null;
        try {
            namingEnumeration = dirContext.listBindings("WEB-INF/lib/");
            while (namingEnumeration != null && namingEnumeration.hasMoreElements()) {
                Manifest manifest;
                object3 = (Binding)namingEnumeration.nextElement();
                object4 = ((NameClassPair)object3).getName();
                if (!((String)object4).toLowerCase(Locale.ENGLISH).endsWith(".jar") || !((object2 = dirContext.lookup("/WEB-INF/lib/" + (String)object4)) instanceof Resource) || (manifest = ExtensionValidator.getManifest(inputStream = ((Resource)(object = (Resource)object2)).streamContent())) == null) continue;
                ManifestResource manifestResource = new ManifestResource((String)object4, manifest, 3);
                arrayList.add(manifestResource);
            }
        }
        catch (NamingException namingException) {
        }
        catch (IOException iOException) {
            throw new IOException("Jar: " + (String)object4, iOException);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (Throwable throwable) {
                    ExceptionUtils.handleThrowable((Throwable)throwable);
                }
            }
        }
        return ExtensionValidator.validateManifestResources(string, arrayList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addSystemResource(File file) throws IOException {
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
            Manifest manifest = ExtensionValidator.getManifest(fileInputStream);
            if (manifest != null) {
                ManifestResource manifestResource = new ManifestResource(file.getAbsolutePath(), manifest, 1);
                containerManifestResources.add(manifestResource);
            }
        }
        finally {
            if (fileInputStream != null) {
                try {
                    ((InputStream)fileInputStream).close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private static boolean validateManifestResources(String string, ArrayList<ManifestResource> arrayList) {
        boolean bl = true;
        int n = 0;
        ArrayList<Extension> arrayList2 = null;
        for (ManifestResource manifestResource : arrayList) {
            ArrayList<Extension> arrayList3 = manifestResource.getRequiredExtensions();
            if (arrayList3 == null) continue;
            if (arrayList2 == null) {
                arrayList2 = ExtensionValidator.buildAvailableExtensionsList(arrayList);
            }
            if (containerAvailableExtensions == null) {
                containerAvailableExtensions = ExtensionValidator.buildAvailableExtensionsList(containerManifestResources);
            }
            Iterator<Extension> iterator = arrayList3.iterator();
            while (iterator.hasNext()) {
                boolean bl2 = false;
                Extension extension = iterator.next();
                if (arrayList2 != null) {
                    for (Extension extension2 : arrayList2) {
                        if (!extension2.isCompatibleWith(extension)) continue;
                        extension.setFulfilled(true);
                        bl2 = true;
                        break;
                    }
                }
                if (!bl2 && containerAvailableExtensions != null) {
                    for (Extension extension2 : containerAvailableExtensions) {
                        if (!extension2.isCompatibleWith(extension)) continue;
                        extension.setFulfilled(true);
                        bl2 = true;
                        break;
                    }
                }
                if (bl2) continue;
                log.info((Object)sm.getString("extensionValidator.extension-not-found-error", new Object[]{string, manifestResource.getResourceName(), extension.getExtensionName()}));
                bl = false;
                ++n;
            }
        }
        if (!bl) {
            log.info((Object)sm.getString("extensionValidator.extension-validation-error", new Object[]{string, n + ""}));
        }
        return bl;
    }

    private static ArrayList<Extension> buildAvailableExtensionsList(ArrayList<ManifestResource> arrayList) {
        ArrayList<Extension> arrayList2 = null;
        for (ManifestResource manifestResource : arrayList) {
            ArrayList<Extension> arrayList3 = manifestResource.getAvailableExtensions();
            if (arrayList3 == null) continue;
            for (Extension extension : arrayList3) {
                if (arrayList2 == null) {
                    arrayList2 = new ArrayList<Extension>();
                    arrayList2.add(extension);
                    continue;
                }
                arrayList2.add(extension);
            }
        }
        return arrayList2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Manifest getManifest(InputStream inputStream) throws IOException {
        Manifest manifest = null;
        JarInputStream jarInputStream = null;
        try {
            jarInputStream = new JarInputStream(inputStream);
            manifest = jarInputStream.getManifest();
            jarInputStream.close();
            jarInputStream = null;
        }
        finally {
            if (jarInputStream != null) {
                try {
                    jarInputStream.close();
                }
                catch (Throwable throwable) {
                    ExceptionUtils.handleThrowable((Throwable)throwable);
                }
            }
        }
        return manifest;
    }

    private static void addFolderList(String string) {
        String string2 = System.getProperty(string);
        if (string2 != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string2, File.pathSeparator);
            while (stringTokenizer.hasMoreTokens()) {
                File[] fileArray;
                File file = new File(stringTokenizer.nextToken());
                if (!file.isDirectory() || (fileArray = file.listFiles()) == null) continue;
                for (File file2 : fileArray) {
                    if (!file2.getName().toLowerCase(Locale.ENGLISH).endsWith(".jar") || !file2.isFile()) continue;
                    try {
                        ExtensionValidator.addSystemResource(file2);
                    }
                    catch (IOException iOException) {
                        log.error((Object)sm.getString("extensionValidator.failload", new Object[]{file2}), (Throwable)iOException);
                    }
                }
            }
        }
    }

    static {
        String string = System.getProperty("java.class.path");
        StringTokenizer stringTokenizer = new StringTokenizer(string, File.pathSeparator);
        while (stringTokenizer.hasMoreTokens()) {
            File file;
            String string2 = stringTokenizer.nextToken();
            if (!string2.toLowerCase(Locale.ENGLISH).endsWith(".jar") || !(file = new File(string2)).isFile()) continue;
            try {
                ExtensionValidator.addSystemResource(file);
            }
            catch (IOException iOException) {
                log.error((Object)sm.getString("extensionValidator.failload", new Object[]{file}), (Throwable)iOException);
            }
        }
        ExtensionValidator.addFolderList("java.ext.dirs");
    }
}

