/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.valves;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.InetAddress;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.TimeZone;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpSession;
import org.apache.catalina.AccessLog;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleState;
import org.apache.catalina.Session;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.valves.ValveBase;
import org.apache.coyote.RequestInfo;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.ExceptionUtils;
import org.apache.tomcat.util.buf.B2CConverter;

public class AccessLogValve
extends ValveBase
implements AccessLog {
    private static final Log log = LogFactory.getLog(AccessLogValve.class);
    private volatile String dateStamp = "";
    private String directory = "logs";
    protected static final String info = "org.apache.catalina.valves.AccessLogValve/2.2";
    protected boolean enabled = true;
    protected String pattern = null;
    protected volatile String prefix = "access_log.";
    protected boolean rotatable = true;
    protected boolean renameOnRotate = false;
    private boolean buffered = true;
    protected volatile String suffix = "";
    protected PrintWriter writer = null;
    protected SimpleDateFormat fileDateFormatter = null;
    private static final int globalCacheSize = 300;
    private static final int localCacheSize = 60;
    protected File currentLogFile = null;
    private static final DateFormatCache globalDateCache = new DateFormatCache(300, Locale.getDefault(), null);
    private static final ThreadLocal<DateFormatCache> localDateCache = new ThreadLocal<DateFormatCache>(){

        @Override
        protected DateFormatCache initialValue() {
            return new DateFormatCache(60, Locale.getDefault(), globalDateCache);
        }
    };
    private static final ThreadLocal<Date> localDate = new ThreadLocal<Date>(){

        @Override
        protected Date initialValue() {
            return new Date();
        }
    };
    private boolean resolveHosts = false;
    private volatile long rotationLastChecked = 0L;
    private boolean checkExists = false;
    protected String condition = null;
    protected String conditionIf = null;
    protected String fileDateFormat = "yyyy-MM-dd";
    protected String localeName = Locale.getDefault().toString();
    protected Locale locale = Locale.getDefault();
    protected volatile String encoding = null;
    protected AccessLogElement[] logElements = null;
    protected boolean requestAttributesEnabled = false;
    private int maxDays = -1;
    private volatile boolean checkForOldLogs = false;

    public AccessLogValve() {
        super(true);
    }

    public int getMaxDays() {
        return this.maxDays;
    }

    public void setMaxDays(int n) {
        this.maxDays = n;
    }

    public boolean getEnabled() {
        return this.enabled;
    }

    @Override
    public void setRequestAttributesEnabled(boolean bl) {
        this.requestAttributesEnabled = bl;
    }

    @Override
    public boolean getRequestAttributesEnabled() {
        return this.requestAttributesEnabled;
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    public String getDirectory() {
        return this.directory;
    }

    public void setDirectory(String string) {
        this.directory = string;
    }

    @Override
    public String getInfo() {
        return info;
    }

    public String getPattern() {
        return this.pattern;
    }

    public void setPattern(String string) {
        this.pattern = string == null ? "" : (string.equals("common") ? "%h %l %u %t \"%r\" %s %b" : (string.equals("combined") ? "%h %l %u %t \"%r\" %s %b \"%{Referer}i\" \"%{User-Agent}i\"" : string));
        this.logElements = this.createLogElements();
    }

    public boolean isCheckExists() {
        return this.checkExists;
    }

    public void setCheckExists(boolean bl) {
        this.checkExists = bl;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String string) {
        this.prefix = string;
    }

    public boolean isRotatable() {
        return this.rotatable;
    }

    public void setRotatable(boolean bl) {
        this.rotatable = bl;
    }

    public boolean isRenameOnRotate() {
        return this.renameOnRotate;
    }

    public void setRenameOnRotate(boolean bl) {
        this.renameOnRotate = bl;
    }

    public boolean isBuffered() {
        return this.buffered;
    }

    public void setBuffered(boolean bl) {
        this.buffered = bl;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public void setSuffix(String string) {
        this.suffix = string;
    }

    @Deprecated
    public void setResolveHosts(boolean bl) {
        this.resolveHosts = bl;
    }

    @Deprecated
    public boolean isResolveHosts() {
        return this.resolveHosts;
    }

    public String getCondition() {
        return this.condition;
    }

    public void setCondition(String string) {
        this.condition = string;
    }

    public String getConditionUnless() {
        return this.getCondition();
    }

    public void setConditionUnless(String string) {
        this.setCondition(string);
    }

    public String getConditionIf() {
        return this.conditionIf;
    }

    public void setConditionIf(String string) {
        this.conditionIf = string;
    }

    public String getFileDateFormat() {
        return this.fileDateFormat;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFileDateFormat(String string) {
        String string2 = string == null ? "" : string;
        this.fileDateFormat = string2;
        AccessLogValve accessLogValve = this;
        synchronized (accessLogValve) {
            this.fileDateFormatter = new SimpleDateFormat(string2, Locale.US);
            this.fileDateFormatter.setTimeZone(TimeZone.getDefault());
        }
    }

    public String getLocale() {
        return this.localeName;
    }

    public void setLocale(String string) {
        this.localeName = string;
        this.locale = AccessLogValve.findLocale(string, this.locale);
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String string) {
        this.encoding = string != null && string.length() > 0 ? string : null;
    }

    @Override
    public synchronized void backgroundProcess() {
        if (this.getState().isAvailable() && this.getEnabled() && this.writer != null && this.buffered) {
            this.writer.flush();
        }
        int n = this.maxDays;
        String string = this.prefix;
        String string2 = this.suffix;
        if (this.rotatable && this.checkForOldLogs && n > 0) {
            String[] stringArray;
            long l = System.currentTimeMillis() - (long)n * 24L * 60L * 60L * 1000L;
            File file = this.getDirectoryFile();
            if (file.isDirectory() && (stringArray = file.list()) != null) {
                for (String string3 : stringArray) {
                    File file2;
                    boolean bl = false;
                    if (string != null && string.length() > 0) {
                        if (!string3.startsWith(string)) continue;
                        bl = true;
                    }
                    if (string2 != null && string2.length() > 0) {
                        if (!string3.endsWith(string2)) continue;
                        bl = true;
                    }
                    if (!bl || !(file2 = new File(file, string3)).isFile() || file2.lastModified() >= l || file2.delete()) continue;
                    log.warn((Object)sm.getString("accessLogValve.deleteFail", new Object[]{file2.getAbsolutePath()}));
                }
            }
            this.checkForOldLogs = false;
        }
    }

    @Override
    public void invoke(Request request, Response response) throws IOException, ServletException {
        this.getNext().invoke(request, response);
    }

    @Override
    public void log(Request request, Response response, long l) {
        if (!this.getState().isAvailable() || !this.getEnabled() || this.logElements == null || this.condition != null && null != request.getRequest().getAttribute(this.condition) || this.conditionIf != null && null == request.getRequest().getAttribute(this.conditionIf)) {
            return;
        }
        long l2 = request.getCoyoteRequest().getStartTime();
        Date date = AccessLogValve.getDate(l2 + l);
        StringBuilder stringBuilder = new StringBuilder(128);
        for (int i = 0; i < this.logElements.length; ++i) {
            this.logElements[i].addElement(stringBuilder, date, request, response, l);
        }
        this.log(stringBuilder.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rotate() {
        long l;
        if (this.rotatable && (l = System.currentTimeMillis()) - this.rotationLastChecked > 1000L) {
            AccessLogValve accessLogValve = this;
            synchronized (accessLogValve) {
                if (l - this.rotationLastChecked > 1000L) {
                    this.rotationLastChecked = l;
                    String string = this.fileDateFormatter.format(new Date(l));
                    if (!this.dateStamp.equals(string)) {
                        this.close(true);
                        this.dateStamp = string;
                        this.open();
                    }
                }
            }
        }
    }

    public synchronized boolean rotate(String string) {
        if (this.currentLogFile != null) {
            File file = this.currentLogFile;
            this.close(false);
            try {
                file.renameTo(new File(string));
            }
            catch (Throwable throwable) {
                ExceptionUtils.handleThrowable((Throwable)throwable);
                log.error((Object)sm.getString("accessLogValve.rotateFail"), throwable);
            }
            this.dateStamp = this.fileDateFormatter.format(new Date(System.currentTimeMillis()));
            this.open();
            return true;
        }
        return false;
    }

    private File getDirectoryFile() {
        File file = new File(this.directory);
        if (!file.isAbsolute()) {
            file = new File(System.getProperty("catalina.base"), this.directory);
        }
        return file;
    }

    private File getLogFile(boolean bl) {
        File file;
        File file2;
        File file3 = this.getDirectoryFile();
        if (!file3.mkdirs() && !file3.isDirectory()) {
            log.error((Object)sm.getString("accessLogValve.openDirFail", new Object[]{file3}));
        }
        if (!(file2 = (file = bl ? new File(file3.getAbsoluteFile(), this.prefix + this.dateStamp + this.suffix) : new File(file3.getAbsoluteFile(), this.prefix + this.suffix)).getParentFile()).mkdirs() && !file2.isDirectory()) {
            log.error((Object)sm.getString("accessLogValve.openDirFail", new Object[]{file2}));
        }
        return file;
    }

    private void restore() {
        File file = this.getLogFile(false);
        File file2 = this.getLogFile(true);
        if (file2.exists() && !file.exists() && !file2.equals(file)) {
            try {
                if (!file2.renameTo(file)) {
                    log.error((Object)sm.getString("accessLogValve.renameFail", new Object[]{file2, file}));
                }
            }
            catch (Throwable throwable) {
                ExceptionUtils.handleThrowable((Throwable)throwable);
                log.error((Object)sm.getString("accessLogValve.renameFail", new Object[]{file2, file}), throwable);
            }
        }
    }

    private synchronized void close(boolean bl) {
        if (this.writer == null) {
            return;
        }
        this.writer.flush();
        this.writer.close();
        if (bl && this.renameOnRotate) {
            File file = this.getLogFile(true);
            if (!file.exists()) {
                try {
                    if (!this.currentLogFile.renameTo(file)) {
                        log.error((Object)sm.getString("accessLogValve.renameFail", new Object[]{this.currentLogFile, file}));
                    }
                }
                catch (Throwable throwable) {
                    ExceptionUtils.handleThrowable((Throwable)throwable);
                    log.error((Object)sm.getString("accessLogValve.renameFail", new Object[]{this.currentLogFile, file}), throwable);
                }
            } else {
                log.error((Object)sm.getString("accessLogValve.alreadyExists", new Object[]{this.currentLogFile, file}));
            }
        }
        this.writer = null;
        this.dateStamp = "";
        this.currentLogFile = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void log(String string) {
        AccessLogValve accessLogValve;
        this.rotate();
        if (this.checkExists) {
            accessLogValve = this;
            synchronized (accessLogValve) {
                if (this.currentLogFile != null && !this.currentLogFile.exists()) {
                    try {
                        this.close(false);
                    }
                    catch (Throwable throwable) {
                        ExceptionUtils.handleThrowable((Throwable)throwable);
                        log.info((Object)sm.getString("accessLogValve.closeFail"), throwable);
                    }
                    this.dateStamp = this.fileDateFormatter.format(new Date(System.currentTimeMillis()));
                    this.open();
                }
            }
        }
        accessLogValve = this;
        synchronized (accessLogValve) {
            if (this.writer != null) {
                this.writer.println(string);
                if (!this.buffered) {
                    this.writer.flush();
                }
            }
        }
    }

    protected synchronized void open() {
        File file = this.getLogFile(this.rotatable && !this.renameOnRotate);
        Charset charset = null;
        if (this.encoding != null) {
            try {
                charset = B2CConverter.getCharset((String)this.encoding);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                log.error((Object)sm.getString("accessLogValve.unsupportedEncoding", new Object[]{this.encoding}), (Throwable)unsupportedEncodingException);
            }
        }
        if (charset == null) {
            charset = Charset.defaultCharset();
        }
        try {
            this.writer = new PrintWriter((Writer)new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file, true), charset), 128000), false);
            this.currentLogFile = file;
        }
        catch (IOException iOException) {
            this.writer = null;
            this.currentLogFile = null;
            log.error((Object)sm.getString("accessLogValve.openFail", new Object[]{file, System.getProperty("user.name")}), (Throwable)iOException);
        }
        this.checkForOldLogs = true;
    }

    private static Date getDate(long l) {
        Date date = localDate.get();
        date.setTime(l);
        return date;
    }

    protected static Locale findLocale(String string, Locale locale) {
        if (string == null || string.isEmpty()) {
            return Locale.getDefault();
        }
        for (Locale locale2 : Locale.getAvailableLocales()) {
            if (!string.equals(locale2.toString())) continue;
            return locale2;
        }
        log.error((Object)sm.getString("accessLogValve.invalidLocale", new Object[]{string}));
        return locale;
    }

    @Override
    protected synchronized void startInternal() throws LifecycleException {
        String string = this.getFileDateFormat();
        this.fileDateFormatter = new SimpleDateFormat(string, Locale.US);
        this.fileDateFormatter.setTimeZone(TimeZone.getDefault());
        this.dateStamp = this.fileDateFormatter.format(new Date(System.currentTimeMillis()));
        if (this.rotatable && this.renameOnRotate) {
            this.restore();
        }
        this.open();
        this.setState(LifecycleState.STARTING);
    }

    @Override
    protected synchronized void stopInternal() throws LifecycleException {
        this.setState(LifecycleState.STOPPING);
        this.close(false);
    }

    protected AccessLogElement[] createLogElements() {
        ArrayList<AccessLogElement> arrayList = new ArrayList<AccessLogElement>();
        boolean bl = false;
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < this.pattern.length(); ++i) {
            char c = this.pattern.charAt(i);
            if (bl) {
                if ('{' == c) {
                    int n;
                    StringBuilder stringBuilder2 = new StringBuilder();
                    for (n = i + 1; n < this.pattern.length() && '}' != this.pattern.charAt(n); ++n) {
                        stringBuilder2.append(this.pattern.charAt(n));
                    }
                    if (n + 1 < this.pattern.length()) {
                        arrayList.add(this.createAccessLogElement(stringBuilder2.toString(), this.pattern.charAt(++n)));
                        i = n;
                    } else {
                        arrayList.add(this.createAccessLogElement(c));
                    }
                } else {
                    arrayList.add(this.createAccessLogElement(c));
                }
                bl = false;
                continue;
            }
            if (c == '%') {
                bl = true;
                arrayList.add(new StringElement(stringBuilder.toString()));
                stringBuilder = new StringBuilder();
                continue;
            }
            stringBuilder.append(c);
        }
        if (stringBuilder.length() > 0) {
            arrayList.add(new StringElement(stringBuilder.toString()));
        }
        return arrayList.toArray(new AccessLogElement[0]);
    }

    protected AccessLogElement createAccessLogElement(String string, char c) {
        switch (c) {
            case 'i': {
                return new HeaderElement(string);
            }
            case 'c': {
                return new CookieElement(string);
            }
            case 'o': {
                return new ResponseHeaderElement(string);
            }
            case 'p': {
                return new PortElement(string);
            }
            case 'r': {
                return new RequestAttributeElement(string);
            }
            case 's': {
                return new SessionAttributeElement(string);
            }
            case 't': {
                return new DateAndTimeElement(string);
            }
        }
        return new StringElement("???");
    }

    protected AccessLogElement createAccessLogElement(char c) {
        switch (c) {
            case 'a': {
                return new RemoteAddrElement();
            }
            case 'A': {
                return new LocalAddrElement();
            }
            case 'b': {
                return new ByteSentElement(true);
            }
            case 'B': {
                return new ByteSentElement(false);
            }
            case 'D': {
                return new ElapsedTimeElement(true);
            }
            case 'F': {
                return new FirstByteTimeElement();
            }
            case 'h': {
                return new HostElement();
            }
            case 'H': {
                return new ProtocolElement();
            }
            case 'l': {
                return new LogicalUserNameElement();
            }
            case 'm': {
                return new MethodElement();
            }
            case 'p': {
                return new PortElement();
            }
            case 'q': {
                return new QueryElement();
            }
            case 'r': {
                return new RequestElement();
            }
            case 's': {
                return new HttpStatusCodeElement();
            }
            case 'S': {
                return new SessionIdElement();
            }
            case 't': {
                return new DateAndTimeElement();
            }
            case 'T': {
                return new ElapsedTimeElement(false);
            }
            case 'u': {
                return new UserElement();
            }
            case 'U': {
                return new RequestURIElement();
            }
            case 'v': {
                return new LocalServerNameElement();
            }
            case 'I': {
                return new ThreadNameElement();
            }
        }
        return new StringElement("???" + c + "???");
    }

    protected static class SessionAttributeElement
    implements AccessLogElement {
        private final String header;

        public SessionAttributeElement(String string) {
            this.header = string;
        }

        @Override
        public void addElement(StringBuilder stringBuilder, Date date, Request request, Response response, long l) {
            Object object = null;
            if (null != request) {
                HttpSession httpSession = request.getSession(false);
                if (null != httpSession) {
                    object = httpSession.getAttribute(this.header);
                }
            } else {
                object = "??";
            }
            if (object != null) {
                if (object instanceof String) {
                    stringBuilder.append((String)object);
                } else {
                    stringBuilder.append(object.toString());
                }
            } else {
                stringBuilder.append('-');
            }
        }
    }

    protected static class RequestAttributeElement
    implements AccessLogElement {
        private final String header;

        public RequestAttributeElement(String string) {
            this.header = string;
        }

        @Override
        public void addElement(StringBuilder stringBuilder, Date date, Request request, Response response, long l) {
            Object object = null;
            object = request != null ? request.getAttribute(this.header) : "??";
            if (object != null) {
                if (object instanceof String) {
                    stringBuilder.append((String)object);
                } else {
                    stringBuilder.append(object.toString());
                }
            } else {
                stringBuilder.append('-');
            }
        }
    }

    protected static class ResponseHeaderElement
    implements AccessLogElement {
        private final String header;

        public ResponseHeaderElement(String string) {
            this.header = string;
        }

        @Override
        public void addElement(StringBuilder stringBuilder, Date date, Request request, Response response, long l) {
            Iterator<String> iterator;
            if (null != response && (iterator = response.getHeaders(this.header).iterator()).hasNext()) {
                stringBuilder.append(iterator.next());
                while (iterator.hasNext()) {
                    stringBuilder.append(',').append(iterator.next());
                }
                return;
            }
            stringBuilder.append('-');
        }
    }

    protected static class CookieElement
    implements AccessLogElement {
        private final String header;

        public CookieElement(String string) {
            this.header = string;
        }

        @Override
        public void addElement(StringBuilder stringBuilder, Date date, Request request, Response response, long l) {
            String string = "-";
            Cookie[] cookieArray = request.getCookies();
            if (cookieArray != null) {
                for (int i = 0; i < cookieArray.length; ++i) {
                    if (!this.header.equals(cookieArray[i].getName())) continue;
                    string = cookieArray[i].getValue();
                    break;
                }
            }
            stringBuilder.append(string);
        }
    }

    protected static class HeaderElement
    implements AccessLogElement {
        private final String header;

        public HeaderElement(String string) {
            this.header = string;
        }

        @Override
        public void addElement(StringBuilder stringBuilder, Date date, Request request, Response response, long l) {
            Enumeration<String> enumeration = request.getHeaders(this.header);
            if (enumeration.hasMoreElements()) {
                stringBuilder.append(enumeration.nextElement());
                while (enumeration.hasMoreElements()) {
                    stringBuilder.append(',').append(enumeration.nextElement());
                }
                return;
            }
            stringBuilder.append('-');
        }
    }

    protected static class StringElement
    implements AccessLogElement {
        private final String str;

        public StringElement(String string) {
            this.str = string;
        }

        @Override
        public void addElement(StringBuilder stringBuilder, Date date, Request request, Response response, long l) {
            stringBuilder.append(this.str);
        }
    }

    protected class LocalServerNameElement
    implements AccessLogElement {
        protected LocalServerNameElement() {
        }

        @Override
        public void addElement(StringBuilder stringBuilder, Date date, Request request, Response response, long l) {
            Object object;
            String string = null;
            if (AccessLogValve.this.requestAttributesEnabled && (object = request.getAttribute("org.apache.catalina.AccessLog.ServerName")) != null) {
                string = object.toString();
            }
            if (string == null || string.length() == 0) {
                string = request.getServerName();
            }
            if (string == null || string.length() == 0) {
                string = "-";
            }
            stringBuilder.append(string);
        }
    }

    protected static class RequestURIElement
    implements AccessLogElement {
        protected RequestURIElement() {
        }

        @Override
        public void addElement(StringBuilder stringBuilder, Date date, Request request, Response response, long l) {
            if (request != null) {
                stringBuilder.append(request.getRequestURI());
            } else {
                stringBuilder.append('-');
            }
        }
    }

    protected static class SessionIdElement
    implements AccessLogElement {
        protected SessionIdElement() {
        }

        @Override
        public void addElement(StringBuilder stringBuilder, Date date, Request request, Response response, long l) {
            if (request == null) {
                stringBuilder.append('-');
            } else {
                Session session = request.getSessionInternal(false);
                if (session == null) {
                    stringBuilder.append('-');
                } else {
                    stringBuilder.append(session.getIdInternal());
                }
            }
        }
    }

    protected static class QueryElement
    implements AccessLogElement {
        protected QueryElement() {
        }

        @Override
        public void addElement(StringBuilder stringBuilder, Date date, Request request, Response response, long l) {
            String string = null;
            if (request != null) {
                string = request.getQueryString();
            }
            if (string != null) {
                stringBuilder.append('?');
                stringBuilder.append(string);
            }
        }
    }

    protected static class FirstByteTimeElement
    implements AccessLogElement {
        protected FirstByteTimeElement() {
        }

        @Override
        public void addElement(StringBuilder stringBuilder, Date date, Request request, Response response, long l) {
            long l2 = response.getCoyoteResponse().getCommitTime();
            if (l2 == -1L) {
                stringBuilder.append('-');
            } else {
                long l3 = l2 - request.getCoyoteRequest().getStartTime();
                stringBuilder.append(Long.toString(l3));
            }
        }
    }

    protected static class ElapsedTimeElement
    implements AccessLogElement {
        private final boolean millis;

        public ElapsedTimeElement(boolean bl) {
            this.millis = bl;
        }

        @Override
        public void addElement(StringBuilder stringBuilder, Date date, Request request, Response response, long l) {
            if (this.millis) {
                stringBuilder.append(l);
            } else {
                stringBuilder.append(l / 1000L);
                stringBuilder.append('.');
                int n = (int)(l % 1000L);
                stringBuilder.append(n / 100);
                stringBuilder.append((n %= 100) / 10);
                stringBuilder.append(n % 10);
            }
        }
    }

    protected static class MethodElement
    implements AccessLogElement {
        protected MethodElement() {
        }

        @Override
        public void addElement(StringBuilder stringBuilder, Date date, Request request, Response response, long l) {
            if (request != null) {
                stringBuilder.append(request.getMethod());
            }
        }
    }

    protected static class ByteSentElement
    implements AccessLogElement {
        private final boolean conversion;

        public ByteSentElement(boolean bl) {
            this.conversion = bl;
        }

        @Override
        public void addElement(StringBuilder stringBuilder, Date date, Request request, Response response, long l) {
            Object object;
            Object object2;
            long l2 = response.getBytesWritten(false);
            if (l2 <= 0L && (object2 = request.getAttribute("org.apache.tomcat.sendfile.start")) instanceof Long && (object = request.getAttribute("org.apache.tomcat.sendfile.end")) instanceof Long) {
                l2 = (Long)object - (Long)object2;
            }
            if (l2 <= 0L && this.conversion) {
                stringBuilder.append('-');
            } else {
                stringBuilder.append(l2);
            }
        }
    }

    protected class PortElement
    implements AccessLogElement {
        private static final String localPort = "local";
        private static final String remotePort = "remote";
        private final PortType portType;

        public PortElement() {
            this.portType = PortType.LOCAL;
        }

        public PortElement(String string) {
            if (string.equals(localPort)) {
                this.portType = PortType.LOCAL;
            } else if (string.equals(remotePort)) {
                this.portType = PortType.REMOTE;
            } else {
                this.portType = PortType.LOCAL;
                log.error((Object)ValveBase.sm.getString("accessLogValve.invalidPortType", new Object[]{string}));
            }
        }

        @Override
        public void addElement(StringBuilder stringBuilder, Date date, Request request, Response response, long l) {
            if (AccessLogValve.this.requestAttributesEnabled && this.portType == PortType.LOCAL) {
                Object object = request.getAttribute("org.apache.catalina.AccessLog.ServerPort");
                if (object == null) {
                    stringBuilder.append(request.getServerPort());
                } else {
                    stringBuilder.append(object);
                }
            } else if (this.portType == PortType.LOCAL) {
                stringBuilder.append(Integer.toString(request.getServerPort()));
            } else {
                stringBuilder.append(Integer.toString(request.getRemotePort()));
            }
        }
    }

    protected static class HttpStatusCodeElement
    implements AccessLogElement {
        protected HttpStatusCodeElement() {
        }

        @Override
        public void addElement(StringBuilder stringBuilder, Date date, Request request, Response response, long l) {
            if (response != null) {
                stringBuilder.append(response.getStatus());
            } else {
                stringBuilder.append('-');
            }
        }
    }

    protected static class RequestElement
    implements AccessLogElement {
        protected RequestElement() {
        }

        @Override
        public void addElement(StringBuilder stringBuilder, Date date, Request request, Response response, long l) {
            if (request != null) {
                String string = request.getMethod();
                if (string == null) {
                    stringBuilder.append('-');
                } else {
                    stringBuilder.append(request.getMethod());
                    stringBuilder.append(' ');
                    stringBuilder.append(request.getRequestURI());
                    if (request.getQueryString() != null) {
                        stringBuilder.append('?');
                        stringBuilder.append(request.getQueryString());
                    }
                    stringBuilder.append(' ');
                    stringBuilder.append(request.getProtocol());
                }
            } else {
                stringBuilder.append('-');
            }
        }
    }

    protected class DateAndTimeElement
    implements AccessLogElement {
        private static final String requestStartPrefix = "begin";
        private static final String responseEndPrefix = "end";
        private static final String prefixSeparator = ":";
        private static final String secFormat = "sec";
        private static final String msecFormat = "msec";
        private static final String msecFractionFormat = "msec_frac";
        private static final String msecPattern = "{#}";
        private static final String trippleMsecPattern = "{#}{#}{#}";
        private String format = null;
        private boolean usesBegin = false;
        private FormatType type = FormatType.CLF;
        private boolean usesMsecs = false;

        protected DateAndTimeElement() {
            this(null);
        }

        private String tidyFormat(String string) {
            boolean bl = false;
            StringBuilder stringBuilder = new StringBuilder();
            int n = string.length();
            for (int i = 0; i < n; ++i) {
                char c = string.charAt(i);
                if (bl || c != 'S') {
                    stringBuilder.append(c);
                } else {
                    stringBuilder.append(msecPattern);
                    this.usesMsecs = true;
                }
                if (c != '\'') continue;
                bl = !bl;
            }
            return stringBuilder.toString();
        }

        protected DateAndTimeElement(String string) {
            this.format = string;
            if (this.format != null) {
                if (this.format.equals(requestStartPrefix)) {
                    this.usesBegin = true;
                    this.format = "";
                } else if (this.format.startsWith("begin:")) {
                    this.usesBegin = true;
                    this.format = this.format.substring(6);
                } else if (this.format.equals(responseEndPrefix)) {
                    this.usesBegin = false;
                    this.format = "";
                } else if (this.format.startsWith("end:")) {
                    this.usesBegin = false;
                    this.format = this.format.substring(4);
                }
                if (this.format.length() == 0) {
                    this.type = FormatType.CLF;
                } else if (this.format.equals(secFormat)) {
                    this.type = FormatType.SEC;
                } else if (this.format.equals(msecFormat)) {
                    this.type = FormatType.MSEC;
                } else if (this.format.equals(msecFractionFormat)) {
                    this.type = FormatType.MSEC_FRAC;
                } else {
                    this.type = FormatType.SDF;
                    this.format = this.tidyFormat(this.format);
                }
            }
        }

        @Override
        public void addElement(StringBuilder stringBuilder, Date date, Request request, Response response, long l) {
            long l2 = date.getTime();
            if (this.usesBegin) {
                l2 -= l;
            }
            switch (this.type) {
                case CLF: {
                    stringBuilder.append(((DateFormatCache)localDateCache.get()).getFormat(l2));
                    break;
                }
                case SEC: {
                    stringBuilder.append(l2 / 1000L);
                    break;
                }
                case MSEC: {
                    stringBuilder.append(l2);
                    break;
                }
                case MSEC_FRAC: {
                    long l3 = l2 % 1000L;
                    if (l3 < 100L) {
                        if (l3 < 10L) {
                            stringBuilder.append('0');
                            stringBuilder.append('0');
                        } else {
                            stringBuilder.append('0');
                        }
                    }
                    stringBuilder.append(l3);
                    break;
                }
                case SDF: {
                    String string = ((DateFormatCache)localDateCache.get()).getFormat(this.format, AccessLogValve.this.locale, l2);
                    if (this.usesMsecs) {
                        long l4 = l2 % 1000L;
                        StringBuilder stringBuilder2 = new StringBuilder(4);
                        if (l4 < 100L) {
                            if (l4 < 10L) {
                                stringBuilder2.append('0');
                                stringBuilder2.append('0');
                            } else {
                                stringBuilder2.append('0');
                            }
                        }
                        stringBuilder2.append(l4);
                        string = string.replace(trippleMsecPattern, stringBuilder2);
                        string = string.replace(msecPattern, Long.toString(l4));
                    }
                    stringBuilder.append(string);
                }
            }
        }
    }

    protected static class UserElement
    implements AccessLogElement {
        protected UserElement() {
        }

        @Override
        public void addElement(StringBuilder stringBuilder, Date date, Request request, Response response, long l) {
            if (request != null) {
                String string = request.getRemoteUser();
                if (string != null) {
                    stringBuilder.append(string);
                } else {
                    stringBuilder.append('-');
                }
            } else {
                stringBuilder.append('-');
            }
        }
    }

    protected class ProtocolElement
    implements AccessLogElement {
        protected ProtocolElement() {
        }

        @Override
        public void addElement(StringBuilder stringBuilder, Date date, Request request, Response response, long l) {
            if (AccessLogValve.this.requestAttributesEnabled) {
                Object object = request.getAttribute("org.apache.catalina.AccessLog.Protocol");
                if (object == null) {
                    stringBuilder.append(request.getProtocol());
                } else {
                    stringBuilder.append(object);
                }
            } else {
                stringBuilder.append(request.getProtocol());
            }
        }
    }

    protected static class LogicalUserNameElement
    implements AccessLogElement {
        protected LogicalUserNameElement() {
        }

        @Override
        public void addElement(StringBuilder stringBuilder, Date date, Request request, Response response, long l) {
            stringBuilder.append('-');
        }
    }

    protected class HostElement
    implements AccessLogElement {
        protected HostElement() {
        }

        @Override
        public void addElement(StringBuilder stringBuilder, Date date, Request request, Response response, long l) {
            Object object;
            String string = null;
            if (AccessLogValve.this.requestAttributesEnabled && (object = request.getAttribute("org.apache.catalina.AccessLog.RemoteHost")) != null) {
                string = object.toString();
            }
            if (string == null || string.length() == 0) {
                string = request.getRemoteHost();
            }
            if (string == null || string.length() == 0) {
                string = "-";
            }
            stringBuilder.append(string);
        }
    }

    protected class RemoteAddrElement
    implements AccessLogElement {
        protected RemoteAddrElement() {
        }

        @Override
        public void addElement(StringBuilder stringBuilder, Date date, Request request, Response response, long l) {
            if (AccessLogValve.this.requestAttributesEnabled) {
                Object object = request.getAttribute("org.apache.catalina.AccessLog.RemoteAddr");
                if (object == null) {
                    stringBuilder.append(request.getRemoteAddr());
                } else {
                    stringBuilder.append(object);
                }
            } else {
                stringBuilder.append(request.getRemoteAddr());
            }
        }
    }

    protected static class LocalAddrElement
    implements AccessLogElement {
        private static final String LOCAL_ADDR_VALUE;

        protected LocalAddrElement() {
        }

        @Override
        public void addElement(StringBuilder stringBuilder, Date date, Request request, Response response, long l) {
            stringBuilder.append(LOCAL_ADDR_VALUE);
        }

        static {
            String string;
            try {
                string = InetAddress.getLocalHost().getHostAddress();
            }
            catch (Throwable throwable) {
                ExceptionUtils.handleThrowable((Throwable)throwable);
                string = "127.0.0.1";
            }
            LOCAL_ADDR_VALUE = string;
        }
    }

    protected static class ThreadNameElement
    implements AccessLogElement {
        protected ThreadNameElement() {
        }

        @Override
        public void addElement(StringBuilder stringBuilder, Date date, Request request, Response response, long l) {
            RequestInfo requestInfo = request.getCoyoteRequest().getRequestProcessor();
            if (requestInfo != null) {
                stringBuilder.append(requestInfo.getWorkerThreadName());
            } else {
                stringBuilder.append("-");
            }
        }
    }

    protected static interface AccessLogElement {
        public void addElement(StringBuilder var1, Date var2, Request var3, Response var4, long var5);
    }

    protected static class DateFormatCache {
        private int cacheSize = 0;
        private final Locale cacheDefaultLocale;
        private final DateFormatCache parent;
        protected final Cache cLFCache;
        private final HashMap<String, Cache> formatCache = new HashMap();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected DateFormatCache(int n, Locale locale, DateFormatCache dateFormatCache) {
            this.cacheSize = n;
            this.cacheDefaultLocale = locale;
            this.parent = dateFormatCache;
            Cache cache = null;
            if (dateFormatCache != null) {
                DateFormatCache dateFormatCache2 = dateFormatCache;
                synchronized (dateFormatCache2) {
                    cache = dateFormatCache.getCache(null, null);
                }
            }
            this.cLFCache = new Cache(cache);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Cache getCache(String string, Locale locale) {
            Cache cache;
            if (string == null) {
                cache = this.cLFCache;
            } else {
                cache = this.formatCache.get(string);
                if (cache == null) {
                    Cache cache2 = null;
                    if (this.parent != null) {
                        DateFormatCache dateFormatCache = this.parent;
                        synchronized (dateFormatCache) {
                            cache2 = this.parent.getCache(string, locale);
                        }
                    }
                    cache = new Cache(string, locale, cache2);
                    this.formatCache.put(string, cache);
                }
            }
            return cache;
        }

        public String getFormat(long l) {
            return this.cLFCache.getFormatInternal(l);
        }

        public String getFormat(String string, Locale locale, long l) {
            return this.getCache(string, locale).getFormatInternal(l);
        }

        protected class Cache {
            private static final String cLFFormat = "dd/MMM/yyyy:HH:mm:ss Z";
            private long previousSeconds = Long.MIN_VALUE;
            private String previousFormat = "";
            private long first = Long.MIN_VALUE;
            private long last = Long.MIN_VALUE;
            private int offset = 0;
            private final Date currentDate = new Date();
            protected final String[] cache;
            private SimpleDateFormat formatter;
            private boolean isCLF = false;
            private Cache parent = null;

            private Cache(Cache cache) {
                this(null, cache);
            }

            private Cache(String string, Cache cache) {
                this(string, null, cache);
            }

            private Cache(String string, Locale locale, Cache cache) {
                this.cache = new String[DateFormatCache.this.cacheSize];
                for (int i = 0; i < DateFormatCache.this.cacheSize; ++i) {
                    this.cache[i] = null;
                }
                if (locale == null) {
                    locale = DateFormatCache.this.cacheDefaultLocale;
                }
                if (string == null) {
                    this.isCLF = true;
                    string = cLFFormat;
                    this.formatter = new SimpleDateFormat(string, Locale.US);
                } else {
                    this.formatter = new SimpleDateFormat(string, locale);
                }
                this.formatter.setTimeZone(TimeZone.getDefault());
                this.parent = cache;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private String getFormatInternal(long l) {
                int n;
                long l2 = l / 1000L;
                if (l2 == this.previousSeconds) {
                    return this.previousFormat;
                }
                this.previousSeconds = l2;
                int n2 = (this.offset + (int)(l2 - this.first)) % DateFormatCache.this.cacheSize;
                if (n2 < 0) {
                    n2 += DateFormatCache.this.cacheSize;
                }
                if (l2 >= this.first && l2 <= this.last) {
                    if (this.cache[n2] != null) {
                        this.previousFormat = this.cache[n2];
                        return this.previousFormat;
                    }
                } else if (l2 >= this.last + (long)DateFormatCache.this.cacheSize || l2 <= this.first - (long)DateFormatCache.this.cacheSize) {
                    this.first = l2;
                    this.last = this.first + (long)DateFormatCache.this.cacheSize - 1L;
                    n2 = 0;
                    this.offset = 0;
                    for (n = 1; n < DateFormatCache.this.cacheSize; ++n) {
                        this.cache[n] = null;
                    }
                } else if (l2 > this.last) {
                    n = 1;
                    while ((long)n < l2 - this.last) {
                        this.cache[(n2 + ((DateFormatCache)DateFormatCache.this).cacheSize - n) % ((DateFormatCache)DateFormatCache.this).cacheSize] = null;
                        ++n;
                    }
                    this.first = l2 - (long)(DateFormatCache.this.cacheSize - 1);
                    this.last = l2;
                    this.offset = (n2 + 1) % DateFormatCache.this.cacheSize;
                } else if (l2 < this.first) {
                    n = 1;
                    while ((long)n < this.first - l2) {
                        this.cache[(n2 + n) % ((DateFormatCache)DateFormatCache.this).cacheSize] = null;
                        ++n;
                    }
                    this.first = l2;
                    this.last = l2 + (long)(DateFormatCache.this.cacheSize - 1);
                    this.offset = n2;
                }
                if (this.parent != null) {
                    Cache cache = this.parent;
                    synchronized (cache) {
                        this.previousFormat = this.parent.getFormatInternal(l);
                    }
                } else {
                    this.currentDate.setTime(l);
                    this.previousFormat = this.formatter.format(this.currentDate);
                    if (this.isCLF) {
                        StringBuilder stringBuilder = new StringBuilder(32);
                        stringBuilder.append('[');
                        stringBuilder.append(this.previousFormat);
                        stringBuilder.append(']');
                        this.previousFormat = stringBuilder.toString();
                    }
                }
                this.cache[n2] = this.previousFormat;
                return this.previousFormat;
            }
        }
    }

    private static enum PortType {
        LOCAL,
        REMOTE;

    }

    private static enum FormatType {
        CLF,
        SEC,
        MSEC,
        MSEC_FRAC,
        SDF;

    }
}

