/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.websocket;

import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CoderResult;
import org.apache.catalina.util.Conversions;
import org.apache.coyote.http11.upgrade.UpgradeProcessor;
import org.apache.tomcat.util.buf.Utf8Decoder;
import org.apache.tomcat.util.res.StringManager;

@Deprecated
public class WsFrame {
    private static final StringManager sm = StringManager.getManager((String)"org.apache.catalina.websocket");
    private final boolean fin;
    private final int rsv;
    private final byte opCode;
    private final byte[] mask = new byte[4];
    private long payloadLength;
    private final ByteBuffer payload;

    private WsFrame(byte by, UpgradeProcessor<?> upgradeProcessor) throws IOException {
        Object object;
        int n = by & 0xFF;
        this.fin = (n & 0x80) > 0;
        this.rsv = (n & 0x70) >>> 4;
        this.opCode = (byte)(n & 0xF);
        n = this.blockingRead(upgradeProcessor);
        if ((n & 0x80) == 0) {
            throw new IOException(sm.getString("frame.notMasked"));
        }
        this.payloadLength = n & 0x7F;
        if (this.payloadLength == 126L) {
            object = new byte[2];
            this.blockingRead(upgradeProcessor, (byte[])object);
            this.payloadLength = Conversions.byteArrayToLong(object);
        } else if (this.payloadLength == 127L) {
            object = new byte[8];
            this.blockingRead(upgradeProcessor, (byte[])object);
            this.payloadLength = Conversions.byteArrayToLong(object);
        }
        if (this.payloadLength < 0L) {
            throw new IOException(sm.getString("frame.invalidLength"));
        }
        if (this.isControl()) {
            if (this.payloadLength > 125L) {
                throw new IOException();
            }
            if (!this.fin) {
                throw new IOException();
            }
        }
        this.blockingRead(upgradeProcessor, this.mask);
        if (this.isControl()) {
            this.payload = ByteBuffer.allocate((int)this.payloadLength);
            this.blockingRead(upgradeProcessor, this.payload);
            if (this.opCode == 8 && this.payloadLength > 2L) {
                object = CharBuffer.allocate((int)this.payloadLength);
                Utf8Decoder utf8Decoder = new Utf8Decoder();
                this.payload.position(2);
                CoderResult coderResult = utf8Decoder.decode(this.payload, (CharBuffer)object, true);
                this.payload.position(0);
                if (coderResult.isError()) {
                    throw new IOException(sm.getString("frame.invalidUtf8"));
                }
            }
        } else {
            this.payload = null;
        }
    }

    public boolean getFin() {
        return this.fin;
    }

    public int getRsv() {
        return this.rsv;
    }

    public byte getOpCode() {
        return this.opCode;
    }

    public boolean isControl() {
        return (this.opCode & 8) > 0;
    }

    public byte[] getMask() {
        return this.mask;
    }

    public long getPayLoadLength() {
        return this.payloadLength;
    }

    public ByteBuffer getPayLoad() {
        return this.payload;
    }

    private int blockingRead(UpgradeProcessor<?> upgradeProcessor) throws IOException {
        int n = upgradeProcessor.read();
        if (n == -1) {
            throw new IOException(sm.getString("frame.eos"));
        }
        return n;
    }

    private void blockingRead(UpgradeProcessor<?> upgradeProcessor, byte[] byArray) throws IOException {
        int n = 0;
        for (int i = 0; i < byArray.length; i += n) {
            n = upgradeProcessor.read(true, byArray, i, byArray.length - i);
            if (n != -1) continue;
            throw new IOException(sm.getString("frame.eos"));
        }
    }

    private void blockingRead(UpgradeProcessor<?> upgradeProcessor, ByteBuffer byteBuffer) throws IOException {
        int n = 0;
        while (byteBuffer.hasRemaining()) {
            n = upgradeProcessor.read();
            if (n == -1) {
                throw new IOException(sm.getString("frame.eos"));
            }
            byteBuffer.put((byte)(n ^ this.mask[byteBuffer.position() % 4]));
        }
        byteBuffer.flip();
    }

    public static WsFrame nextFrame(UpgradeProcessor<?> upgradeProcessor, boolean bl) throws IOException {
        byte[] byArray = new byte[1];
        int n = upgradeProcessor.read(bl, byArray, 0, 1);
        if (n == 1) {
            return new WsFrame(byArray[0], upgradeProcessor);
        }
        if (n == 0) {
            return null;
        }
        if (n == -1) {
            throw new EOFException(sm.getString("frame.readEos"));
        }
        throw new IOException(sm.getString("frame.readFailed", new Object[]{n}));
    }
}

